/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.spi.plugin;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import io.airlift.resolver.ArtifactResolver;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dolphinscheduler.spi.DolphinSchedulerPlugin;
import org.apache.dolphinscheduler.spi.classloader.ThreadContextClassLoader;
import org.apache.dolphinscheduler.spi.plugin.AbstractDolphinPluginManager;
import org.apache.dolphinscheduler.spi.plugin.DolphinPluginClassLoader;
import org.apache.dolphinscheduler.spi.plugin.DolphinPluginDiscovery;
import org.apache.dolphinscheduler.spi.plugin.DolphinPluginManagerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.artifact.Artifact;

public class DolphinPluginLoader {
    private static final Logger logger = LoggerFactory.getLogger(DolphinPluginLoader.class);
    private static final ImmutableList<String> DOLPHIN_SPI_PACKAGES = ImmutableList.builder().add((Object)"org.apache.dolphinscheduler.spi.").add((Object)"com.fasterxml.jackson.").add((Object)"org.slf4j").build();
    private final File installedPluginsDir;
    private final List<String> configPlugins;
    private ArtifactResolver resolver = null;
    private final List<AbstractDolphinPluginManager> dolphinPluginManagerList;

    public DolphinPluginLoader(DolphinPluginManagerConfig config, List<AbstractDolphinPluginManager> dolphinPluginManagerList) {
        this.installedPluginsDir = config.getInstalledPluginsDir();
        this.configPlugins = config.getPlugins() == null ? ImmutableList.of() : ImmutableList.copyOf(config.getPlugins());
        this.dolphinPluginManagerList = Objects.requireNonNull(dolphinPluginManagerList, "dolphinPluginManagerList is null");
        if (this.configPlugins != null && this.configPlugins.size() > 0) {
            this.resolver = new ArtifactResolver(config.getMavenLocalRepository(), config.getMavenRemoteRepository());
        }
    }

    public void loadPlugins() throws Exception {
        for (File file : DolphinPluginLoader.listPluginInstanceDirs(this.installedPluginsDir)) {
            if (!file.isDirectory()) continue;
            this.loadPlugin(file.getAbsolutePath());
        }
        for (String plugin : this.configPlugins) {
            this.loadPlugin(plugin);
        }
    }

    private void loadPlugin(String plugin) throws Exception {
        logger.info("-- Loading plugin {} --", (Object)plugin);
        URLClassLoader pluginClassLoader = this.buildPluginClassLoader(plugin);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(pluginClassLoader);){
            this.loadPlugin(pluginClassLoader);
        }
        logger.info("-- Finished loading plugin {} --", (Object)plugin);
    }

    private void loadPlugin(URLClassLoader pluginClassLoader) {
        ServiceLoader<DolphinSchedulerPlugin> serviceLoader = ServiceLoader.load(DolphinSchedulerPlugin.class, pluginClassLoader);
        ImmutableList plugins = ImmutableList.copyOf(serviceLoader);
        Preconditions.checkState((!plugins.isEmpty() ? 1 : 0) != 0, (String)"No service providers the plugin %s", (Object)DolphinSchedulerPlugin.class.getName());
        for (DolphinSchedulerPlugin plugin : plugins) {
            logger.info("Installing {}", (Object)plugin.getClass().getName());
            for (AbstractDolphinPluginManager dolphinPluginManager : this.dolphinPluginManagerList) {
                dolphinPluginManager.installPlugin(plugin);
            }
        }
    }

    private URLClassLoader buildPluginClassLoader(String plugin) throws Exception {
        File file = new File(plugin);
        if (!file.isDirectory() && (file.getName().equals("pom.xml") || file.getName().endsWith(".pom"))) {
            return this.buildPluginClassLoaderFromPom(file);
        }
        if (file.isDirectory()) {
            return this.buildPluginClassLoaderFromDirectory(file);
        }
        throw new IllegalArgumentException(String.format("plugin must be a pom file or directory %s .", plugin));
    }

    private URLClassLoader buildPluginClassLoaderFromPom(File pomFile) throws Exception {
        List artifacts = this.resolver.resolvePom(pomFile);
        URLClassLoader classLoader = this.createClassLoader(artifacts, pomFile.getPath());
        Artifact artifact = (Artifact)artifacts.get(0);
        Set<String> plugins = DolphinPluginDiscovery.discoverPluginsFromArtifact(artifact, classLoader);
        if (!plugins.isEmpty()) {
            DolphinPluginDiscovery.writePluginServices(plugins, artifact.getFile());
        }
        return classLoader;
    }

    private URLClassLoader buildPluginClassLoaderFromDirectory(File dir) throws Exception {
        logger.info("Classpath for {}:", (Object)dir.getName());
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : DolphinPluginLoader.listPluginInstanceJars(dir)) {
            logger.info("   {}", (Object)file);
            urls.add(file.toURI().toURL());
        }
        return this.createClassLoader(urls);
    }

    private URLClassLoader createClassLoader(List<Artifact> artifacts, String name) throws IOException {
        logger.info("Classpath for {}:", (Object)name);
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Artifact artifact : DolphinPluginLoader.sortArtifacts(artifacts)) {
            if (artifact.getFile() == null) {
                throw new RuntimeException("Could not resolve artifact: " + artifact);
            }
            File file = artifact.getFile().getCanonicalFile();
            logger.info("    {}", (Object)file);
            urls.add(file.toURI().toURL());
        }
        return this.createClassLoader(urls);
    }

    private URLClassLoader createClassLoader(List<URL> urls) {
        ClassLoader parent = this.getClass().getClassLoader();
        return new DolphinPluginClassLoader(urls, parent, (Iterable<String>)DOLPHIN_SPI_PACKAGES);
    }

    private static List<File> listPluginInstanceDirs(File installedPluginsDir) {
        Object[] files;
        if (installedPluginsDir != null && installedPluginsDir.isDirectory() && (files = installedPluginsDir.listFiles()) != null) {
            Optional<File> isNotDir = Arrays.stream(files).filter(file -> !file.isDirectory()).findAny();
            if (isNotDir.isPresent()) {
                return ImmutableList.of((Object)installedPluginsDir);
            }
            Arrays.sort(files);
            return ImmutableList.copyOf((Object[])files);
        }
        return ImmutableList.of();
    }

    private static List<File> listPluginInstanceJars(File installedPluginsDir) {
        File[] files;
        if (installedPluginsDir != null && installedPluginsDir.isDirectory() && (files = installedPluginsDir.listFiles()) != null) {
            return ImmutableList.copyOf((Collection)Arrays.stream(files).filter(file -> file.isFile() && file.getName().endsWith(".jar")).collect(Collectors.toList()));
        }
        return ImmutableList.of();
    }

    private static List<Artifact> sortArtifacts(List<Artifact> artifacts) {
        ArrayList<Artifact> list = new ArrayList<Artifact>(artifacts);
        list.sort((Comparator<Artifact>)Ordering.natural().nullsLast().onResultOf(Artifact::getFile));
        return list;
    }
}

