/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.spi.plugin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.dolphinscheduler.spi.DolphinSchedulerPlugin;
import org.objectweb.asm.ClassReader;
import org.sonatype.aether.artifact.Artifact;

final class DolphinPluginDiscovery {
    private static final String ARTIFACT_DIR = new StringJoiner(File.separator, File.separator, "").add("target").add("classes").toString();
    private static final String JAVA_CLASS_FILE_SUFFIX = ".class";
    private static final String PLUGIN_SERVICES_FILE = String.join((CharSequence)File.separator, "META-INF", "services", DolphinSchedulerPlugin.class.getName());

    private DolphinPluginDiscovery() {
    }

    static Set<String> discoverPluginsFromArtifact(Artifact artifact, ClassLoader classLoader) throws IOException {
        if (!artifact.getExtension().equals("dolphinscheduler-plugin")) {
            throw new RuntimeException("Unexpected extension for main artifact: " + artifact);
        }
        File file = artifact.getFile();
        if (!file.getPath().endsWith(ARTIFACT_DIR)) {
            throw new RuntimeException("Unexpected file for main artifact: " + file);
        }
        if (!file.isDirectory()) {
            throw new RuntimeException("Main artifact file is not a directory: " + file);
        }
        if (new File(file, PLUGIN_SERVICES_FILE).exists()) {
            return ImmutableSet.of();
        }
        return DolphinPluginDiscovery.listClasses(file.toPath()).stream().filter(name -> DolphinPluginDiscovery.classInterfaces(name, classLoader).contains(DolphinSchedulerPlugin.class.getName())).collect(Collectors.toSet());
    }

    static void writePluginServices(Iterable<String> plugins, File root) throws IOException {
        Path path = root.toPath().resolve(PLUGIN_SERVICES_FILE);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(path.toFile()), StandardCharsets.UTF_8);){
            for (String plugin : plugins) {
                out.write(plugin + "\n");
            }
        }
    }

    private static List<String> listClasses(final Path base) throws IOException {
        final ImmutableList.Builder list = ImmutableList.builder();
        Files.walkFileTree(base, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                if (file.getFileName().toString().endsWith(DolphinPluginDiscovery.JAVA_CLASS_FILE_SUFFIX)) {
                    String name = file.subpath(base.getNameCount(), file.getNameCount()).toString();
                    list.add((Object)DolphinPluginDiscovery.convertClassName(name.substring(0, name.length() - DolphinPluginDiscovery.JAVA_CLASS_FILE_SUFFIX.length())));
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return list.build();
    }

    private static List<String> classInterfaces(String name, ClassLoader classLoader) {
        ImmutableList.Builder list = ImmutableList.builder();
        ClassReader reader = DolphinPluginDiscovery.readClass(name, classLoader);
        for (String binaryName : reader.getInterfaces()) {
            list.add((Object)DolphinPluginDiscovery.javaName(binaryName));
        }
        if (reader.getSuperName() != null) {
            list.addAll(DolphinPluginDiscovery.classInterfaces(DolphinPluginDiscovery.javaName(reader.getSuperName()), classLoader));
        }
        return list.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ClassReader readClass(String name, ClassLoader classLoader) {
        try (InputStream in = classLoader.getResourceAsStream(DolphinPluginDiscovery.binaryName(name) + JAVA_CLASS_FILE_SUFFIX);){
            if (in == null) {
                throw new RuntimeException("Failed to read class: " + name);
            }
            ClassReader classReader = new ClassReader(ByteStreams.toByteArray((InputStream)in));
            return classReader;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String binaryName(String javaName) {
        return javaName.replace('.', '/');
    }

    private static String javaName(String binaryName) {
        return binaryName.replace('/', '.');
    }

    private static String convertClassName(String pathName) {
        return pathName.replace(File.separatorChar, '.');
    }
}

