/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.spi.plugin;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

class DolphinPluginClassLoader
extends URLClassLoader {
    private static final ClassLoader PLATFORM_CLASS_LOADER = DolphinPluginClassLoader.findPlatformClassLoader();
    private final ClassLoader spiClassLoader;
    private final List<String> spiPackages;
    private final List<String> spiResources;

    DolphinPluginClassLoader(List<URL> urls, ClassLoader spiClassLoader, Iterable<String> spiPackages) {
        this(urls, spiClassLoader, spiPackages, StreamSupport.stream(spiPackages.spliterator(), false).map(DolphinPluginClassLoader::classNameToResource).collect(Collectors.toList()));
    }

    private DolphinPluginClassLoader(List<URL> urls, ClassLoader spiClassLoader, Iterable<String> spiPackages, Iterable<String> spiResources) {
        super(urls.toArray(new URL[0]), PLATFORM_CLASS_LOADER);
        this.spiClassLoader = Objects.requireNonNull(spiClassLoader, "spiClassLoader is null");
        this.spiPackages = ImmutableList.copyOf(spiPackages);
        this.spiResources = ImmutableList.copyOf(spiResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> cachedClass = this.findLoadedClass(name);
            if (cachedClass != null) {
                return this.resolveClass(cachedClass, resolve);
            }
            if (this.isSpiClass(name)) {
                return this.resolveClass(this.spiClassLoader.loadClass(name), resolve);
            }
            return super.loadClass(name, resolve);
        }
    }

    private Class<?> resolveClass(Class<?> clazz, boolean resolve) {
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    public URL getResource(String name) {
        if (this.isSpiResource(name)) {
            return this.spiClassLoader.getResource(name);
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.isSpiClass(name)) {
            return this.spiClassLoader.getResources(name);
        }
        return super.getResources(name);
    }

    private boolean isSpiClass(String name) {
        return this.spiPackages.stream().anyMatch(name::startsWith);
    }

    private boolean isSpiResource(String name) {
        return this.spiResources.stream().anyMatch(name::startsWith);
    }

    private static String classNameToResource(String className) {
        return className.replace('.', '/');
    }

    private static ClassLoader findPlatformClassLoader() {
        try {
            Method method = ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]);
            return (ClassLoader)method.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException ignored) {
            return null;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }
}

