/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.spi.enums;

import com.google.common.base.Functions;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum DbType {
    MYSQL(0),
    POSTGRESQL(1),
    HIVE(2),
    SPARK(3),
    CLICKHOUSE(4),
    ORACLE(5),
    SQLSERVER(6),
    DB2(7),
    PRESTO(8),
    H2(9);

    private final int code;
    private static final Map<Integer, DbType> DB_TYPE_MAP;

    private DbType(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static DbType of(int type) {
        if (DB_TYPE_MAP.containsKey(type)) {
            return DB_TYPE_MAP.get(type);
        }
        return null;
    }

    static {
        DB_TYPE_MAP = Arrays.stream(DbType.values()).collect(Collectors.toMap(DbType::getCode, Functions.identity()));
    }
}

