/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.processor;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.DBTaskResponseCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.server.worker.cache.ResponceCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBTaskResponseProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(DBTaskResponseProcessor.class);

    public void process(Channel channel, Command command) {
        Preconditions.checkArgument((CommandType.DB_TASK_RESPONSE == command.getType() ? 1 : 0) != 0, (Object)String.format("invalid command type : %s", command.getType()));
        DBTaskResponseCommand taskResponseCommand = (DBTaskResponseCommand)JSONUtils.parseObject((byte[])command.getBody(), DBTaskResponseCommand.class);
        if (taskResponseCommand == null) {
            return;
        }
        if (taskResponseCommand.getStatus() == ExecutionStatus.SUCCESS.getCode()) {
            ResponceCache.get().removeResponseCache(taskResponseCommand.getTaskInstanceId());
        }
    }
}

