/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.plugin;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dolphinscheduler.common.enums.PluginType;
import org.apache.dolphinscheduler.dao.DaoFactory;
import org.apache.dolphinscheduler.dao.PluginDao;
import org.apache.dolphinscheduler.dao.entity.PluginDefine;
import org.apache.dolphinscheduler.spi.DolphinSchedulerPlugin;
import org.apache.dolphinscheduler.spi.classloader.ThreadContextClassLoader;
import org.apache.dolphinscheduler.spi.params.PluginParamsTransfer;
import org.apache.dolphinscheduler.spi.plugin.AbstractDolphinPluginManager;
import org.apache.dolphinscheduler.spi.task.TaskChannel;
import org.apache.dolphinscheduler.spi.task.TaskChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskPluginManager
extends AbstractDolphinPluginManager {
    private static final Logger logger = LoggerFactory.getLogger(TaskPluginManager.class);
    private final Map<String, TaskChannelFactory> taskChannelFactoryMap = new ConcurrentHashMap<String, TaskChannelFactory>();
    private final Map<String, TaskChannel> taskChannelMap = new ConcurrentHashMap<String, TaskChannel>();
    private final Map<Integer, String> pluginDefineMap = new HashMap<Integer, String>();
    private PluginDao pluginDao = (PluginDao)DaoFactory.getDaoInstance(PluginDao.class);

    private void addTaskChannelFactory(TaskChannelFactory taskChannelFactory) {
        Objects.requireNonNull(taskChannelFactory, "taskChannelFactory is null");
        if (this.taskChannelFactoryMap.putIfAbsent(taskChannelFactory.getName(), taskChannelFactory) != null) {
            throw new IllegalArgumentException(String.format("Task Plugin '%s' is already registered", taskChannelFactory.getName()));
        }
        try {
            this.loadTaskChannel(taskChannelFactory.getName());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Task Plugin '%s' is can not load .", taskChannelFactory.getName()));
        }
    }

    private void loadTaskChannel(String name) {
        Objects.requireNonNull(name, "name is null");
        TaskChannelFactory taskChannelFactory = this.taskChannelFactoryMap.get(name);
        Preconditions.checkState((taskChannelFactory != null ? 1 : 0) != 0, (String)"Task Plugin {} is not registered", (Object)name);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(taskChannelFactory.getClass().getClassLoader());){
            TaskChannel taskChannel = taskChannelFactory.create();
            this.taskChannelMap.put(name, taskChannel);
        }
        logger.info("-- Loaded Task Plugin {} --", (Object)name);
    }

    public Map<String, TaskChannel> getTaskChannelMap() {
        return this.taskChannelMap;
    }

    public void installPlugin(DolphinSchedulerPlugin dolphinSchedulerPlugin) {
        for (TaskChannelFactory taskChannelFactory : dolphinSchedulerPlugin.getTaskChannelFactorys()) {
            logger.info("Registering Task Plugin '{}'", (Object)taskChannelFactory.getName());
            this.addTaskChannelFactory(taskChannelFactory);
            List params = taskChannelFactory.getParams();
            String nameEn = taskChannelFactory.getName();
            String paramsJson = PluginParamsTransfer.transferParamsToJson((List)params);
            PluginDefine pluginDefine = new PluginDefine(nameEn, PluginType.TASK.getDesc(), paramsJson);
            int id = this.pluginDao.addOrUpdatePluginDefine(pluginDefine);
            this.pluginDefineMap.put(id, pluginDefine.getPluginName());
        }
    }
}

