/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.task;

import java.util.Date;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.common.enums.TaskType;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.remote.command.StateEventChangeCommand;
import org.apache.dolphinscheduler.remote.processor.StateEventCallbackService;
import org.apache.dolphinscheduler.server.master.runner.task.BaseTaskProcessor;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;

public class SubTaskProcessor
extends BaseTaskProcessor {
    private ProcessInstance processInstance;
    private ProcessInstance subProcessInstance = null;
    private TaskDefinition taskDefinition;
    private final Lock runLock = new ReentrantLock();
    private StateEventCallbackService stateEventCallbackService = (StateEventCallbackService)SpringApplicationContext.getBean(StateEventCallbackService.class);

    @Override
    public boolean submit(TaskInstance task, ProcessInstance processInstance, int masterTaskCommitRetryTimes, int masterTaskCommitInterval) {
        this.processInstance = processInstance;
        this.taskDefinition = this.processService.findTaskDefinition(task.getTaskCode(), task.getTaskDefinitionVersion());
        this.taskInstance = this.processService.submitTask(task, masterTaskCommitRetryTimes, masterTaskCommitInterval);
        return this.taskInstance != null;
    }

    @Override
    public ExecutionStatus taskState() {
        return this.taskInstance.getState();
    }

    @Override
    public void run() {
        try {
            this.runLock.lock();
            if (this.setSubWorkFlow()) {
                this.updateTaskState();
            }
        }
        catch (Exception e) {
            this.logger.error("work flow {} sub task {} exceptions", new Object[]{this.processInstance.getId(), this.taskInstance.getId(), e});
        }
        finally {
            this.runLock.unlock();
        }
    }

    @Override
    protected boolean taskTimeout() {
        TaskTimeoutStrategy taskTimeoutStrategy = this.taskDefinition.getTimeoutNotifyStrategy();
        if (TaskTimeoutStrategy.FAILED != taskTimeoutStrategy && TaskTimeoutStrategy.WARNFAILED != taskTimeoutStrategy) {
            return true;
        }
        this.logger.info("sub process task {} timeout, strategy {} ", (Object)this.taskInstance.getId(), (Object)taskTimeoutStrategy.getDescp());
        this.killTask();
        return true;
    }

    private void updateTaskState() {
        this.subProcessInstance = this.processService.findSubProcessInstance(Integer.valueOf(this.processInstance.getId()), Integer.valueOf(this.taskInstance.getId()));
        this.logger.info("work flow {} task {}, sub work flow: {} state: {}", new Object[]{this.processInstance.getId(), this.taskInstance.getId(), this.subProcessInstance.getId(), this.subProcessInstance.getState().getDescp()});
        if (this.subProcessInstance != null && this.subProcessInstance.getState().typeIsFinished()) {
            this.taskInstance.setState(this.subProcessInstance.getState());
            this.taskInstance.setEndTime(new Date());
            this.processService.saveTaskInstance(this.taskInstance);
        }
    }

    @Override
    protected boolean pauseTask() {
        this.pauseSubWorkFlow();
        return true;
    }

    private boolean pauseSubWorkFlow() {
        ProcessInstance subProcessInstance = this.processService.findSubProcessInstance(Integer.valueOf(this.processInstance.getId()), Integer.valueOf(this.taskInstance.getId()));
        if (subProcessInstance == null || this.taskInstance.getState().typeIsFinished()) {
            return false;
        }
        subProcessInstance.setState(ExecutionStatus.READY_PAUSE);
        this.processService.updateProcessInstance(subProcessInstance);
        this.sendToSubProcess();
        return true;
    }

    private boolean setSubWorkFlow() {
        this.logger.info("set work flow {} task {} running", (Object)this.processInstance.getId(), (Object)this.taskInstance.getId());
        if (this.subProcessInstance != null) {
            return true;
        }
        this.subProcessInstance = this.processService.findSubProcessInstance(Integer.valueOf(this.processInstance.getId()), Integer.valueOf(this.taskInstance.getId()));
        if (this.subProcessInstance == null || this.taskInstance.getState().typeIsFinished()) {
            return false;
        }
        this.taskInstance.setState(ExecutionStatus.RUNNING_EXECUTION);
        this.taskInstance.setStartTime(new Date());
        this.processService.updateTaskInstance(this.taskInstance);
        this.logger.info("set sub work flow {} task {} state: {}", new Object[]{this.processInstance.getId(), this.taskInstance.getId(), this.taskInstance.getState()});
        return true;
    }

    @Override
    protected boolean killTask() {
        ProcessInstance subProcessInstance = this.processService.findSubProcessInstance(Integer.valueOf(this.processInstance.getId()), Integer.valueOf(this.taskInstance.getId()));
        if (subProcessInstance == null || this.taskInstance.getState().typeIsFinished()) {
            return false;
        }
        subProcessInstance.setState(ExecutionStatus.READY_STOP);
        this.processService.updateProcessInstance(subProcessInstance);
        this.sendToSubProcess();
        return true;
    }

    private void sendToSubProcess() {
        StateEventChangeCommand stateEventChangeCommand = new StateEventChangeCommand(this.processInstance.getId(), this.taskInstance.getId(), this.subProcessInstance.getState(), this.subProcessInstance.getId(), 0);
        String address = this.subProcessInstance.getHost().split(":")[0];
        int port = Integer.parseInt(this.subProcessInstance.getHost().split(":")[1]);
        this.stateEventCallbackService.sendResult(address, port, stateEventChangeCommand.convert2Command());
    }

    @Override
    public String getType() {
        return TaskType.SUB_PROCESS.getDesc();
    }
}

