/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.StateEvent;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.remote.command.StateEventChangeCommand;
import org.apache.dolphinscheduler.remote.processor.StateEventCallbackService;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThread;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EventExecuteService
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(EventExecuteService.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private MasterConfig masterConfig;
    private ExecutorService eventExecService;
    private StateEventCallbackService stateEventCallbackService;
    private ConcurrentHashMap<Integer, WorkflowExecuteThread> processInstanceExecMaps;
    private ConcurrentHashMap<String, WorkflowExecuteThread> eventHandlerMap = new ConcurrentHashMap();
    ListeningExecutorService listeningExecutorService;

    public void init(ConcurrentHashMap<Integer, WorkflowExecuteThread> processInstanceExecMaps) {
        this.eventExecService = ThreadUtils.newDaemonFixedThreadExecutor((String)"MasterEventExecution", (int)this.masterConfig.getMasterExecThreads());
        this.processInstanceExecMaps = processInstanceExecMaps;
        this.listeningExecutorService = MoreExecutors.listeningDecorator((ExecutorService)this.eventExecService);
        this.stateEventCallbackService = (StateEventCallbackService)SpringApplicationContext.getBean(StateEventCallbackService.class);
    }

    @Override
    public synchronized void start() {
        super.setName("EventServiceStarted");
        super.start();
    }

    public void close() {
        this.eventExecService.shutdown();
        logger.info("event service stopped...");
    }

    @Override
    public void run() {
        logger.info("Event service started");
        while (Stopper.isRunning()) {
            try {
                this.eventHandler();
                TimeUnit.MILLISECONDS.sleep(1000L);
            }
            catch (Exception e) {
                logger.error("Event service thread error", (Throwable)e);
            }
        }
    }

    private void eventHandler() {
        for (final WorkflowExecuteThread workflowExecuteThread : this.processInstanceExecMaps.values()) {
            if (workflowExecuteThread.eventSize() == 0 || StringUtils.isEmpty((String)workflowExecuteThread.getKey()) || !workflowExecuteThread.isStart() || this.eventHandlerMap.containsKey(workflowExecuteThread.getKey())) continue;
            final int processInstanceId = workflowExecuteThread.getProcessInstance().getId();
            logger.info("handle process instance : {} , events count:{}", (Object)processInstanceId, (Object)workflowExecuteThread.eventSize());
            logger.info("already exists handler process size:{}", (Object)this.eventHandlerMap.size());
            this.eventHandlerMap.put(workflowExecuteThread.getKey(), workflowExecuteThread);
            ListenableFuture future = this.listeningExecutorService.submit((Runnable)workflowExecuteThread);
            FutureCallback futureCallback = new FutureCallback(){

                public void onSuccess(Object o) {
                    if (workflowExecuteThread.workFlowFinish()) {
                        EventExecuteService.this.processInstanceExecMaps.remove(processInstanceId);
                        this.notifyProcessChanged();
                        logger.info("process instance {} finished.", (Object)processInstanceId);
                    }
                    if (workflowExecuteThread.getProcessInstance().getId() != processInstanceId) {
                        EventExecuteService.this.processInstanceExecMaps.remove(processInstanceId);
                        EventExecuteService.this.processInstanceExecMaps.put(workflowExecuteThread.getProcessInstance().getId(), workflowExecuteThread);
                    }
                    EventExecuteService.this.eventHandlerMap.remove(workflowExecuteThread.getKey());
                }

                private void notifyProcessChanged() {
                    Map fatherMaps = EventExecuteService.this.processService.notifyProcessList(processInstanceId, 0);
                    for (ProcessInstance processInstance : fatherMaps.keySet()) {
                        String address = NetUtils.getAddr((int)EventExecuteService.this.masterConfig.getListenPort());
                        if (processInstance.getHost().equalsIgnoreCase(address)) {
                            this.notifyMyself(processInstance, (TaskInstance)fatherMaps.get(processInstance));
                            continue;
                        }
                        this.notifyProcess(processInstance, (TaskInstance)fatherMaps.get(processInstance));
                    }
                }

                private void notifyMyself(ProcessInstance processInstance, TaskInstance taskInstance) {
                    logger.info("notify process {} task {} state change", (Object)processInstance.getId(), (Object)taskInstance.getId());
                    if (!EventExecuteService.this.processInstanceExecMaps.containsKey(processInstance.getId())) {
                        return;
                    }
                    WorkflowExecuteThread workflowExecuteThreadNotify = (WorkflowExecuteThread)EventExecuteService.this.processInstanceExecMaps.get(processInstance.getId());
                    StateEvent stateEvent = new StateEvent();
                    stateEvent.setTaskInstanceId(taskInstance.getId());
                    stateEvent.setType(StateEventType.TASK_STATE_CHANGE);
                    stateEvent.setProcessInstanceId(processInstance.getId());
                    stateEvent.setExecutionStatus(ExecutionStatus.RUNNING_EXECUTION);
                    workflowExecuteThreadNotify.addStateEvent(stateEvent);
                }

                private void notifyProcess(ProcessInstance processInstance, TaskInstance taskInstance) {
                    String host = processInstance.getHost();
                    if (StringUtils.isEmpty((String)host)) {
                        logger.info("process {} host is empty, cannot notify task {} now.", (Object)processInstance.getId(), (Object)taskInstance.getId());
                        return;
                    }
                    String address = host.split(":")[0];
                    int port = Integer.parseInt(host.split(":")[1]);
                    logger.info("notify process {} task {} state change, host:{}", new Object[]{processInstance.getId(), taskInstance.getId(), host});
                    StateEventChangeCommand stateEventChangeCommand = new StateEventChangeCommand(processInstanceId, 0, workflowExecuteThread.getProcessInstance().getState(), processInstance.getId(), taskInstance.getId());
                    EventExecuteService.this.stateEventCallbackService.sendResult(address, port, stateEventChangeCommand.convert2Command());
                }

                public void onFailure(Throwable throwable) {
                    logger.info("handle events {} failed.", (Object)processInstanceId);
                    logger.info("handle events failed.", throwable);
                }
            };
            Futures.addCallback((ListenableFuture)future, (FutureCallback)futureCallback, (Executor)this.listeningExecutorService);
        }
    }
}

