/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.registry;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.IStoppable;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.NodeType;
import org.apache.dolphinscheduler.common.enums.StateEvent;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.remote.utils.NamedThreadFactory;
import org.apache.dolphinscheduler.server.builder.TaskExecutionContextBuilder;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.registry.MasterRegistryDataListener;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThread;
import org.apache.dolphinscheduler.server.registry.HeartBeatTask;
import org.apache.dolphinscheduler.server.utils.ProcessUtils;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.apache.dolphinscheduler.service.queue.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.service.registry.RegistryClient;
import org.apache.dolphinscheduler.spi.register.RegistryConnectListener;
import org.apache.dolphinscheduler.spi.register.RegistryConnectState;
import org.apache.dolphinscheduler.spi.register.SubscribeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MasterRegistryClient {
    private static final Logger logger = LoggerFactory.getLogger(MasterRegistryClient.class);
    @Autowired
    private ProcessService processService;
    private RegistryClient registryClient;
    @Autowired
    private MasterConfig masterConfig;
    private ScheduledExecutorService heartBeatExecutor;
    private ConcurrentHashMap<Integer, WorkflowExecuteThread> processInstanceExecMaps;
    private long startupTime;
    private String localNodePath;

    public void init(ConcurrentHashMap<Integer, WorkflowExecuteThread> processInstanceExecMaps) {
        this.startupTime = System.currentTimeMillis();
        this.registryClient = RegistryClient.getInstance();
        this.heartBeatExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("HeartBeatExecutor"));
        this.processInstanceExecMaps = processInstanceExecMaps;
    }

    public void start() {
        String nodeLock = this.registryClient.getMasterStartUpLockPath();
        try {
            this.registryClient.getLock(nodeLock);
            this.registry();
            String registryPath = this.getMasterPath();
            this.registryClient.handleDeadServer(registryPath, NodeType.MASTER, "delete");
            while (!this.registryClient.checkNodeExists(NetUtils.getHost(), NodeType.MASTER)) {
                ThreadUtils.sleep((long)1000L);
            }
            if (this.registryClient.getActiveMasterNum() == 1) {
                this.removeNodePath(null, NodeType.MASTER, true);
                this.removeNodePath(null, NodeType.WORKER, true);
            }
            this.registryClient.subscribe("/nodes", (SubscribeListener)new MasterRegistryDataListener());
        }
        catch (Exception e) {
            logger.error("master start up exception", (Throwable)e);
        }
        finally {
            this.registryClient.releaseLock(nodeLock);
        }
    }

    public void setRegistryStoppable(IStoppable stoppable) {
        this.registryClient.setStoppable(stoppable);
    }

    public void closeRegistry() {
        this.unRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNodePath(String path, NodeType nodeType, boolean failover) {
        logger.info("{} node deleted : {}", (Object)nodeType, (Object)path);
        String failoverPath = this.getFailoverLockPath(nodeType);
        try {
            this.registryClient.getLock(failoverPath);
            String serverHost = null;
            if (!StringUtils.isEmpty((String)path)) {
                serverHost = this.registryClient.getHostByEventDataPath(path);
                if (StringUtils.isEmpty((String)serverHost)) {
                    logger.error("server down error: unknown path: {}", (Object)path);
                    return;
                }
                this.registryClient.handleDeadServer(path, nodeType, "add");
            }
            if (failover) {
                this.failoverServerWhenDown(serverHost, nodeType);
            }
        }
        catch (Exception e) {
            logger.error("{} server failover failed.", (Object)nodeType);
            logger.error("failover exception ", (Throwable)e);
        }
        finally {
            this.registryClient.releaseLock(failoverPath);
        }
    }

    private void failoverServerWhenDown(String serverHost, NodeType nodeType) {
        switch (nodeType) {
            case MASTER: {
                this.failoverMaster(serverHost);
                break;
            }
            case WORKER: {
                this.failoverWorker(serverHost, true, true);
                break;
            }
        }
    }

    private String getFailoverLockPath(NodeType nodeType) {
        switch (nodeType) {
            case MASTER: {
                return this.registryClient.getMasterFailoverLockPath();
            }
            case WORKER: {
                return this.registryClient.getWorkerFailoverLockPath();
            }
        }
        return "";
    }

    private boolean checkTaskInstanceNeedFailover(TaskInstance taskInstance) {
        boolean taskNeedFailover = true;
        if (taskInstance.getHost() == null) {
            return false;
        }
        if (this.registryClient.checkNodeExists(taskInstance.getHost(), NodeType.WORKER) && this.checkTaskAfterWorkerStart(taskInstance)) {
            taskNeedFailover = false;
        }
        return taskNeedFailover;
    }

    private boolean checkTaskAfterWorkerStart(TaskInstance taskInstance) {
        if (StringUtils.isEmpty((String)taskInstance.getHost())) {
            return false;
        }
        Date workerServerStartDate = null;
        List workerServers = this.registryClient.getServerList(NodeType.WORKER);
        for (Server workerServer : workerServers) {
            if (!taskInstance.getHost().equals(workerServer.getHost() + ":" + workerServer.getPort())) continue;
            workerServerStartDate = workerServer.getCreateTime();
            break;
        }
        if (workerServerStartDate != null) {
            return taskInstance.getStartTime().after(workerServerStartDate);
        }
        return false;
    }

    private void failoverWorker(String workerHost, boolean needCheckWorkerAlive, boolean checkOwner) {
        logger.info("start worker[{}] failover ...", (Object)workerHost);
        List needFailoverTaskInstanceList = this.processService.queryNeedFailoverTaskInstances(workerHost);
        for (TaskInstance taskInstance : needFailoverTaskInstanceList) {
            if (needCheckWorkerAlive && !this.checkTaskInstanceNeedFailover(taskInstance)) continue;
            ProcessInstance processInstance = this.processService.findProcessInstanceDetailById(taskInstance.getProcessInstanceId());
            if (workerHost != null && checkOwner && !processInstance.getHost().equalsIgnoreCase(this.getLocalAddress())) continue;
            if (processInstance == null) {
                logger.error("failover error, the process {} of task {} do not exists.", (Object)taskInstance.getProcessInstanceId(), (Object)taskInstance.getId());
                continue;
            }
            taskInstance.setProcessInstance(processInstance);
            TaskExecutionContext taskExecutionContext = TaskExecutionContextBuilder.get().buildTaskInstanceRelatedInfo(taskInstance).buildProcessInstanceRelatedInfo(processInstance).create();
            ProcessUtils.killYarnJob(taskExecutionContext);
            taskInstance.setState(ExecutionStatus.NEED_FAULT_TOLERANCE);
            this.processService.saveTaskInstance(taskInstance);
            if (!this.processInstanceExecMaps.containsKey(processInstance.getId())) {
                return;
            }
            WorkflowExecuteThread workflowExecuteThreadNotify = this.processInstanceExecMaps.get(processInstance.getId());
            StateEvent stateEvent = new StateEvent();
            stateEvent.setTaskInstanceId(taskInstance.getId());
            stateEvent.setType(StateEventType.TASK_STATE_CHANGE);
            stateEvent.setProcessInstanceId(processInstance.getId());
            stateEvent.setExecutionStatus(taskInstance.getState());
            workflowExecuteThreadNotify.addStateEvent(stateEvent);
        }
        logger.info("end worker[{}] failover ...", (Object)workerHost);
    }

    private void failoverMaster(String masterHost) {
        logger.info("start master failover ...");
        List needFailoverProcessInstanceList = this.processService.queryNeedFailoverProcessInstances(masterHost);
        logger.info("failover process list size:{} ", (Object)needFailoverProcessInstanceList.size());
        for (ProcessInstance processInstance : needFailoverProcessInstanceList) {
            logger.info("failover process instance id: {} host:{}", (Object)processInstance.getId(), (Object)processInstance.getHost());
            if ("NULL".equals(processInstance.getHost())) continue;
            this.processService.processNeedFailoverProcessInstances(processInstance);
        }
        this.failoverWorker(masterHost, true, false);
        logger.info("master failover end");
    }

    public void blockAcquireMutex() {
        this.registryClient.getLock(this.registryClient.getMasterLockPath());
    }

    public void releaseLock() {
        this.registryClient.releaseLock(this.registryClient.getMasterLockPath());
    }

    public void registry() {
        String address = NetUtils.getAddr((int)this.masterConfig.getListenPort());
        this.localNodePath = this.getMasterPath();
        int masterHeartbeatInterval = this.masterConfig.getMasterHeartbeatInterval();
        HeartBeatTask heartBeatTask = new HeartBeatTask(this.startupTime, this.masterConfig.getMasterMaxCpuloadAvg(), this.masterConfig.getMasterReservedMemory(), Sets.newHashSet((Object[])new String[]{this.getMasterPath()}), "master", this.registryClient);
        this.registryClient.persistEphemeral(this.localNodePath, heartBeatTask.getHeartBeatInfo());
        this.registryClient.addConnectionStateListener((RegistryConnectListener)new MasterRegistryConnectStateListener());
        this.heartBeatExecutor.scheduleAtFixedRate(heartBeatTask, masterHeartbeatInterval, masterHeartbeatInterval, TimeUnit.SECONDS);
        logger.info("master node : {} registry to ZK successfully with heartBeatInterval : {}s", (Object)address, (Object)masterHeartbeatInterval);
    }

    public void unRegistry() {
        try {
            String address = this.getLocalAddress();
            String localNodePath = this.getMasterPath();
            this.registryClient.remove(localNodePath);
            logger.info("master node : {} unRegistry to register center.", (Object)address);
            this.heartBeatExecutor.shutdown();
            logger.info("heartbeat executor shutdown");
            this.registryClient.close();
        }
        catch (Exception e) {
            logger.error("remove registry path exception ", (Throwable)e);
        }
    }

    public String getMasterPath() {
        String address = this.getLocalAddress();
        return "/nodes/master/" + address;
    }

    private String getLocalAddress() {
        return NetUtils.getAddr((int)this.masterConfig.getListenPort());
    }

    class MasterRegistryConnectStateListener
    implements RegistryConnectListener {
        MasterRegistryConnectStateListener() {
        }

        public void notify(RegistryConnectState newState) {
            if (RegistryConnectState.RECONNECTED == newState) {
                MasterRegistryClient.this.registryClient.persistEphemeral(MasterRegistryClient.this.localNodePath, "");
            }
            if (RegistryConnectState.SUSPENDED == newState) {
                MasterRegistryClient.this.registryClient.persistEphemeral(MasterRegistryClient.this.localNodePath, "");
            }
        }
    }
}

