/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.processor.queue;

import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.dolphinscheduler.common.enums.Event;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.StateEvent;
import org.apache.dolphinscheduler.common.enums.StateEventType;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.remote.command.DBTaskAckCommand;
import org.apache.dolphinscheduler.remote.command.DBTaskResponseCommand;
import org.apache.dolphinscheduler.server.master.processor.queue.TaskResponseEvent;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThread;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskResponseService {
    private final Logger logger = LoggerFactory.getLogger(TaskResponseService.class);
    private final BlockingQueue<TaskResponseEvent> eventQueue = new LinkedBlockingQueue<TaskResponseEvent>();
    @Autowired
    private ProcessService processService;
    private Thread taskResponseWorker;
    private ConcurrentHashMap<Integer, WorkflowExecuteThread> processInstanceMapper;

    public void init(ConcurrentHashMap<Integer, WorkflowExecuteThread> processInstanceMapper) {
        if (this.processInstanceMapper == null) {
            this.processInstanceMapper = processInstanceMapper;
        }
    }

    @PostConstruct
    public void start() {
        this.taskResponseWorker = new TaskResponseWorker();
        this.taskResponseWorker.setName("StateEventResponseWorker");
        this.taskResponseWorker.start();
    }

    @PreDestroy
    public void stop() {
        try {
            this.taskResponseWorker.interrupt();
            if (!this.eventQueue.isEmpty()) {
                ArrayList remainEvents = new ArrayList(this.eventQueue.size());
                this.eventQueue.drainTo(remainEvents);
                for (TaskResponseEvent event : remainEvents) {
                    this.persist(event);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("stop error:", (Throwable)e);
        }
    }

    public void addResponse(TaskResponseEvent taskResponseEvent) {
        try {
            this.eventQueue.put(taskResponseEvent);
        }
        catch (InterruptedException e) {
            this.logger.error("put task : {} error :{}", (Object)taskResponseEvent, (Object)e);
            Thread.currentThread().interrupt();
        }
    }

    private void persist(TaskResponseEvent taskResponseEvent) {
        Event event = taskResponseEvent.getEvent();
        Channel channel = taskResponseEvent.getChannel();
        TaskInstance taskInstance = this.processService.findTaskInstanceById(Integer.valueOf(taskResponseEvent.getTaskInstanceId()));
        switch (event) {
            case ACK: {
                try {
                    if (taskInstance != null) {
                        ExecutionStatus status = taskInstance.getState().typeIsFinished() ? taskInstance.getState() : taskResponseEvent.getState();
                        this.processService.changeTaskState(taskInstance, status, taskResponseEvent.getStartTime(), taskResponseEvent.getWorkerAddress(), taskResponseEvent.getExecutePath(), taskResponseEvent.getLogPath(), taskResponseEvent.getTaskInstanceId());
                    }
                    DBTaskAckCommand taskAckCommand = new DBTaskAckCommand(ExecutionStatus.SUCCESS.getCode(), taskResponseEvent.getTaskInstanceId());
                    channel.writeAndFlush((Object)taskAckCommand.convert2Command());
                }
                catch (Exception e) {
                    this.logger.error("worker ack master error", (Throwable)e);
                    DBTaskAckCommand taskAckCommand = new DBTaskAckCommand(ExecutionStatus.FAILURE.getCode(), -1);
                    channel.writeAndFlush((Object)taskAckCommand.convert2Command());
                }
                break;
            }
            case RESULT: {
                try {
                    if (taskInstance != null) {
                        this.processService.changeTaskState(taskInstance, taskResponseEvent.getState(), taskResponseEvent.getEndTime(), taskResponseEvent.getProcessId(), taskResponseEvent.getAppIds(), taskResponseEvent.getTaskInstanceId(), taskResponseEvent.getVarPool());
                    }
                    DBTaskResponseCommand taskResponseCommand = new DBTaskResponseCommand(ExecutionStatus.SUCCESS.getCode(), taskResponseEvent.getTaskInstanceId());
                    channel.writeAndFlush((Object)taskResponseCommand.convert2Command());
                }
                catch (Exception e) {
                    this.logger.error("worker response master error", (Throwable)e);
                    DBTaskResponseCommand taskResponseCommand = new DBTaskResponseCommand(ExecutionStatus.FAILURE.getCode(), -1);
                    channel.writeAndFlush((Object)taskResponseCommand.convert2Command());
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid event type : " + event);
            }
        }
        WorkflowExecuteThread workflowExecuteThread = this.processInstanceMapper.get(taskResponseEvent.getProcessInstanceId());
        if (workflowExecuteThread != null) {
            StateEvent stateEvent = new StateEvent();
            stateEvent.setProcessInstanceId(taskResponseEvent.getProcessInstanceId());
            stateEvent.setTaskInstanceId(taskResponseEvent.getTaskInstanceId());
            stateEvent.setExecutionStatus(taskResponseEvent.getState());
            stateEvent.setType(StateEventType.TASK_STATE_CHANGE);
            workflowExecuteThread.addStateEvent(stateEvent);
        }
    }

    public BlockingQueue<TaskResponseEvent> getEventQueue() {
        return this.eventQueue;
    }

    class TaskResponseWorker
    extends Thread {
        TaskResponseWorker() {
        }

        @Override
        public void run() {
            while (Stopper.isRunning()) {
                try {
                    TaskResponseEvent taskResponseEvent = (TaskResponseEvent)TaskResponseService.this.eventQueue.take();
                    TaskResponseService.this.persist(taskResponseEvent);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (Exception e) {
                    TaskResponseService.this.logger.error("persist task error", (Throwable)e);
                }
            }
            TaskResponseService.this.logger.info("StateEventResponseWorker stopped");
        }
    }
}

