/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.dispatch.host;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.dolphinscheduler.common.utils.CollectionUtils;
import org.apache.dolphinscheduler.common.utils.HeartBeat;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.remote.utils.NamedThreadFactory;
import org.apache.dolphinscheduler.server.master.dispatch.context.ExecutionContext;
import org.apache.dolphinscheduler.server.master.dispatch.host.CommonHostManager;
import org.apache.dolphinscheduler.server.master.dispatch.host.assign.HostWeight;
import org.apache.dolphinscheduler.server.master.dispatch.host.assign.HostWorker;
import org.apache.dolphinscheduler.server.master.dispatch.host.assign.LowerWeightRoundRobin;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowerWeightHostManager
extends CommonHostManager {
    private final Logger logger = LoggerFactory.getLogger(LowerWeightHostManager.class);
    private LowerWeightRoundRobin selector;
    private ConcurrentHashMap<String, Set<HostWeight>> workerHostWeightsMap;
    private Lock lock;
    private ScheduledExecutorService executorService;

    @PostConstruct
    public void init() {
        this.selector = new LowerWeightRoundRobin();
        this.workerHostWeightsMap = new ConcurrentHashMap();
        this.lock = new ReentrantLock();
        this.executorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("LowerWeightHostManagerExecutor"));
        this.executorService.scheduleWithFixedDelay(new RefreshResourceTask(), 0L, 1L, TimeUnit.SECONDS);
    }

    @PreDestroy
    public void close() {
        this.executorService.shutdownNow();
    }

    @Override
    public Host select(ExecutionContext context) {
        Set<HostWeight> workerHostWeights = this.getWorkerHostWeights(context.getWorkerGroup());
        if (CollectionUtils.isNotEmpty(workerHostWeights)) {
            return this.selector.select(workerHostWeights).getHost();
        }
        return new Host();
    }

    @Override
    public HostWorker select(Collection<HostWorker> nodes) {
        throw new UnsupportedOperationException("not support");
    }

    private void syncWorkerHostWeight(Map<String, Set<HostWeight>> workerHostWeights) {
        this.lock.lock();
        try {
            this.workerHostWeightsMap.clear();
            this.workerHostWeightsMap.putAll(workerHostWeights);
        }
        finally {
            this.lock.unlock();
        }
    }

    private Set<HostWeight> getWorkerHostWeights(String workerGroup) {
        this.lock.lock();
        try {
            Set<HostWeight> set = this.workerHostWeightsMap.get(workerGroup);
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    class RefreshResourceTask
    implements Runnable {
        RefreshResourceTask() {
        }

        @Override
        public void run() {
            try {
                HashMap workerHostWeights = new HashMap();
                Map<String, Set<String>> workerGroupNodes = LowerWeightHostManager.this.serverNodeManager.getWorkerGroupNodes();
                for (Map.Entry<String, Set<String>> entry : workerGroupNodes.entrySet()) {
                    String workerGroup = entry.getKey();
                    Set<String> nodes = entry.getValue();
                    HashSet<HostWeight> hostWeights = new HashSet<HostWeight>(nodes.size());
                    for (String node : nodes) {
                        String heartbeat;
                        Optional<HostWeight> hostWeightOpt = this.getHostWeight(node, workerGroup, heartbeat = LowerWeightHostManager.this.serverNodeManager.getWorkerNodeInfo(node));
                        if (!hostWeightOpt.isPresent()) continue;
                        hostWeights.add(hostWeightOpt.get());
                    }
                    if (hostWeights.isEmpty()) continue;
                    workerHostWeights.put(workerGroup, hostWeights);
                }
                LowerWeightHostManager.this.syncWorkerHostWeight(workerHostWeights);
            }
            catch (Throwable ex) {
                LowerWeightHostManager.this.logger.error("RefreshResourceTask error", ex);
            }
        }

        public Optional<HostWeight> getHostWeight(String addr, String workerGroup, String heartBeatInfo) {
            if (StringUtils.isEmpty((CharSequence)heartBeatInfo)) {
                LowerWeightHostManager.this.logger.warn("worker {} in work group {} have not received the heartbeat", (Object)addr, (Object)workerGroup);
                return Optional.empty();
            }
            HeartBeat heartBeat = HeartBeat.decodeHeartBeat((String)heartBeatInfo);
            if (heartBeat == null) {
                return Optional.empty();
            }
            if (1 == heartBeat.getServerStatus()) {
                LowerWeightHostManager.this.logger.warn("worker {} current cpu load average {} is too high or available memory {}G is too low", new Object[]{addr, heartBeat.getLoadAverage(), heartBeat.getAvailablePhysicalMemorySize()});
                return Optional.empty();
            }
            if (2 == heartBeat.getServerStatus()) {
                LowerWeightHostManager.this.logger.warn("worker {} is busy, current waiting task count {} is large than worker thread count {}", new Object[]{addr, heartBeat.getWorkerWaitingTaskCount(), heartBeat.getWorkerExecThreadCount()});
                return Optional.empty();
            }
            return Optional.of(new HostWeight(HostWorker.of(addr, heartBeat.getWorkerHostWeight(), workerGroup), heartBeat.getCpuUsage(), heartBeat.getMemoryUsage(), heartBeat.getLoadAverage(), heartBeat.getStartupTime()));
        }
    }
}

