/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.security;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.security.PrestoPrincipal;
import java.util.Locale;
import java.util.Objects;

public class RoleGrant {
    private final PrestoPrincipal grantee;
    private final String roleName;
    private final boolean grantable;

    @JsonCreator
    public RoleGrant(@JsonProperty(value="grantee") PrestoPrincipal grantee, @JsonProperty(value="roleName") String roleName, @JsonProperty(value="grantable") boolean grantable) {
        this.grantee = Objects.requireNonNull(grantee, "grantee is null");
        this.roleName = Objects.requireNonNull(roleName, "roleName is null").toLowerCase(Locale.ENGLISH);
        this.grantable = grantable;
    }

    @JsonProperty
    public String getRoleName() {
        return this.roleName;
    }

    @JsonProperty
    public PrestoPrincipal getGrantee() {
        return this.grantee;
    }

    @JsonProperty
    public boolean isGrantable() {
        return this.grantable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoleGrant roleGrant = (RoleGrant)o;
        return this.grantable == roleGrant.grantable && Objects.equals(this.grantee, roleGrant.grantee) && Objects.equals(this.roleName, roleGrant.roleName);
    }

    public int hashCode() {
        return Objects.hash(this.grantee, this.roleName, this.grantable);
    }

    public String toString() {
        return "RoleGrant{grantee=" + this.grantee + ", roleName='" + this.roleName + '\'' + ", grantable=" + this.grantable + '}';
    }
}

