/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.function;

import com.facebook.presto.jdbc.internal.common.type.Type;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.javax.annotation.Nullable;
import java.util.Objects;

public class TypeVariableConstraint {
    private final String name;
    private final boolean comparableRequired;
    private final boolean orderableRequired;
    private final String variadicBound;

    @JsonCreator
    public TypeVariableConstraint(@JsonProperty(value="name") String name, @JsonProperty(value="comparableRequired") boolean comparableRequired, @JsonProperty(value="orderableRequired") boolean orderableRequired, @JsonProperty(value="variadicBound") @Nullable String variadicBound) {
        this.name = name;
        this.comparableRequired = comparableRequired;
        this.orderableRequired = orderableRequired;
        this.variadicBound = variadicBound;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public boolean isComparableRequired() {
        return this.comparableRequired;
    }

    @JsonProperty
    public boolean isOrderableRequired() {
        return this.orderableRequired;
    }

    @JsonProperty
    public String getVariadicBound() {
        return this.variadicBound;
    }

    public boolean canBind(Type type) {
        if (this.comparableRequired && !type.isComparable()) {
            return false;
        }
        if (this.orderableRequired && !type.isOrderable()) {
            return false;
        }
        return this.variadicBound == null || type.getTypeSignature().getBase().equals(this.variadicBound);
    }

    public String toString() {
        String value = this.name;
        if (this.comparableRequired) {
            value = value + ":comparable";
        }
        if (this.orderableRequired) {
            value = value + ":orderable";
        }
        if (this.variadicBound != null) {
            value = value + ":" + this.variadicBound + "<*>";
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeVariableConstraint that = (TypeVariableConstraint)o;
        return this.comparableRequired == that.comparableRequired && this.orderableRequired == that.orderableRequired && Objects.equals(this.name, that.name) && Objects.equals(this.variadicBound, that.variadicBound);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.comparableRequired, this.orderableRequired, this.variadicBound);
    }
}

