/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.function;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.Optional;

public class RoutineCharacteristics {
    private final Language language;
    private final Determinism determinism;
    private final NullCallClause nullCallClause;

    @JsonCreator
    public RoutineCharacteristics(@JsonProperty(value="language") Optional<Language> language, @JsonProperty(value="determinism") Optional<Determinism> determinism, @JsonProperty(value="nullCallClause") Optional<NullCallClause> nullCallClause) {
        this.language = language.orElse(Language.SQL);
        this.determinism = determinism.orElse(Determinism.NOT_DETERMINISTIC);
        this.nullCallClause = nullCallClause.orElse(NullCallClause.CALLED_ON_NULL_INPUT);
    }

    @JsonProperty
    public Language getLanguage() {
        return this.language;
    }

    @JsonProperty
    public Determinism getDeterminism() {
        return this.determinism;
    }

    @JsonProperty
    public NullCallClause getNullCallClause() {
        return this.nullCallClause;
    }

    public boolean isDeterministic() {
        return this.determinism == Determinism.DETERMINISTIC;
    }

    public boolean isCalledOnNullInput() {
        return this.nullCallClause == NullCallClause.CALLED_ON_NULL_INPUT;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(RoutineCharacteristics routineCharacteristics) {
        return new Builder(routineCharacteristics);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoutineCharacteristics that = (RoutineCharacteristics)o;
        return Objects.equals(this.language, that.language) && this.determinism == that.determinism && this.nullCallClause == that.nullCallClause;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.language, this.determinism, this.nullCallClause});
    }

    public String toString() {
        return String.format("(%s, %s, %s)", new Object[]{this.language, this.determinism, this.nullCallClause});
    }

    public static class Builder {
        private Language language;
        private Determinism determinism;
        private NullCallClause nullCallClause;

        private Builder() {
        }

        private Builder(RoutineCharacteristics routineCharacteristics) {
            this.language = routineCharacteristics.getLanguage();
            this.determinism = routineCharacteristics.getDeterminism();
            this.nullCallClause = routineCharacteristics.getNullCallClause();
        }

        public Builder setLanguage(Language language) {
            this.language = Objects.requireNonNull(language, "language is null");
            return this;
        }

        public Builder setDeterminism(Determinism determinism) {
            this.determinism = Objects.requireNonNull(determinism, "determinism is null");
            return this;
        }

        public Builder setNullCallClause(NullCallClause nullCallClause) {
            this.nullCallClause = Objects.requireNonNull(nullCallClause, "nullCallClause is null");
            return this;
        }

        public RoutineCharacteristics build() {
            return new RoutineCharacteristics(Optional.ofNullable(this.language), Optional.ofNullable(this.determinism), Optional.ofNullable(this.nullCallClause));
        }
    }

    public static enum NullCallClause {
        RETURNS_NULL_ON_NULL_INPUT,
        CALLED_ON_NULL_INPUT;

    }

    public static enum Determinism {
        DETERMINISTIC,
        NOT_DETERMINISTIC;

    }

    public static class Language {
        public static final Language SQL = new Language("SQL");
        private final String language;

        @JsonCreator
        public Language(String language) {
            this.language = Objects.requireNonNull(language.toUpperCase());
        }

        @JsonValue
        public String getLanguage() {
            return this.language;
        }

        public int hashCode() {
            return Objects.hash(this.language);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Language that = (Language)o;
            return Objects.equals(this.language, that.language);
        }

        public String toString() {
            return this.language;
        }
    }
}

