/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.sqoop.generator.sources;

import java.util.List;
import org.apache.dolphinscheduler.plugin.task.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.plugin.task.datasource.ConnectionParam;
import org.apache.dolphinscheduler.plugin.task.datasource.DatasourceUtil;
import org.apache.dolphinscheduler.plugin.task.datasource.PasswordUtils;
import org.apache.dolphinscheduler.plugin.task.sqoop.SqoopQueryType;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.ISourceGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.SqoopParameters;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.sources.SourceMysqlParameter;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.apache.dolphinscheduler.spi.task.Property;
import org.apache.dolphinscheduler.spi.task.request.TaskRequest;
import org.apache.dolphinscheduler.spi.utils.JSONUtils;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlSourceGenerator
implements ISourceGenerator {
    private static final Logger logger = LoggerFactory.getLogger(MysqlSourceGenerator.class);

    @Override
    public String generate(SqoopParameters sqoopParameters, TaskRequest taskExecutionContext) {
        StringBuilder mysqlSourceSb = new StringBuilder();
        try {
            BaseConnectionParam baseDataSource;
            SourceMysqlParameter sourceMysqlParameter = (SourceMysqlParameter)JSONUtils.parseObject((String)sqoopParameters.getSourceParams(), SourceMysqlParameter.class);
            if (null != sourceMysqlParameter && null != (baseDataSource = (BaseConnectionParam)DatasourceUtil.buildConnectionParams((DbType)DbType.of((int)taskExecutionContext.getSqoopTaskExecutionContext().getSourcetype()), (String)taskExecutionContext.getSqoopTaskExecutionContext().getSourceConnectionParams()))) {
                List<Property> mapColumnJava;
                List<Property> mapColumnHive;
                mysqlSourceSb.append(" ").append("--connect").append(" ").append("\"").append(DatasourceUtil.getJdbcUrl((DbType)DbType.MYSQL, (ConnectionParam)baseDataSource)).append("\"").append(" ").append("--username").append(" ").append(baseDataSource.getUser()).append(" ").append("--password").append(" ").append("\"").append(PasswordUtils.decodePassword((String)baseDataSource.getPassword())).append("\"");
                if (sourceMysqlParameter.getSrcQueryType() == SqoopQueryType.FORM.getCode().intValue()) {
                    if (StringUtils.isNotEmpty((CharSequence)sourceMysqlParameter.getSrcTable())) {
                        mysqlSourceSb.append(" ").append("--table").append(" ").append(sourceMysqlParameter.getSrcTable());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)sourceMysqlParameter.getSrcColumns())) {
                        mysqlSourceSb.append(" ").append("--columns").append(" ").append(sourceMysqlParameter.getSrcColumns());
                    }
                } else if (sourceMysqlParameter.getSrcQueryType() == SqoopQueryType.SQL.getCode().intValue() && StringUtils.isNotEmpty((CharSequence)sourceMysqlParameter.getSrcQuerySql())) {
                    String srcQuery = sourceMysqlParameter.getSrcQuerySql();
                    mysqlSourceSb.append(" ").append("--query").append(" ").append("\"").append(srcQuery);
                    if (srcQuery.toLowerCase().contains("where")) {
                        mysqlSourceSb.append(" ").append("AND \\$CONDITIONS").append("\"");
                    } else {
                        mysqlSourceSb.append(" ").append("WHERE \\$CONDITIONS").append("\"");
                    }
                }
                if (null != (mapColumnHive = sourceMysqlParameter.getMapColumnHive()) && !mapColumnHive.isEmpty()) {
                    StringBuilder columnMap = new StringBuilder();
                    for (Property item : mapColumnHive) {
                        columnMap.append(item.getProp()).append("=").append(item.getValue()).append(",");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)columnMap.toString())) {
                        mysqlSourceSb.append(" ").append("--map-column-hive").append(" ").append(columnMap.substring(0, columnMap.length() - 1));
                    }
                }
                if (null != (mapColumnJava = sourceMysqlParameter.getMapColumnJava()) && !mapColumnJava.isEmpty()) {
                    StringBuilder columnMap = new StringBuilder();
                    for (Property item : mapColumnJava) {
                        columnMap.append(item.getProp()).append("=").append(item.getValue()).append(",");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)columnMap.toString())) {
                        mysqlSourceSb.append(" ").append("--map-column-java").append(" ").append(columnMap.substring(0, columnMap.length() - 1));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(String.format("Sqoop task mysql source params build failed: [%s]", e.getMessage()));
        }
        return mysqlSourceSb.toString();
    }
}

