/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.sqoop.generator;

import java.util.List;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.SqoopParameters;
import org.apache.dolphinscheduler.spi.task.Property;
import org.apache.dolphinscheduler.spi.utils.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonGenerator {
    private static final Logger logger = LoggerFactory.getLogger(CommonGenerator.class);

    public String generate(SqoopParameters sqoopParameters) {
        StringBuilder commonSb = new StringBuilder();
        try {
            List<Property> sqoopAdvancedParams;
            commonSb.append("sqoop").append(" ").append(sqoopParameters.getModelType());
            commonSb.append(" ").append("-D").append(" ").append(String.format("%s%s%s", "mapred.job.name", "=", sqoopParameters.getJobName()));
            List<Property> hadoopCustomParams = sqoopParameters.getHadoopCustomParams();
            if (CollectionUtils.isNotEmpty(hadoopCustomParams)) {
                for (Property hadoopCustomParam : hadoopCustomParams) {
                    String hadoopCustomParamStr = String.format("%s%s%s", hadoopCustomParam.getProp(), "=", hadoopCustomParam.getValue());
                    commonSb.append(" ").append("-D").append(" ").append(hadoopCustomParamStr);
                }
            }
            if (CollectionUtils.isNotEmpty(sqoopAdvancedParams = sqoopParameters.getSqoopAdvancedParams())) {
                for (Property sqoopAdvancedParam : sqoopAdvancedParams) {
                    commonSb.append(" ").append(sqoopAdvancedParam.getProp()).append(" ").append(sqoopAdvancedParam.getValue());
                }
            }
            if (sqoopParameters.getConcurrency() > 0) {
                commonSb.append(" ").append("-m").append(" ").append(sqoopParameters.getConcurrency());
            }
        }
        catch (Exception e) {
            logger.error(String.format("Sqoop task general param build failed: [%s]", e.getMessage()));
        }
        return commonSb.toString();
    }
}

