/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.rpc.serializer;

import java.util.HashMap;
import org.apache.dolphinscheduler.rpc.serializer.ProtoStuffSerializer;
import org.apache.dolphinscheduler.rpc.serializer.Serializer;

public enum RpcSerializer {
    PROTOSTUFF(1, new ProtoStuffSerializer());

    byte type;
    Serializer serializer;
    private static HashMap<Byte, Serializer> SERIALIZERS_MAP;

    private RpcSerializer(byte type, Serializer serializer) {
        this.type = type;
        this.serializer = serializer;
    }

    public byte getType() {
        return this.type;
    }

    public static Serializer getSerializerByType(byte type) {
        return SERIALIZERS_MAP.get(type);
    }

    static {
        SERIALIZERS_MAP = new HashMap();
        for (RpcSerializer rpcSerializer : RpcSerializer.values()) {
            SERIALIZERS_MAP.put(rpcSerializer.type, rpcSerializer.serializer);
        }
    }
}

