/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.remote.command;

import java.io.Serializable;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;

public class StateEventChangeCommand
implements Serializable {
    private String key;
    private ExecutionStatus sourceStatus;
    private int sourceProcessInstanceId;
    private int sourceTaskInstanceId;
    private int destProcessInstanceId;
    private int destTaskInstanceId;

    public StateEventChangeCommand() {
    }

    public StateEventChangeCommand(int sourceProcessInstanceId, int sourceTaskInstanceId, ExecutionStatus sourceStatus, int destProcessInstanceId, int destTaskInstanceId) {
        this.key = String.format("%d-%d-%d-%d", sourceProcessInstanceId, sourceTaskInstanceId, destProcessInstanceId, destTaskInstanceId);
        this.sourceStatus = sourceStatus;
        this.sourceProcessInstanceId = sourceProcessInstanceId;
        this.sourceTaskInstanceId = sourceTaskInstanceId;
        this.destProcessInstanceId = destProcessInstanceId;
        this.destTaskInstanceId = destTaskInstanceId;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Command convert2Command() {
        Command command = new Command();
        command.setType(CommandType.STATE_EVENT_REQUEST);
        byte[] body = JSONUtils.toJsonByteArray((Object)this);
        command.setBody(body);
        return command;
    }

    public String toString() {
        return "StateEventResponseCommand{key=" + this.key + '}';
    }

    public ExecutionStatus getSourceStatus() {
        return this.sourceStatus;
    }

    public void setSourceStatus(ExecutionStatus sourceStatus) {
        this.sourceStatus = sourceStatus;
    }

    public int getSourceProcessInstanceId() {
        return this.sourceProcessInstanceId;
    }

    public void setSourceProcessInstanceId(int sourceProcessInstanceId) {
        this.sourceProcessInstanceId = sourceProcessInstanceId;
    }

    public int getSourceTaskInstanceId() {
        return this.sourceTaskInstanceId;
    }

    public void setSourceTaskInstanceId(int sourceTaskInstanceId) {
        this.sourceTaskInstanceId = sourceTaskInstanceId;
    }

    public int getDestProcessInstanceId() {
        return this.destProcessInstanceId;
    }

    public void setDestProcessInstanceId(int destProcessInstanceId) {
        this.destProcessInstanceId = destProcessInstanceId;
    }

    public int getDestTaskInstanceId() {
        return this.destTaskInstanceId;
    }

    public void setDestTaskInstanceId(int destTaskInstanceId) {
        this.destTaskInstanceId = destTaskInstanceId;
    }
}

