/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.remote.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.exceptions.RemotingException;

@ChannelHandler.Sharable
public class NettyEncoder
extends MessageToByteEncoder<Command> {
    protected void encode(ChannelHandlerContext ctx, Command msg, ByteBuf out) throws Exception {
        if (msg == null) {
            throw new RemotingException("encode msg is null");
        }
        out.writeByte(-66);
        out.writeByte(0);
        out.writeByte(msg.getType().ordinal());
        out.writeLong(msg.getOpaque());
        this.writeContext(msg, out);
        out.writeInt(msg.getBody().length);
        out.writeBytes(msg.getBody());
    }

    private void writeContext(Command msg, ByteBuf out) {
        byte[] headerBytes = msg.getContext().toBytes();
        out.writeInt(headerBytes.length);
        out.writeBytes(headerBytes);
    }
}

