/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert.processor;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import org.apache.dolphinscheduler.alert.plugin.AlertPluginManager;
import org.apache.dolphinscheduler.alert.runner.AlertSender;
import org.apache.dolphinscheduler.dao.AlertDao;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.alert.AlertSendRequestCommand;
import org.apache.dolphinscheduler.remote.command.alert.AlertSendResponseCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.remote.utils.JsonSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertRequestProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(AlertRequestProcessor.class);
    private final AlertDao alertDao;
    private final AlertPluginManager alertPluginManager;

    public AlertRequestProcessor(AlertDao alertDao, AlertPluginManager alertPluginManager) {
        this.alertDao = alertDao;
        this.alertPluginManager = alertPluginManager;
    }

    public void process(Channel channel, Command command) {
        Preconditions.checkArgument((CommandType.ALERT_SEND_REQUEST == command.getType() ? 1 : 0) != 0, (Object)String.format("invalid command type : %s", command.getType()));
        AlertSendRequestCommand alertSendRequestCommand = (AlertSendRequestCommand)JsonSerializer.deserialize((byte[])command.getBody(), AlertSendRequestCommand.class);
        this.logger.info("received command : {}", (Object)alertSendRequestCommand);
        AlertSender alertSender = new AlertSender(this.alertDao, this.alertPluginManager);
        AlertSendResponseCommand alertSendResponseCommand = alertSender.syncHandler(alertSendRequestCommand.getGroupId(), alertSendRequestCommand.getTitle(), alertSendRequestCommand.getContent());
        channel.writeAndFlush((Object)alertSendResponseCommand.convert2Command(command.getOpaque()));
    }
}

