/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert.plugin;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dolphinscheduler.common.enums.PluginType;
import org.apache.dolphinscheduler.dao.DaoFactory;
import org.apache.dolphinscheduler.dao.PluginDao;
import org.apache.dolphinscheduler.dao.entity.PluginDefine;
import org.apache.dolphinscheduler.spi.DolphinSchedulerPlugin;
import org.apache.dolphinscheduler.spi.alert.AlertChannel;
import org.apache.dolphinscheduler.spi.alert.AlertChannelFactory;
import org.apache.dolphinscheduler.spi.classloader.ThreadContextClassLoader;
import org.apache.dolphinscheduler.spi.params.PluginParamsTransfer;
import org.apache.dolphinscheduler.spi.plugin.AbstractDolphinPluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertPluginManager
extends AbstractDolphinPluginManager {
    private static final Logger logger = LoggerFactory.getLogger(AlertPluginManager.class);
    private final Map<String, AlertChannelFactory> alertChannelFactoryMap = new ConcurrentHashMap<String, AlertChannelFactory>();
    private final Map<String, AlertChannel> alertChannelMap = new ConcurrentHashMap<String, AlertChannel>();
    private final Map<Integer, String> pluginDefineMap = new HashMap<Integer, String>();
    private final PluginDao pluginDao = (PluginDao)DaoFactory.getDaoInstance(PluginDao.class);

    private void addAlertChannelFactory(AlertChannelFactory alertChannelFactory) {
        Objects.requireNonNull(alertChannelFactory, "alertChannelFactory is null");
        if (this.alertChannelFactoryMap.putIfAbsent(alertChannelFactory.getName(), alertChannelFactory) != null) {
            throw new IllegalArgumentException(String.format("Alert Plugin '%s' is already registered", alertChannelFactory.getName()));
        }
        try {
            this.loadAlertChannel(alertChannelFactory.getName());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Alert Plugin '%s' is can not load .", alertChannelFactory.getName()));
        }
    }

    private void loadAlertChannel(String name) {
        Objects.requireNonNull(name, "name is null");
        AlertChannelFactory alertChannelFactory = this.alertChannelFactoryMap.get(name);
        Preconditions.checkState((alertChannelFactory != null ? 1 : 0) != 0, (String)"Alert Plugin %s is not registered", (Object)name);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(alertChannelFactory.getClass().getClassLoader());){
            AlertChannel alertChannel = alertChannelFactory.create();
            this.alertChannelMap.put(name, alertChannel);
        }
        logger.info("-- Loaded Alert Plugin {} --", (Object)name);
    }

    Map<String, AlertChannelFactory> getAlertChannelFactoryMap() {
        return this.alertChannelFactoryMap;
    }

    public Map<String, AlertChannel> getAlertChannelMap() {
        return this.alertChannelMap;
    }

    public String getPluginNameById(int id) {
        return this.pluginDefineMap.get(id);
    }

    public void installPlugin(DolphinSchedulerPlugin dolphinSchedulerPlugin) {
        for (AlertChannelFactory alertChannelFactory : dolphinSchedulerPlugin.getAlertChannelFactorys()) {
            logger.info("Registering Alert Plugin '{}'", (Object)alertChannelFactory.getName());
            this.addAlertChannelFactory(alertChannelFactory);
            List params = alertChannelFactory.getParams();
            String nameEn = alertChannelFactory.getName();
            String paramsJson = PluginParamsTransfer.transferParamsToJson((List)params);
            PluginDefine pluginDefine = new PluginDefine(nameEn, PluginType.ALERT.getDesc(), paramsJson);
            int id = this.pluginDao.addOrUpdatePluginDefine(pluginDefine);
            this.pluginDefineMap.put(id, pluginDefine.getPluginName());
        }
    }
}

