/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.dolphinscheduler.alert.plugin.AlertPluginManager;
import org.apache.dolphinscheduler.alert.processor.AlertRequestProcessor;
import org.apache.dolphinscheduler.alert.runner.AlertSender;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.dao.AlertDao;
import org.apache.dolphinscheduler.dao.DaoFactory;
import org.apache.dolphinscheduler.dao.PluginDao;
import org.apache.dolphinscheduler.remote.NettyRemotingServer;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.config.NettyServerConfig;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.spi.plugin.DolphinPluginLoader;
import org.apache.dolphinscheduler.spi.plugin.DolphinPluginManagerConfig;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertServer {
    private static final Logger logger = LoggerFactory.getLogger(AlertServer.class);
    private final PluginDao pluginDao = (PluginDao)DaoFactory.getDaoInstance(PluginDao.class);
    private final AlertDao alertDao = (AlertDao)DaoFactory.getDaoInstance(AlertDao.class);
    private AlertPluginManager alertPluginManager;
    public static final String ALERT_PLUGIN_BINDING = "alert.plugin.binding";
    public static final String ALERT_PLUGIN_DIR = "alert.plugin.dir";
    public static final String MAVEN_LOCAL_REPOSITORY = "maven.local.repository";
    private NettyRemotingServer server;

    public static AlertServer getInstance() {
        return AlertServerHolder.INSTANCE;
    }

    private AlertServer() {
    }

    private void checkTable() {
        if (!this.pluginDao.checkPluginDefineTableExist()) {
            logger.error("Plugin Define Table t_ds_plugin_define Not Exist . Please Create it First !");
            System.exit(1);
        }
    }

    private void initPlugin() {
        DolphinPluginManagerConfig alertPluginManagerConfig = new DolphinPluginManagerConfig();
        alertPluginManagerConfig.setPlugins(PropertyUtils.getString((String)ALERT_PLUGIN_BINDING));
        if (StringUtils.isNotBlank((CharSequence)PropertyUtils.getString((String)ALERT_PLUGIN_DIR))) {
            alertPluginManagerConfig.setInstalledPluginsDir(PropertyUtils.getString((String)ALERT_PLUGIN_DIR, (String)"lib/plugin/alert").trim());
        }
        if (StringUtils.isNotBlank((CharSequence)PropertyUtils.getString((String)MAVEN_LOCAL_REPOSITORY))) {
            alertPluginManagerConfig.setMavenLocalRepository(PropertyUtils.getString((String)MAVEN_LOCAL_REPOSITORY).trim());
        }
        this.alertPluginManager = new AlertPluginManager();
        DolphinPluginLoader alertPluginLoader = new DolphinPluginLoader(alertPluginManagerConfig, (List)ImmutableList.of((Object)((Object)this.alertPluginManager)));
        try {
            alertPluginLoader.loadPlugins();
        }
        catch (Exception e) {
            throw new RuntimeException("Load Alert Plugin Failed !", e);
        }
    }

    private void initRemoteServer() {
        NettyServerConfig serverConfig = new NettyServerConfig();
        serverConfig.setListenPort(50052);
        this.server = new NettyRemotingServer(serverConfig);
        this.server.registerProcessor(CommandType.ALERT_SEND_REQUEST, (NettyRequestProcessor)new AlertRequestProcessor(this.alertDao, this.alertPluginManager));
        this.server.start();
    }

    private void runSender() {
        new Thread(new Sender()).start();
    }

    public void start() {
        PropertyUtils.loadPropertyFile((String[])new String[]{"/alert.properties"});
        this.checkTable();
        this.initPlugin();
        this.initRemoteServer();
        logger.info("alert server ready start ");
        this.runSender();
    }

    public void stop() {
        this.server.close();
        logger.info("alert server shut down");
    }

    public static void main(String[] args) {
        AlertServer alertServer = AlertServer.getInstance();
        alertServer.start();
        Runtime.getRuntime().addShutdownHook(new Thread(alertServer::stop));
    }

    final class Sender
    implements Runnable {
        Sender() {
        }

        @Override
        public void run() {
            while (Stopper.isRunning()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                if (AlertServer.this.alertPluginManager == null || AlertServer.this.alertPluginManager.getAlertChannelMap().size() == 0) {
                    logger.warn("No Alert Plugin . Cannot send alert info. ");
                    continue;
                }
                List alerts = AlertServer.this.alertDao.listWaitExecutionAlert();
                new AlertSender(alerts, AlertServer.this.alertDao, AlertServer.this.alertPluginManager).run();
            }
        }
    }

    private static class AlertServerHolder {
        private static final AlertServer INSTANCE = new AlertServer();

        private AlertServerHolder() {
        }
    }
}

