/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.BaseService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.HadoopUtils;
import org.apache.dolphinscheduler.dao.entity.User;

public class BaseServiceImpl
implements BaseService {
    @Override
    public boolean isAdmin(User user) {
        return user.getUserType() == UserType.ADMIN_USER;
    }

    @Override
    public boolean isNotAdmin(User loginUser, Map<String, Object> result) {
        if (!this.isAdmin(loginUser)) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return true;
        }
        return false;
    }

    @Override
    public void putMsg(Map<String, Object> result, Status status, Object ... statusParams) {
        result.put("status", (Object)status);
        if (statusParams != null && statusParams.length > 0) {
            result.put("msg", MessageFormat.format(status.getMsg(), statusParams));
        } else {
            result.put("msg", status.getMsg());
        }
    }

    public void putMsg(Result result, Status status, Object ... statusParams) {
        result.setCode(status.getCode());
        if (statusParams != null && statusParams.length > 0) {
            result.setMsg(MessageFormat.format(status.getMsg(), statusParams));
        } else {
            result.setMsg(status.getMsg());
        }
    }

    @Override
    public boolean check(Map<String, Object> result, boolean bool, Status userNoOperationPerm) {
        if (bool) {
            result.put("status", (Object)userNoOperationPerm);
            result.put("msg", userNoOperationPerm.getMsg());
            return true;
        }
        return false;
    }

    @Override
    public void createTenantDirIfNotExists(String tenantCode) throws IOException {
        String resourcePath = HadoopUtils.getHdfsResDir((String)tenantCode);
        String udfsPath = HadoopUtils.getHdfsUdfDir((String)tenantCode);
        HadoopUtils.getInstance().mkdir(resourcePath);
        HadoopUtils.getInstance().mkdir(udfsPath);
    }

    @Override
    public boolean hasPerm(User operateUser, int createUserId) {
        return operateUser.getId() == createUserId || this.isAdmin(operateUser);
    }

    @Override
    public Map<String, Object> checkAndParseDateParameters(String startDateStr, String endDateStr) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Date start = null;
        if (!StringUtils.isEmpty((String)startDateStr) && Objects.isNull(start = DateUtils.getScheduleDate((String)startDateStr))) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "startDate,endDate");
            return result;
        }
        result.put("start time", start);
        Date end = null;
        if (!StringUtils.isEmpty((String)endDateStr) && Objects.isNull(end = DateUtils.getScheduleDate((String)endDateStr))) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, "startDate,endDate");
            return result;
        }
        result.put("end time", end);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }
}

