/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.integ;

import java.io.File;
import org.apache.directory.api.util.FileUtils;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.changelog.Tag;
import org.apache.directory.server.core.factory.DSAnnotationProcessor;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateDsRule
implements TestRule {
    private static final Logger LOG = LoggerFactory.getLogger(CreateDsRule.class);
    private DirectoryService directoryService;
    private CreateDsRule outerCreateDsRule;

    public CreateDsRule() {
    }

    public CreateDsRule(CreateDsRule outerCreateDsRule) {
        this.outerCreateDsRule = outerCreateDsRule;
    }

    public DirectoryService getDirectoryService() {
        return this.directoryService == null ? (this.outerCreateDsRule == null ? null : this.outerCreateDsRule.getDirectoryService()) : this.directoryService;
    }

    public Statement apply(final Statement base, final Description description) {
        CreateDS createDs = (CreateDS)description.getAnnotation(CreateDS.class);
        if (createDs == null) {
            final DirectoryService directoryService = this.getDirectoryService();
            if (directoryService != null && directoryService.getChangeLog().isEnabled()) {
                return new Statement(){

                    public void evaluate() throws Throwable {
                        Tag tag = directoryService.getChangeLog().tag();
                        DSAnnotationProcessor.applyLdifs((Description)description, (DirectoryService)directoryService);
                        LOG.debug("Tagged change log: {}", (Object)tag);
                        try {
                            base.evaluate();
                        }
                        finally {
                            if (directoryService.getChangeLog().getCurrentRevision() > tag.getRevision()) {
                                LOG.debug("Reverting to tag: {}", (Object)tag);
                                directoryService.revert(tag.getRevision());
                            } else {
                                LOG.debug("No changes made, nothing to revert");
                            }
                        }
                    }
                };
            }
            LOG.trace("no @CreateDS and no outer @CreateDS on: {}", (Object)description);
            return base;
        }
        return new Statement(){

            public void evaluate() throws Throwable {
                LOG.trace("Creating directory service");
                CreateDsRule.this.directoryService = DSAnnotationProcessor.getDirectoryService((Description)description);
                DSAnnotationProcessor.applyLdifs((Description)description, (DirectoryService)CreateDsRule.this.directoryService);
                try {
                    base.evaluate();
                }
                finally {
                    LOG.trace("Shutting down directory service");
                    CreateDsRule.this.directoryService.shutdown();
                    FileUtils.deleteDirectory((File)CreateDsRule.this.directoryService.getInstanceLayout().getInstanceDirectory());
                }
            }
        };
    }
}

