/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser.model.container;

import java.util.ArrayList;
import org.apache.directory.studio.ldifparser.model.container.LdifRecord;
import org.apache.directory.studio.ldifparser.model.lines.LdifChangeTypeLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifControlLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDnLine;

public class LdifChangeRecord
extends LdifRecord {
    public LdifChangeRecord(LdifDnLine dn) {
        super(dn);
    }

    public void addControl(LdifControlLine controlLine) {
        if (controlLine == null) {
            throw new IllegalArgumentException("null argument");
        }
        this.ldifParts.add(controlLine);
    }

    public void setChangeType(LdifChangeTypeLine changeTypeLine) {
        if (changeTypeLine == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (this.getChangeTypeLine() != null) {
            throw new IllegalArgumentException("changetype is already set");
        }
        this.ldifParts.add(changeTypeLine);
    }

    public LdifControlLine[] getControls() {
        ArrayList<LdifControlLine> ldifControlLines = new ArrayList<LdifControlLine>();
        for (Object part : this.ldifParts) {
            if (!(part instanceof LdifControlLine)) continue;
            ldifControlLines.add((LdifControlLine)part);
        }
        return ldifControlLines.toArray(new LdifControlLine[ldifControlLines.size()]);
    }

    public LdifChangeTypeLine getChangeTypeLine() {
        for (Object part : this.ldifParts) {
            if (!(part instanceof LdifChangeTypeLine)) continue;
            return (LdifChangeTypeLine)part;
        }
        return null;
    }

    @Override
    protected boolean isAbstractValid() {
        if (!super.isAbstractValid()) {
            return false;
        }
        return this.getChangeTypeLine() != null;
    }

    @Override
    public boolean isValid() {
        return this.isAbstractValid();
    }

    @Override
    public String getInvalidString() {
        if (this.getChangeTypeLine() == null) {
            return "Missing changetype line";
        }
        return super.getInvalidString();
    }
}

