/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapservers.model;

import org.apache.directory.studio.ldapservers.actions.CreateConnectionActionHelper;
import org.apache.directory.studio.ldapservers.model.LdapServer;
import org.eclipse.ui.IActionFilter;

public class LdapServerActionFilterAdapter
implements IActionFilter {
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final Object STATUS = "status";
    private static final Object STATUS_STARTED = "started";
    private static final Object STATUS_STARTING = "starting";
    private static final Object STATUS_STOPPED = "stopped";
    private static final Object STATUS_STOPPING = "stopping";
    private static final Object STATUS_UNKNOWN = "unknown";
    private static final Object EXTENSION_ID = "extensionId";
    private static final Object EXTENSION_NAME = "extensionName";
    private static final Object EXTENSION_VERSION = "extensionVersion";
    private static final Object EXTENSION_VENDOR = "extensionVendor";
    private static final Object HAS_CONFIGURATION_PAGE = "hasConfigurationPage";
    private static final Object IS_LDAP_PERSPECTIVE_AVAILABLE = "isLdapPerspectiveAvailable";
    private static LdapServerActionFilterAdapter INSTANCE = new LdapServerActionFilterAdapter();

    private LdapServerActionFilterAdapter() {
    }

    public static LdapServerActionFilterAdapter getInstance() {
        return INSTANCE;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (target instanceof LdapServer) {
            LdapServer server = (LdapServer)target;
            if (ID.equals(name)) {
                return value.equals(server.getId());
            }
            if (NAME.equals(name)) {
                return value.equals(server.getName());
            }
            if (STATUS.equals(name)) {
                switch (server.getStatus()) {
                    case STARTED: {
                        return value.equals(STATUS_STARTED);
                    }
                    case STARTING: {
                        return value.equals(STATUS_STARTING);
                    }
                    case STOPPED: {
                        return value.equals(STATUS_STOPPED);
                    }
                    case STOPPING: {
                        return value.equals(STATUS_STOPPING);
                    }
                    case UNKNOWN: {
                        return value.equals(STATUS_UNKNOWN);
                    }
                }
            } else if (EXTENSION_ID.equals(name)) {
                if (server.getLdapServerAdapterExtension() != null) {
                    return value.equals(server.getLdapServerAdapterExtension().getId());
                }
            } else if (EXTENSION_NAME.equals(name)) {
                if (server.getLdapServerAdapterExtension() != null) {
                    return value.equals(server.getLdapServerAdapterExtension().getName());
                }
            } else if (EXTENSION_VERSION.equals(name)) {
                if (server.getLdapServerAdapterExtension() != null) {
                    return value.equals(server.getLdapServerAdapterExtension().getVersion());
                }
            } else if (EXTENSION_VENDOR.equals(name)) {
                if (server.getLdapServerAdapterExtension() != null) {
                    return value.equals(server.getLdapServerAdapterExtension().getVendor());
                }
            } else {
                if (HAS_CONFIGURATION_PAGE.equals(name)) {
                    String configurationPageClassName = server.getLdapServerAdapterExtension().getConfigurationPageClassName();
                    boolean hasConfigurationPage = configurationPageClassName != null && !"".equals(configurationPageClassName);
                    return value.equalsIgnoreCase(hasConfigurationPage ? "true" : "false");
                }
                if (IS_LDAP_PERSPECTIVE_AVAILABLE.equals(name)) {
                    boolean booleanValue;
                    boolean isLdapPerspectiveAvailable = CreateConnectionActionHelper.isLdapBrowserPluginsAvailable();
                    return isLdapPerspectiveAvailable == (booleanValue = Boolean.parseBoolean(value));
                }
            }
        }
        return false;
    }
}

