/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.filtereditor;

import org.apache.directory.studio.ldapbrowser.common.filtereditor.FilterAutoEditStrategy;
import org.apache.directory.studio.ldapbrowser.common.filtereditor.FilterContentAssistProcessor;
import org.apache.directory.studio.ldapbrowser.common.filtereditor.FilterDamagerRepairer;
import org.apache.directory.studio.ldapbrowser.common.filtereditor.FilterFormattingStrategy;
import org.apache.directory.studio.ldapbrowser.common.filtereditor.FilterReconcilingStrategy;
import org.apache.directory.studio.ldapbrowser.common.filtereditor.FilterTextHover;
import org.apache.directory.studio.ldapbrowser.common.widgets.DialogContentAssistant;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.filter.parser.LdapFilterParser;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.ContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Shell;

public class FilterSourceViewerConfiguration
extends SourceViewerConfiguration {
    private IBrowserConnection connection;
    private LdapFilterParser parser;
    private PresentationReconciler presentationReconciler;
    private FilterDamagerRepairer damagerRepairer;
    private MonoReconciler reconciler;
    private FilterReconcilingStrategy reconcilingStrategy;
    private FilterTextHover textHover;
    private FilterAutoEditStrategy[] autoEditStrategies;
    private ContentFormatter formatter;
    private FilterFormattingStrategy formattingStrategy;
    private DialogContentAssistant contentAssistant;
    private FilterContentAssistProcessor contentAssistProcessor;

    public FilterSourceViewerConfiguration(LdapFilterParser parser, IBrowserConnection connection) {
        this.parser = parser;
        this.connection = connection;
    }

    public void setConnection(IBrowserConnection connection) {
        this.connection = connection;
        this.contentAssistProcessor.setSchema(connection == null ? null : connection.getSchema());
        this.textHover.setSchema(connection == null ? null : connection.getSchema());
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        if (this.damagerRepairer == null) {
            this.damagerRepairer = new FilterDamagerRepairer(this.parser);
        }
        if (this.presentationReconciler == null) {
            this.presentationReconciler = new PresentationReconciler();
            this.presentationReconciler.setDamager((IPresentationDamager)this.damagerRepairer, "__dftl_partition_content_type");
            this.presentationReconciler.setRepairer((IPresentationRepairer)this.damagerRepairer, "__dftl_partition_content_type");
        }
        return this.presentationReconciler;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (this.textHover == null) {
            this.textHover = new FilterTextHover(this.parser);
            this.textHover.setSchema(this.connection == null ? null : this.connection.getSchema());
        }
        return this.textHover;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.reconcilingStrategy == null) {
            this.reconcilingStrategy = new FilterReconcilingStrategy(sourceViewer, this.parser);
        }
        if (this.reconciler == null) {
            this.reconciler = new MonoReconciler((IReconcilingStrategy)this.reconcilingStrategy, false);
        }
        return this.reconciler;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if (this.autoEditStrategies == null) {
            this.autoEditStrategies = new FilterAutoEditStrategy[]{new FilterAutoEditStrategy(this.parser)};
        }
        return this.autoEditStrategies;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        if (this.formattingStrategy == null) {
            this.formattingStrategy = new FilterFormattingStrategy(sourceViewer, this.parser);
        }
        if (this.formatter == null) {
            this.formatter = new ContentFormatter();
            this.formatter.enablePartitionAwareFormatting(false);
            this.formatter.setFormattingStrategy((IFormattingStrategy)this.formattingStrategy, "__dftl_partition_content_type");
        }
        return this.formatter;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.contentAssistProcessor == null) {
            this.contentAssistProcessor = new FilterContentAssistProcessor(sourceViewer, this.parser);
            this.contentAssistProcessor.setSchema(this.connection == null ? null : this.connection.getSchema());
        }
        if (this.contentAssistant == null) {
            this.contentAssistant = new DialogContentAssistant();
            this.contentAssistant.enableAutoInsert(true);
            this.contentAssistant.setContentAssistProcessor(this.contentAssistProcessor, "__dftl_partition_content_type");
            this.contentAssistant.enableAutoActivation(true);
            this.contentAssistant.setAutoActivationDelay(100);
            this.contentAssistant.setContextInformationPopupOrientation(20);
            this.contentAssistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        }
        return this.contentAssistant;
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 64, null);
            }
        };
    }
}

