/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.views.modificationlogs;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.event.EventRunner;
import org.apache.directory.studio.connection.core.io.api.LdifModificationLogger;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserSelectionUtils;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.events.AttributesInitializedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.ChildrenInitializedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryUpdateListener;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.ui.views.connection.ConnectionView;
import org.apache.directory.studio.ldapbrowser.ui.views.modificationlogs.ModificationLogsView;
import org.apache.directory.studio.ldapbrowser.ui.views.modificationlogs.ModificationLogsViewInput;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class ModificationLogsViewUniversalListener
implements EntryUpdateListener {
    private ModificationLogsView view;
    private ModificationLogsViewInput input;
    private INullSelectionListener connectionSelectionListener = new INullSelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            Connection[] connections;
            if (ModificationLogsViewUniversalListener.this.view != null && part != null && ModificationLogsViewUniversalListener.this.view.getSite().getWorkbenchWindow() == part.getSite().getWorkbenchWindow() && (connections = BrowserSelectionUtils.getConnections((ISelection)selection)).length == 1) {
                IBrowserConnection connection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnectionById(connections[0].getId());
                ModificationLogsViewInput input = new ModificationLogsViewInput(connection, 0);
                ModificationLogsViewUniversalListener.this.setInput(input);
                ModificationLogsViewUniversalListener.this.scrollToNewest();
            }
        }
    };

    public ModificationLogsViewUniversalListener(ModificationLogsView view) {
        this.view = view;
        this.input = null;
        EventRegistry.addEntryUpdateListener((EntryUpdateListener)this, (EventRunner)BrowserCommonActivator.getDefault().getEventRunner());
        view.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener(ConnectionView.getId(), (ISelectionListener)this.connectionSelectionListener);
    }

    public void dispose() {
        if (this.view != null) {
            this.view.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(ConnectionView.getId(), (ISelectionListener)this.connectionSelectionListener);
            EventRegistry.removeEntryUpdateListener((EntryUpdateListener)this);
            this.view = null;
        }
    }

    void refreshInput() {
        ModificationLogsViewInput newInput = this.input;
        this.input = null;
        this.setInput(newInput);
    }

    void setInput(ModificationLogsViewInput input) {
        if (this.input != input && input.getBrowserConnection().getConnection() != null) {
            this.input = input;
            LdifModificationLogger modificationLogger = ConnectionCorePlugin.getDefault().getLdifModificationLogger();
            if (input != null && input.getBrowserConnection() != null && input.getBrowserConnection().getConnection() != null && modificationLogger != null) {
                StringBuffer sb = new StringBuffer();
                File[] files = modificationLogger.getFiles(input.getBrowserConnection().getConnection());
                int i = input.getIndex();
                if (i >= 0 && i < files.length && files[i] != null && files[i].exists() && files[i].canRead()) {
                    try {
                        FileReader fr = new FileReader(files[i]);
                        char[] cbuf = new char[4096];
                        int length = fr.read(cbuf);
                        while (length > 0) {
                            sb.append(cbuf, 0, length);
                            length = fr.read(cbuf);
                        }
                    }
                    catch (Exception e) {
                        sb.append(e.getMessage());
                    }
                }
                this.view.getMainWidget().getSourceViewer().getDocument().set(sb.toString());
                this.view.getActionGroup().setInput(input);
            }
        }
    }

    public void entryUpdated(EntryModificationEvent event) {
        if (!(event instanceof AttributesInitializedEvent) && !(event instanceof ChildrenInitializedEvent)) {
            this.refreshInput();
            this.scrollToNewest();
        }
    }

    public void scrollToOldest() {
        this.view.getMainWidget().getSourceViewer().setTopIndex(0);
    }

    public void scrollToNewest() {
        try {
            LdifContainer record = this.view.getMainWidget().getLdifModel().getLastContainer();
            int offset = record.getOffset();
            int line = this.view.getMainWidget().getSourceViewer().getDocument().getLineOfOffset(offset);
            if (line > 3) {
                line -= 3;
            }
            this.view.getMainWidget().getSourceViewer().setTopIndex(line);
        }
        catch (Exception exception) {}
    }

    public void clearInput() {
        if (this.input.getBrowserConnection().getConnection() != null) {
            StringBuffer sb = new StringBuffer("");
            FileWriter fw = null;
            LdifModificationLogger modificationLogger = ConnectionCorePlugin.getDefault().getLdifModificationLogger();
            File[] files = modificationLogger.getFiles(this.input.getBrowserConnection().getConnection());
            modificationLogger.dispose(this.input.getBrowserConnection().getConnection());
            int i = 0;
            while (i < files.length) {
                try {
                    if (files[i] != null && files[i].exists() && !files[i].delete()) {
                        fw = new FileWriter(files[i]);
                        fw.write("");
                    }
                }
                catch (Exception e) {
                    sb.append(e.getMessage());
                }
                ++i;
            }
            this.view.getMainWidget().getSourceViewer().setTopIndex(0);
            this.view.getMainWidget().getSourceViewer().getDocument().set(sb.toString());
        }
    }
}

