/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.widgets;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.common.ui.CommonUIUtils;
import org.apache.directory.studio.common.ui.HistoryUtils;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.apache.directory.studio.connection.core.jobs.CheckNetworkParameterRunnable;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.connection.ui.AbstractConnectionParameterPage;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.apache.directory.studio.connection.ui.RunnableContextRunner;
import org.apache.directory.studio.connection.ui.widgets.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class NetworkParameterPage
extends AbstractConnectionParameterPage {
    private static final String X_CONNECTION_NAME = "X-CONNECTION-NAME";
    private static final String X_ENCRYPTION = "X-ENCRYPTION";
    private static final String X_ENCRYPTION_LDAPS = "ldaps";
    private static final String X_ENCRYPTION_START_TLS = "StartTLS";
    private Text nameText;
    private Combo hostCombo;
    private Combo portCombo;
    private Combo encryptionMethodCombo;
    private Button checkConnectionButton;
    private Button readOnlyConnectionCheckbox;
    private Text timeoutSecondsText;
    private SelectionAdapter linkDataWidgetListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            String certificateValidationPreferencePageId = ConnectionUIPlugin.getDefault().getPluginProperties().getString("PrefPage_CertificateValidationPreferencePage_id");
            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)Display.getDefault().getActiveShell(), (String)certificateValidationPreferencePageId, (String[])new String[]{certificateValidationPreferencePageId}, null);
            dialog.open();
        }
    };

    private String getName() {
        return this.nameText.getText();
    }

    private String getHostName() {
        return this.hostCombo.getText();
    }

    private int getPort() {
        return Integer.parseInt(this.portCombo.getText());
    }

    private int getTimeoutSeconds() {
        String timeoutSecondsString = this.timeoutSecondsText.getText();
        if (Strings.isEmpty((String)timeoutSecondsString)) {
            return 30;
        }
        return Integer.parseInt(timeoutSecondsString);
    }

    private ConnectionParameter.EncryptionMethod getEncyrptionMethod() {
        switch (this.encryptionMethodCombo.getSelectionIndex()) {
            case 1: {
                return ConnectionParameter.EncryptionMethod.LDAPS;
            }
            case 2: {
                return ConnectionParameter.EncryptionMethod.START_TLS;
            }
        }
        return ConnectionParameter.EncryptionMethod.NONE;
    }

    private Connection getTestConnection() {
        ConnectionParameter connectionParameter = new ConnectionParameter(null, this.getHostName(), this.getPort(), this.getEncyrptionMethod(), ConnectionParameter.AuthenticationMethod.NONE, null, null, null, true, null, 30000L);
        return new Connection(connectionParameter);
    }

    private boolean isReadOnly() {
        return this.readOnlyConnectionCheckbox.getSelection();
    }

    @Override
    protected void createComposite(Composite parent) {
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
        Composite nameComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)2, (int)1);
        BaseWidgetUtils.createLabel((Composite)nameComposite, (String)Messages.getString("NetworkParameterPage.ConnectionName"), (int)1);
        this.nameText = BaseWidgetUtils.createText((Composite)nameComposite, (String)"", (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        Group group = BaseWidgetUtils.createGroup((Composite)composite, (String)Messages.getString("NetworkParameterPage.NetworkParameter"), (int)1);
        IDialogSettings dialogSettings = ConnectionUIPlugin.getDefault().getDialogSettings();
        Composite groupComposite = BaseWidgetUtils.createColumnContainer((Composite)group, (int)3, (int)1);
        BaseWidgetUtils.createLabel((Composite)groupComposite, (String)Messages.getString("NetworkParameterPage.HostName"), (int)1);
        String[] hostHistory = HistoryUtils.load((IDialogSettings)dialogSettings, (String)"hostHistory");
        this.hostCombo = BaseWidgetUtils.createCombo((Composite)groupComposite, (String[])hostHistory, (int)-1, (int)2);
        BaseWidgetUtils.createLabel((Composite)groupComposite, (String)Messages.getString("NetworkParameterPage.Port"), (int)1);
        String[] portHistory = HistoryUtils.load((IDialogSettings)dialogSettings, (String)"portHistory");
        this.portCombo = BaseWidgetUtils.createCombo((Composite)groupComposite, (String[])portHistory, (int)-1, (int)2);
        this.portCombo.setTextLimit(5);
        this.portCombo.setText("389");
        BaseWidgetUtils.createLabel((Composite)groupComposite, (String)Messages.getString("NetworkParameterPage.Timeout"), (int)2);
        this.timeoutSecondsText = BaseWidgetUtils.createText((Composite)groupComposite, (String)"30", (int)1);
        this.timeoutSecondsText.setTextLimit(7);
        String[] encMethods = new String[]{Messages.getString("NetworkParameterPage.NoEncryption"), Messages.getString("NetworkParameterPage.UseSSLEncryption"), Messages.getString("NetworkParameterPage.UseStartTLS")};
        BaseWidgetUtils.createLabel((Composite)groupComposite, (String)Messages.getString("NetworkParameterPage.EncryptionMethod"), (int)1);
        this.encryptionMethodCombo = BaseWidgetUtils.createReadonlyCombo((Composite)groupComposite, (String[])encMethods, (int)0, (int)2);
        boolean validateCertificates = ConnectionCorePlugin.getDefault().getPluginPreferences().getBoolean("validateCertificates");
        if (validateCertificates) {
            BaseWidgetUtils.createSpacer((Composite)groupComposite, (int)1);
            Link link = BaseWidgetUtils.createLink((Composite)groupComposite, (String)Messages.getString("NetworkParameterPage.CertificateValidationLink"), (int)2);
            GridData linkGridData = new GridData(768);
            linkGridData.horizontalSpan = 2;
            linkGridData.widthHint = 100;
            link.setLayoutData((Object)linkGridData);
            link.addSelectionListener((SelectionListener)this.linkDataWidgetListener);
        } else {
            BaseWidgetUtils.createSpacer((Composite)groupComposite, (int)1);
            BaseWidgetUtils.createLabel((Composite)groupComposite, (String)Messages.getString("NetworkParameterPage.WarningCertificateValidation"), (int)2);
        }
        BaseWidgetUtils.createSpacer((Composite)groupComposite, (int)2);
        this.checkConnectionButton = new Button(groupComposite, 8);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        gridData.verticalAlignment = 1024;
        this.checkConnectionButton.setLayoutData((Object)gridData);
        this.checkConnectionButton.setText(Messages.getString("NetworkParameterPage.CheckNetworkParameter"));
        this.readOnlyConnectionCheckbox = BaseWidgetUtils.createCheckbox((Composite)composite, (String)Messages.getString("NetworkParameterPage.ReadOnly"), (int)1);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        this.nameText.setFocus();
    }

    @Override
    protected void validate() {
        this.checkConnectionButton.setEnabled(!this.hostCombo.getText().equals("") && !this.portCombo.getText().equals(""));
        this.message = null;
        this.infoMessage = null;
        this.errorMessage = null;
        if (Strings.isEmpty((String)this.portCombo.getText())) {
            this.message = Messages.getString("NetworkParameterPage.PleaseEnterPort");
        }
        if (Strings.isEmpty((String)this.hostCombo.getText())) {
            this.message = Messages.getString("NetworkParameterPage.PleaseEnterHostname");
        }
        if (Strings.isEmpty((String)this.nameText.getText())) {
            this.message = Messages.getString("NetworkParameterPage.PleaseEnterConnectionName");
        }
        if (Strings.isEmpty((String)this.timeoutSecondsText.getText())) {
            this.timeoutSecondsText.setText("30");
        }
        if (!(ConnectionCorePlugin.getDefault().getConnectionManager().getConnectionByName(this.nameText.getText()) == null || this.connectionParameter != null && this.nameText.getText().equals(this.connectionParameter.getName()))) {
            this.errorMessage = NLS.bind((String)Messages.getString("NetworkParameterPage.ConnectionExists"), (Object[])new String[]{this.nameText.getText()});
        }
    }

    @Override
    protected void loadParameters(ConnectionParameter parameter) {
        this.connectionParameter = parameter;
        this.nameText.setText(CommonUIUtils.getTextValue((String)parameter.getName()));
        this.hostCombo.setText(CommonUIUtils.getTextValue((String)parameter.getHost()));
        this.portCombo.setText(Integer.toString(parameter.getPort()));
        int encryptionMethodIndex = 0;
        if (parameter.getEncryptionMethod() == ConnectionParameter.EncryptionMethod.LDAPS) {
            encryptionMethodIndex = 1;
        } else if (parameter.getEncryptionMethod() == ConnectionParameter.EncryptionMethod.START_TLS) {
            encryptionMethodIndex = 2;
        }
        this.encryptionMethodCombo.select(encryptionMethodIndex);
        this.readOnlyConnectionCheckbox.setSelection(parameter.isReadOnly());
        this.timeoutSecondsText.setText(Long.toString(parameter.getTimeoutMillis() / 1000L));
    }

    @Override
    protected void initListeners() {
        this.nameText.addModifyListener(event -> this.connectionPageModified());
        this.hostCombo.addModifyListener(event -> this.connectionPageModified());
        this.portCombo.addVerifyListener(event -> {
            if (!event.text.matches("[0-9]*")) {
                event.doit = false;
            }
        });
        this.portCombo.addModifyListener(event -> this.connectionPageModified());
        this.encryptionMethodCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NetworkParameterPage.this.connectionPageModified();
            }
        });
        this.checkConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Connection connection = NetworkParameterPage.this.getTestConnection();
                CheckNetworkParameterRunnable runnable = new CheckNetworkParameterRunnable(connection);
                IStatus status = RunnableContextRunner.execute((StudioConnectionRunnableWithProgress)runnable, NetworkParameterPage.this.runnableContext, true);
                if (status.isOK()) {
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString("NetworkParameterPage.CheckNetworkParameter"), (String)Messages.getString("NetworkParameterPage.ConnectionEstablished"));
                }
            }
        });
        this.readOnlyConnectionCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NetworkParameterPage.this.connectionPageModified();
            }
        });
        this.timeoutSecondsText.addModifyListener(event -> this.connectionPageModified());
        this.timeoutSecondsText.addVerifyListener(event -> {
            if (!event.text.matches("[0-9]*")) {
                event.doit = false;
            }
        });
    }

    @Override
    public void saveParameters(ConnectionParameter parameter) {
        parameter.setName(this.getName());
        parameter.setHost(this.getHostName());
        parameter.setPort(this.getPort());
        parameter.setEncryptionMethod(this.getEncyrptionMethod());
        parameter.setReadOnly(this.isReadOnly());
        parameter.setTimeoutMillis((long)this.getTimeoutSeconds() * 1000L);
    }

    @Override
    public void saveDialogSettings() {
        IDialogSettings dialogSettings = ConnectionUIPlugin.getDefault().getDialogSettings();
        HistoryUtils.save((IDialogSettings)dialogSettings, (String)"hostHistory", (String)this.hostCombo.getText());
        HistoryUtils.save((IDialogSettings)dialogSettings, (String)"portHistory", (String)this.portCombo.getText());
    }

    @Override
    public void setFocus() {
        this.nameText.setFocus();
    }

    @Override
    public boolean areParametersModifed() {
        return this.isReconnectionRequired() || !StringUtils.equals((CharSequence)this.connectionParameter.getName(), (CharSequence)this.getName());
    }

    @Override
    public boolean isReconnectionRequired() {
        return this.connectionParameter == null || !StringUtils.equals((CharSequence)this.connectionParameter.getHost(), (CharSequence)this.getHostName()) || this.connectionParameter.getPort() != this.getPort() || this.connectionParameter.getEncryptionMethod() != this.getEncyrptionMethod() || this.connectionParameter.isReadOnly() != this.isReadOnly() || this.connectionParameter.getTimeoutMillis() != (long)this.getTimeoutSeconds() * 1000L;
    }

    @Override
    public void mergeParametersToLdapURL(ConnectionParameter parameter, LdapUrl ldapUrl) {
        ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_CONNECTION_NAME, parameter.getName()));
        ldapUrl.setHost(parameter.getHost());
        ldapUrl.setPort(parameter.getPort());
        switch (parameter.getEncryptionMethod()) {
            case NONE: {
                break;
            }
            case LDAPS: {
                ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_ENCRYPTION, X_ENCRYPTION_LDAPS));
                break;
            }
            case START_TLS: {
                ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_ENCRYPTION, X_ENCRYPTION_START_TLS));
            }
        }
    }

    @Override
    public void mergeLdapUrlToParameters(LdapUrl ldapUrl, ConnectionParameter parameter) {
        String name = ldapUrl.getExtensionValue(X_CONNECTION_NAME);
        if (StringUtils.isEmpty((CharSequence)name)) {
            name = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss").format(new Date());
        }
        parameter.setName(name);
        parameter.setHost(ldapUrl.getHost());
        parameter.setPort(ldapUrl.getPort());
        String encryption = ldapUrl.getExtensionValue(X_ENCRYPTION);
        if (StringUtils.isNotEmpty((CharSequence)encryption) && X_ENCRYPTION_LDAPS.equalsIgnoreCase(encryption)) {
            parameter.setEncryptionMethod(ConnectionParameter.EncryptionMethod.LDAPS);
        } else if (StringUtils.isNotEmpty((CharSequence)encryption) && X_ENCRYPTION_START_TLS.equalsIgnoreCase(encryption)) {
            parameter.setEncryptionMethod(ConnectionParameter.EncryptionMethod.START_TLS);
        } else {
            parameter.setEncryptionMethod(ConnectionParameter.EncryptionMethod.NONE);
        }
    }
}

