/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifeditor.editor.actions;

import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Attribute;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DummyConnection;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DummyEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Value;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.apache.directory.studio.ldifeditor.editor.LdifEditor;
import org.apache.directory.studio.ldifeditor.editor.actions.AbstractLdifAction;
import org.apache.directory.studio.ldifeditor.editor.actions.Messages;
import org.apache.directory.studio.ldifparser.model.LdifPart;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifRecord;
import org.apache.directory.studio.ldifparser.model.lines.LdifAttrValLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifControlLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDeloldrdnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifNewrdnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifNewsuperiorLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifValueLineBase;
import org.apache.directory.studio.valueeditors.AbstractDialogValueEditor;
import org.apache.directory.studio.valueeditors.IValueEditor;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public abstract class AbstractOpenValueEditorAction
extends AbstractLdifAction {
    protected ValueEditorManager valueEditorManager;
    protected IValueEditor valueEditor;

    public AbstractOpenValueEditorAction(LdifEditor editor) {
        super(Messages.getString("AbstractOpenValueEditorAction.EditValue"), editor);
        this.valueEditorManager = editor.getValueEditorManager();
    }

    public Object getValueEditor() {
        return this.valueEditor;
    }

    @Override
    protected void doRun() {
        LdifPart[] parts = this.getSelectedLdifParts();
        if (parts.length == 1 && parts[0] instanceof LdifValueLineBase) {
            LdifValueLineBase line = (LdifValueLineBase)parts[0];
            String attributeDescription = this.getAttributeDescription();
            Object rawValue = this.getValueEditorRawValue();
            if (this.valueEditor instanceof AbstractDialogValueEditor) {
                AbstractDialogValueEditor cellEditor = (AbstractDialogValueEditor)this.valueEditor;
                cellEditor.setValue(rawValue);
                cellEditor.activate();
                Object newValue = cellEditor.getValue();
                if (newValue instanceof String || newValue instanceof byte[]) {
                    LdifAttrValLine newLine;
                    IDocument document = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
                    if (line instanceof LdifControlLine) {
                        LdifControlLine oldControlLine = (LdifControlLine)line;
                        newLine = newValue instanceof String ? LdifControlLine.create((String)oldControlLine.getUnfoldedOid(), (String)oldControlLine.getUnfoldedCriticality(), (String)((String)newValue)) : LdifControlLine.create((String)oldControlLine.getUnfoldedOid(), (String)oldControlLine.getUnfoldedCriticality(), (byte[])((byte[])newValue));
                    } else {
                        newLine = newValue instanceof String ? LdifAttrValLine.create((String)attributeDescription, (String)((String)newValue)) : LdifAttrValLine.create((String)attributeDescription, (byte[])((byte[])newValue));
                    }
                    try {
                        document.replace(line.getOffset(), line.getLength(), newLine.toFormattedString(Utils.getLdifFormatParameters()));
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    protected IBrowserConnection getConnection() {
        return this.editor.getConnection() != null ? this.editor.getConnection() : new DummyConnection(Schema.DEFAULT_SCHEMA);
    }

    protected Object getValueEditorRawValue() {
        IBrowserConnection connection = this.getConnection();
        String dn = this.getDn();
        String description = this.getAttributeDescription();
        Object value = this.getValue();
        Object rawValue = null;
        if (value != null) {
            try {
                DummyEntry dummyEntry = new DummyEntry(Dn.isValid((String)dn) ? new Dn(new String[]{dn}) : new Dn(), connection);
                Attribute dummyAttribute = new Attribute((IEntry)dummyEntry, description);
                Value dummyValue = new Value((IAttribute)dummyAttribute, value);
                rawValue = this.valueEditor.getRawValue((IValue)dummyValue);
            }
            catch (LdapInvalidDnException ldapInvalidDnException) {}
        }
        return rawValue;
    }

    protected String getDn() {
        LdifContainer[] selectedLdifContainers = this.getSelectedLdifContainers();
        String dn = null;
        if (selectedLdifContainers.length == 1 && selectedLdifContainers[0] instanceof LdifRecord) {
            LdifRecord record = (LdifRecord)selectedLdifContainers[0];
            LdifDnLine dnLine = record.getDnLine();
            dn = dnLine.getValueAsString();
        }
        return dn;
    }

    protected Object getValue() {
        LdifPart[] parts = this.getSelectedLdifParts();
        Object oldValue = null;
        if (parts.length == 1 && parts[0] instanceof LdifValueLineBase) {
            LdifValueLineBase line = (LdifValueLineBase)parts[0];
            oldValue = line.getValueAsObject();
            if (line instanceof LdifControlLine) {
                oldValue = ((LdifControlLine)line).getUnfoldedControlValue();
            }
        }
        return oldValue;
    }

    protected String getAttributeDescription() {
        String attributeDescription = null;
        LdifPart[] parts = this.getSelectedLdifParts();
        if (parts.length == 1 && parts[0] instanceof LdifValueLineBase) {
            LdifValueLineBase line = (LdifValueLineBase)parts[0];
            attributeDescription = line instanceof LdifControlLine ? "" : line.getUnfoldedLineStart();
        }
        return attributeDescription;
    }

    protected boolean isEditableLineSelected() {
        LdifPart[] parts = this.getSelectedLdifParts();
        boolean b = parts.length == 1 && (parts[0] instanceof LdifAttrValLine || parts[0] instanceof LdifDnLine || parts[0] instanceof LdifControlLine || parts[0] instanceof LdifNewrdnLine || parts[0] instanceof LdifDeloldrdnLine || parts[0] instanceof LdifNewsuperiorLine);
        return b;
    }
}

