/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.ldapbrowser.core.BookmarkManager;
import org.apache.directory.studio.ldapbrowser.core.SearchManager;
import org.apache.directory.studio.ldapbrowser.core.internal.search.LdapSearchPageScoreComputer;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IQuickSearch;
import org.apache.directory.studio.ldapbrowser.core.model.IRootDSE;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.impl.AttributeInfo;
import org.apache.directory.studio.ldapbrowser.core.model.impl.ChildrenInfo;
import org.apache.directory.studio.ldapbrowser.core.model.impl.RootDSE;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.eclipse.search.ui.ISearchPageScoreComputer;

public class BrowserConnection
implements IBrowserConnection,
Serializable {
    private static final long serialVersionUID = 2987596234755856270L;
    private Connection connection;
    private IRootDSE rootDSE;
    private Schema schema;
    private SearchManager searchManager;
    private BookmarkManager bookmarkManager;
    private IQuickSearch quickSearch;
    private volatile Map<String, IEntry> dnToEntryCache;
    private volatile Map<IEntry, String> entryToChildrenFilterMap;
    private volatile Map<IEntry, AttributeInfo> entryToAttributeInfoMap;
    private volatile Map<IEntry, ChildrenInfo> entryToChildrenInfoMap;

    public BrowserConnection(Connection connection) {
        this.connection = connection;
        if (connection.getConnectionParameter().getExtendedProperty("ldapbrowser.countLimit") == null) {
            connection.getConnectionParameter().setExtendedIntProperty("ldapbrowser.countLimit", 1000);
            connection.getConnectionParameter().setExtendedIntProperty("ldapbrowser.timeLimit", 0);
            connection.getConnectionParameter().setExtendedIntProperty("ldapbrowser.aliasesDereferencingMethod", Connection.AliasDereferencingMethod.ALWAYS.getOrdinal());
            connection.getConnectionParameter().setExtendedIntProperty("ldapbrowser.referralsHandlingMethod", Connection.ReferralHandlingMethod.FOLLOW_MANUALLY.getOrdinal());
            connection.getConnectionParameter().setExtendedBoolProperty("ldapbrowser.fetchBaseDns", true);
            connection.getConnectionParameter().setExtendedProperty("ldapbrowser.baseDn", "");
            connection.getConnectionParameter().setExtendedBoolProperty("ldapbrowser.fetchSubentries", false);
            connection.getConnectionParameter().setExtendedBoolProperty("ldapbrowser.pagedSearch", false);
            connection.getConnectionParameter().setExtendedIntProperty("ldapbrowser.pagedSearchSize", 100);
            connection.getConnectionParameter().setExtendedBoolProperty("ldapbrowser.pagedSearchScrollMode", true);
        }
        if (connection.getConnectionParameter().getExtendedProperty("ldapbrowser.modifyMode") == null) {
            connection.getConnectionParameter().setExtendedIntProperty("ldapbrowser.modifyMode", IBrowserConnection.ModifyMode.DEFAULT.getOrdinal());
            connection.getConnectionParameter().setExtendedIntProperty("ldapbrowser.modifyModeNoEMR", IBrowserConnection.ModifyMode.DEFAULT.getOrdinal());
            connection.getConnectionParameter().setExtendedIntProperty("ldapbrowser.modifyOrder", IBrowserConnection.ModifyOrder.DELETE_FIRST.getOrdinal());
        }
        this.searchManager = new SearchManager(this);
        this.bookmarkManager = new BookmarkManager(this);
        this.entryToChildrenFilterMap = new HashMap<IEntry, String>();
        this.dnToEntryCache = new HashMap<String, IEntry>();
        this.entryToAttributeInfoMap = new HashMap<IEntry, AttributeInfo>();
        this.entryToChildrenInfoMap = new HashMap<IEntry, ChildrenInfo>();
        this.schema = Schema.DEFAULT_SCHEMA;
        this.rootDSE = new RootDSE(this);
        this.cacheEntry(this.rootDSE);
    }

    @Override
    public LdapUrl getUrl() {
        return Utils.getLdapURL(this);
    }

    @Override
    public void clearCaches() {
        for (ISearch search : this.getSearchManager().getSearches()) {
            search.setSearchResults(null);
        }
        this.dnToEntryCache.clear();
        this.entryToAttributeInfoMap.clear();
        this.entryToChildrenInfoMap.clear();
        this.entryToChildrenFilterMap.clear();
        this.rootDSE = new RootDSE(this);
        this.cacheEntry(this.rootDSE);
    }

    @Override
    public IEntry getEntryFromCache(Dn dn) {
        if (dn == null) {
            return null;
        }
        String oidDn = Utils.getNormalizedOidString(dn, this.getSchema());
        if (this.dnToEntryCache != null && this.dnToEntryCache.containsKey(oidDn)) {
            return this.dnToEntryCache.get(oidDn);
        }
        if (this.getRootDSE().getDn().equals((Object)dn)) {
            return this.getRootDSE();
        }
        return null;
    }

    @Override
    public boolean isFetchBaseDNs() {
        return this.connection.getConnectionParameter().getExtendedBoolProperty("ldapbrowser.fetchBaseDns");
    }

    @Override
    public void setFetchBaseDNs(boolean fetchBaseDNs) {
        this.connection.getConnectionParameter().setExtendedBoolProperty("ldapbrowser.fetchBaseDns", fetchBaseDNs);
        ConnectionEventRegistry.fireConnectionUpdated((Connection)this.connection, (Object)this);
    }

    @Override
    public Dn getBaseDN() {
        try {
            return new Dn(new String[]{this.connection.getConnectionParameter().getExtendedProperty("ldapbrowser.baseDn")});
        }
        catch (LdapInvalidDnException ldapInvalidDnException) {
            return null;
        }
    }

    @Override
    public void setBaseDN(Dn baseDn) {
        this.connection.getConnectionParameter().setExtendedProperty("ldapbrowser.baseDn", baseDn.toString());
        ConnectionEventRegistry.fireConnectionUpdated((Connection)this.connection, (Object)this);
    }

    @Override
    public int getCountLimit() {
        return this.connection.getConnectionParameter().getExtendedIntProperty("ldapbrowser.countLimit");
    }

    @Override
    public void setCountLimit(int countLimit) {
        this.connection.getConnectionParameter().setExtendedIntProperty("ldapbrowser.countLimit", countLimit);
        ConnectionEventRegistry.fireConnectionUpdated((Connection)this.connection, (Object)this);
    }

    @Override
    public Connection.AliasDereferencingMethod getAliasesDereferencingMethod() {
        int ordinal = this.connection.getConnectionParameter().getExtendedIntProperty("ldapbrowser.aliasesDereferencingMethod");
        return Connection.AliasDereferencingMethod.getByOrdinal((int)ordinal);
    }

    @Override
    public void setAliasesDereferencingMethod(Connection.AliasDereferencingMethod aliasesDereferencingMethod) {
        this.connection.getConnectionParameter().setExtendedIntProperty("ldapbrowser.aliasesDereferencingMethod", aliasesDereferencingMethod.getOrdinal());
        ConnectionEventRegistry.fireConnectionUpdated((Connection)this.connection, (Object)this);
    }

    @Override
    public Connection.ReferralHandlingMethod getReferralsHandlingMethod() {
        int ordinal = this.connection.getConnectionParameter().getExtendedIntProperty("ldapbrowser.referralsHandlingMethod");
        return Connection.ReferralHandlingMethod.getByOrdinal((int)ordinal);
    }

    @Override
    public void setReferralsHandlingMethod(Connection.ReferralHandlingMethod referralsHandlingMethod) {
        this.connection.getConnectionParameter().setExtendedIntProperty("ldapbrowser.referralsHandlingMethod", referralsHandlingMethod.getOrdinal());
        ConnectionEventRegistry.fireConnectionUpdated((Connection)this.connection, (Object)this);
    }

    @Override
    public int getTimeLimit() {
        return this.connection.getConnectionParameter().getExtendedIntProperty("ldapbrowser.timeLimit");
    }

    @Override
    public void setTimeLimit(int timeLimit) {
        this.connection.getConnectionParameter().setExtendedIntProperty("ldapbrowser.timeLimit", timeLimit);
        ConnectionEventRegistry.fireConnectionUpdated((Connection)this.connection, (Object)this);
    }

    @Override
    public boolean isManageDsaIT() {
        return this.connection.getConnectionParameter().getExtendedBoolProperty("ldapbrowser.manageDsaIT");
    }

    @Override
    public void setManageDsaIT(boolean manageDsaIT) {
        this.connection.getConnectionParameter().setExtendedBoolProperty("ldapbrowser.manageDsaIT", manageDsaIT);
        ConnectionEventRegistry.fireConnectionUpdated((Connection)this.connection, (Object)this);
    }

    @Override
    public boolean isFetchSubentries() {
        return this.connection.getConnectionParameter().getExtendedBoolProperty("ldapbrowser.fetchSubentries");
    }

    @Override
    public void setFetchSubentries(boolean fetchSubentries) {
        this.connection.getConnectionParameter().setExtendedBoolProperty("ldapbrowser.fetchSubentries", fetchSubentries);
        ConnectionEventRegistry.fireConnectionUpdated((Connection)this.connection, (Object)this);
    }

    @Override
    public boolean isFetchOperationalAttributes() {
        return this.connection.getConnectionParameter().getExtendedBoolProperty("ldapbrowser.fetchOperationalAttributes");
    }

    @Override
    public void setFetchOperationalAttributes(boolean fetchOperationalAttribures) {
        this.connection.getConnectionParameter().setExtendedBoolProperty("ldapbrowser.fetchOperationalAttributes", fetchOperationalAttribures);
        ConnectionEventRegistry.fireConnectionUpdated((Connection)this.connection, (Object)this);
    }

    @Override
    public boolean isPagedSearch() {
        return this.connection.getConnectionParameter().getExtendedBoolProperty("ldapbrowser.pagedSearch");
    }

    @Override
    public void setPagedSearch(boolean pagedSearch) {
        this.connection.getConnectionParameter().setExtendedBoolProperty("ldapbrowser.pagedSearch", pagedSearch);
        ConnectionEventRegistry.fireConnectionUpdated((Connection)this.connection, (Object)this);
    }

    @Override
    public int getPagedSearchSize() {
        return this.connection.getConnectionParameter().getExtendedIntProperty("ldapbrowser.pagedSearchSize");
    }

    @Override
    public void setPagedSearchSize(int pagedSearchSize) {
        this.connection.getConnectionParameter().setExtendedIntProperty("ldapbrowser.pagedSearchSize", pagedSearchSize);
        ConnectionEventRegistry.fireConnectionUpdated((Connection)this.connection, (Object)this);
    }

    @Override
    public boolean isPagedSearchScrollMode() {
        return this.connection.getConnectionParameter().getExtendedBoolProperty("ldapbrowser.pagedSearchScrollMode");
    }

    @Override
    public void setPagedSearchScrollMode(boolean pagedSearchScrollMode) {
        this.connection.getConnectionParameter().setExtendedBoolProperty("ldapbrowser.pagedSearchScrollMode", pagedSearchScrollMode);
        ConnectionEventRegistry.fireConnectionUpdated((Connection)this.connection, (Object)this);
    }

    @Override
    public IBrowserConnection.ModifyMode getModifyMode() {
        int ordinal = this.connection.getConnectionParameter().getExtendedIntProperty("ldapbrowser.modifyMode");
        return IBrowserConnection.ModifyMode.getByOrdinal(ordinal);
    }

    @Override
    public void setModifyMode(IBrowserConnection.ModifyMode mode) {
        this.connection.getConnectionParameter().setExtendedIntProperty("ldapbrowser.modifyMode", mode.getOrdinal());
        ConnectionEventRegistry.fireConnectionUpdated((Connection)this.connection, (Object)this);
    }

    @Override
    public IBrowserConnection.ModifyMode getModifyModeNoEMR() {
        int ordinal = this.connection.getConnectionParameter().getExtendedIntProperty("ldapbrowser.modifyModeNoEMR");
        return IBrowserConnection.ModifyMode.getByOrdinal(ordinal);
    }

    @Override
    public void setModifyModeNoEMR(IBrowserConnection.ModifyMode mode) {
        this.connection.getConnectionParameter().setExtendedIntProperty("ldapbrowser.modifyModeNoEMR", mode.getOrdinal());
        ConnectionEventRegistry.fireConnectionUpdated((Connection)this.connection, (Object)this);
    }

    @Override
    public IBrowserConnection.ModifyOrder getModifyAddDeleteOrder() {
        int ordinal = this.connection.getConnectionParameter().getExtendedIntProperty("ldapbrowser.modifyOrder");
        return IBrowserConnection.ModifyOrder.getByOrdinal(ordinal);
    }

    @Override
    public void setModifyAddDeleteOrder(IBrowserConnection.ModifyOrder mode) {
        this.connection.getConnectionParameter().setExtendedIntProperty("ldapbrowser.modifyOrder", mode.getOrdinal());
        ConnectionEventRegistry.fireConnectionUpdated((Connection)this.connection, (Object)this);
    }

    @Override
    public void setQuickSearch(IQuickSearch quickSearch) {
        this.quickSearch = quickSearch;
    }

    @Override
    public IQuickSearch getQuickSearch() {
        return this.quickSearch;
    }

    @Override
    public final IRootDSE getRootDSE() {
        return this.rootDSE;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public String toString() {
        return this.getConnection() != null ? this.getConnection().getName() : "null";
    }

    @Override
    public SearchManager getSearchManager() {
        return this.searchManager;
    }

    @Override
    public BookmarkManager getBookmarkManager() {
        return this.bookmarkManager;
    }

    public Object getAdapter(Class adapter) {
        Class clazz = adapter;
        if (clazz.isAssignableFrom(ISearchPageScoreComputer.class)) {
            return new LdapSearchPageScoreComputer();
        }
        if (clazz.isAssignableFrom(IBrowserConnection.class)) {
            return this;
        }
        return null;
    }

    @Override
    public synchronized void cacheEntry(IEntry entry) {
        this.dnToEntryCache.put(Utils.getNormalizedOidString(entry.getDn(), this.getSchema()), entry);
    }

    protected synchronized void uncacheEntry(IEntry entry) {
        this.dnToEntryCache.remove(Utils.getNormalizedOidString(entry.getDn(), this.getSchema()));
    }

    @Override
    public synchronized void uncacheEntryRecursive(IEntry entry) {
        IEntry[] children = entry.getChildren();
        if (entry.getChildren() != null) {
            int i = 0;
            while (i < children.length) {
                this.uncacheEntryRecursive(children[i]);
                ++i;
            }
        }
        this.uncacheEntry(entry);
    }

    protected synchronized void uncacheEntry(Dn dn) {
        this.dnToEntryCache.remove(Utils.getNormalizedOidString(dn, this.getSchema()));
    }

    protected String getChildrenFilter(IEntry entry) {
        return this.entryToChildrenFilterMap == null ? null : this.entryToChildrenFilterMap.get(entry);
    }

    protected void setChildrenFilter(IEntry entry, String childrenFilter) {
        if (childrenFilter == null || "".equals(childrenFilter)) {
            this.entryToChildrenFilterMap.remove(entry);
        } else {
            this.entryToChildrenFilterMap.put(entry, childrenFilter);
        }
    }

    protected AttributeInfo getAttributeInfo(IEntry entry) {
        return this.entryToAttributeInfoMap == null ? null : this.entryToAttributeInfoMap.get(entry);
    }

    protected void setAttributeInfo(IEntry entry, AttributeInfo ai) {
        if (ai == null) {
            this.entryToAttributeInfoMap.remove(entry);
        } else {
            this.entryToAttributeInfoMap.put(entry, ai);
        }
    }

    protected ChildrenInfo getChildrenInfo(IEntry entry) {
        return this.entryToChildrenInfoMap == null ? null : this.entryToChildrenInfoMap.get(entry);
    }

    protected void setChildrenInfo(IEntry entry, ChildrenInfo ci) {
        if (ci == null) {
            this.entryToChildrenInfoMap.remove(entry);
        } else {
            this.entryToChildrenInfoMap.put(entry, ci);
        }
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }
}

