/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model;

import java.io.Serializable;
import java.util.Collection;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.studio.connection.core.ConnectionPropertyPageProvider;
import org.apache.directory.studio.connection.core.io.LdapRuntimeException;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionBulkRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.propertypageproviders.EntryPropertyPageProvider;
import org.eclipse.core.runtime.IAdaptable;

public interface IEntry
extends Serializable,
IAdaptable,
EntryPropertyPageProvider,
ConnectionPropertyPageProvider {
    public void addChild(IEntry var1);

    public void deleteChild(IEntry var1);

    public void addAttribute(IAttribute var1) throws IllegalArgumentException;

    public void deleteAttribute(IAttribute var1) throws IllegalArgumentException;

    public void setDirectoryEntry(boolean var1);

    public boolean isAlias();

    public void setAlias(boolean var1);

    public boolean isReferral();

    public void setReferral(boolean var1);

    public boolean isSubentry();

    public void setSubentry(boolean var1);

    public Dn getDn();

    public Rdn getRdn();

    public boolean isAttributesInitialized();

    public void setAttributesInitialized(boolean var1);

    public boolean isInitOperationalAttributes();

    public void setInitOperationalAttributes(boolean var1);

    public boolean isFetchAliases();

    public void setFetchAliases(boolean var1);

    public boolean isFetchReferrals();

    public void setFetchReferrals(boolean var1);

    public boolean isFetchSubentries();

    public void setFetchSubentries(boolean var1);

    public IAttribute[] getAttributes();

    public IAttribute getAttribute(String var1);

    public AttributeHierarchy getAttributeWithSubtypes(String var1);

    public boolean isChildrenInitialized();

    public void setChildrenInitialized(boolean var1);

    public boolean hasChildren();

    public void setHasChildrenHint(boolean var1);

    public IEntry[] getChildren();

    public int getChildrenCount();

    public boolean hasMoreChildren();

    public void setHasMoreChildren(boolean var1);

    public StudioConnectionBulkRunnableWithProgress getTopPageChildrenRunnable();

    public void setTopPageChildrenRunnable(StudioConnectionBulkRunnableWithProgress var1);

    public StudioConnectionBulkRunnableWithProgress getNextPageChildrenRunnable();

    public void setNextPageChildrenRunnable(StudioConnectionBulkRunnableWithProgress var1);

    public boolean hasParententry();

    public IEntry getParententry();

    public String getChildrenFilter();

    public void setChildrenFilter(String var1);

    public IBrowserConnection getBrowserConnection();

    public LdapUrl getUrl();

    public Collection<ObjectClass> getObjectClassDescriptions();

    default public Entry toEntry() {
        try {
            DefaultEntry entry = new DefaultEntry(this.getDn());
            IAttribute[] iAttributeArray = this.getAttributes();
            int n = iAttributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAttribute iAttribute = iAttributeArray[n2];
                DefaultAttribute attribute = new DefaultAttribute(iAttribute.getType());
                IValue[] iValueArray = iAttribute.getValues();
                int n3 = iValueArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IValue iValue = iValueArray[n4];
                    Object rawValue = iValue.getRawValue();
                    if (rawValue instanceof String) {
                        attribute.add(new String[]{(String)rawValue});
                    } else if (rawValue instanceof byte[]) {
                        attribute.add((byte[][])new byte[][]{(byte[])rawValue});
                    } else {
                        attribute.add(new String[]{null});
                    }
                    ++n4;
                }
                entry.add(new Attribute[]{attribute});
                ++n2;
            }
            return entry;
        }
        catch (LdapException e) {
            throw new LdapRuntimeException(e);
        }
    }
}

