/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.dialogs;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.directory.api.util.FileUtils;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.common.dialogs.Messages;
import org.apache.directory.studio.ldapbrowser.common.dialogs.TextDialog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class HexDialog
extends Dialog {
    private static final String DIALOG_TITLE = Messages.getString("HexDialog.HexEditor");
    private static final int EDIT_AS_TEXT_BUTTON_ID = 9997;
    private static final int LOAD_BUTTON_ID = 9998;
    private static final int SAVE_BUTTON_ID = 9999;
    private byte[] currentData;
    private byte[] returnData;
    private Text hexText;

    public HexDialog(Shell parentShell, byte[] initialData) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.currentData = initialData;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.returnData = this.currentData;
        } else if (buttonId == 9997) {
            TextDialog dialog = new TextDialog(this.getShell(), new String(this.currentData, StandardCharsets.UTF_8));
            if (dialog.open() == 0) {
                String text = dialog.getText();
                this.currentData = text.getBytes(StandardCharsets.UTF_8);
                this.hexText.setText(this.toFormattedHex(this.currentData));
            }
        } else if (buttonId == 9999) {
            FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
            fileDialog.setText(Messages.getString("HexDialog.SaveData"));
            String returnedFileName = fileDialog.open();
            if (returnedFileName != null) {
                try {
                    File file = new File(returnedFileName);
                    FileUtils.writeByteArrayToFile((File)file, (byte[])this.currentData);
                }
                catch (IOException e) {
                    ConnectionUIPlugin.getDefault().getExceptionHandler().handleException((IStatus)new Status(4, BrowserCommonConstants.PLUGIN_ID, 4, Messages.getString("HexDialog.CantWriteToFile"), (Throwable)e));
                }
            }
        } else if (buttonId == 9998) {
            FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
            fileDialog.setText(Messages.getString("HexDialog.LoadData"));
            String returnedFileName = fileDialog.open();
            if (returnedFileName != null) {
                try {
                    File file = new File(returnedFileName);
                    this.currentData = FileUtils.readFileToByteArray((File)file);
                    this.hexText.setText(this.toFormattedHex(this.currentData));
                }
                catch (IOException e) {
                    ConnectionUIPlugin.getDefault().getExceptionHandler().handleException((IStatus)new Status(4, BrowserCommonConstants.PLUGIN_ID, 4, Messages.getString("HexDialog.CantReadFile"), (Throwable)e));
                }
            }
        } else {
            this.returnData = null;
        }
        super.buttonPressed(buttonId);
    }

    private boolean isEditable(byte[] b) {
        if (b == null) {
            return false;
        }
        return !new String(b, StandardCharsets.UTF_8).contains("\ufffd");
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
        shell.setImage(BrowserCommonActivator.getDefault().getImage("resources/icons/hexeditor.gif"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.isEditable(this.currentData)) {
            this.createButton(parent, 9997, Messages.getString("HexDialog.EditAsText"), false);
        }
        this.createButton(parent, 9998, Messages.getString("HexDialog.LoadDataButton"), false);
        this.createButton(parent, 9999, Messages.getString("HexDialog.SaveDataButton"), false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.hexText = new Text(composite, 2826);
        this.hexText.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.hexText.setText(this.toFormattedHex(this.currentData));
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(420);
        gd.heightHint = this.convertHorizontalDLUsToPixels(150);
        this.hexText.setLayoutData((Object)gd);
        HexDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private String toFormattedHex(byte[] data) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < data.length) {
            String s;
            int b = data[i];
            if (b < 0) {
                b += 256;
            }
            if ((s = Integer.toHexString(b)).length() == 1) {
                s = "0" + s;
            }
            sb.append(s).append(" ");
            if ((i + 1) % 8 == 0 && (i + 1) % 16 != 0) {
                sb.append(" ");
            }
            if (i == data.length - 1) {
                while ((i + 1) % 16 != 0) {
                    sb.append("   ");
                    if ((i + 1) % 8 == 0) {
                        sb.append(" ");
                    }
                    ++i;
                }
            }
            if ((i + 1) % 16 == 0) {
                sb.append("    ");
                int x = i - 16 + 1;
                while (x <= i && x < data.length) {
                    if (data[x] > 32 && data[x] < 127) {
                        sb.append((char)data[x]);
                    } else {
                        sb.append('.');
                    }
                    if ((x + 1) % 8 == 0) {
                        sb.append(" ");
                    }
                    ++x;
                }
            }
            if ((i + 1) % 16 == 0) {
                sb.append("\r\n");
            }
            ++i;
        }
        return sb.toString();
    }

    public byte[] getData() {
        return this.returnData;
    }
}

