/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core.io.api;

import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.naming.directory.SearchControls;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.directory.api.ldap.codec.api.BinaryAttributeDetector;
import org.apache.directory.api.ldap.codec.api.DefaultConfigurableBinaryAttributeDetector;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.FilterParser;
import org.apache.directory.api.ldap.model.message.AddRequest;
import org.apache.directory.api.ldap.model.message.AddRequestImpl;
import org.apache.directory.api.ldap.model.message.AddResponse;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.ldap.model.message.BindRequestImpl;
import org.apache.directory.api.ldap.model.message.BindResponse;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.DeleteRequest;
import org.apache.directory.api.ldap.model.message.DeleteRequestImpl;
import org.apache.directory.api.ldap.model.message.DeleteResponse;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.ModifyDnRequest;
import org.apache.directory.api.ldap.model.message.ModifyDnRequestImpl;
import org.apache.directory.api.ldap.model.message.ModifyDnResponse;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.message.ModifyRequestImpl;
import org.apache.directory.api.ldap.model.message.ModifyResponse;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchRequestImpl;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.ldap.client.api.SaslCramMd5Request;
import org.apache.directory.ldap.client.api.SaslDigestMd5Request;
import org.apache.directory.ldap.client.api.SaslGssApiRequest;
import org.apache.directory.ldap.client.api.SaslPlainRequest;
import org.apache.directory.ldap.client.api.exception.InvalidConnectionException;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.apache.directory.studio.connection.core.IAuthHandler;
import org.apache.directory.studio.connection.core.ICredentials;
import org.apache.directory.studio.connection.core.ILdapLogger;
import org.apache.directory.studio.connection.core.Messages;
import org.apache.directory.studio.connection.core.ReferralsInfo;
import org.apache.directory.studio.connection.core.io.ConnectionWrapper;
import org.apache.directory.studio.connection.core.io.ConnectionWrapperUtils;
import org.apache.directory.studio.connection.core.io.StudioLdapException;
import org.apache.directory.studio.connection.core.io.StudioTrustManager;
import org.apache.directory.studio.connection.core.io.api.CancelException;
import org.apache.directory.studio.connection.core.io.api.StudioSearchResultEnumeration;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.osgi.util.NLS;

public class DirectoryApiConnectionWrapper
implements ConnectionWrapper {
    private static int searchRequestNum = 0;
    private Connection connection;
    private LdapConnectionConfig ldapConnectionConfig;
    private LdapNetworkConnection ldapConnection;
    private DefaultConfigurableBinaryAttributeDetector binaryAttributeDetector;
    private boolean isConnected = false;
    private Thread jobThread;
    private String bindPrincipal;
    private String bindPassword;
    private String authzId;

    public DirectoryApiConnectionWrapper(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void connect(StudioProgressMonitor monitor) {
        this.ldapConnection = null;
        this.isConnected = false;
        this.jobThread = null;
        try {
            this.doConnect(monitor);
        }
        catch (Exception e) {
            this.disconnect();
            monitor.reportError(e);
        }
    }

    private void doConnect(StudioProgressMonitor monitor) throws Exception {
        this.ldapConnection = null;
        this.isConnected = true;
        this.ldapConnectionConfig = new LdapConnectionConfig();
        this.ldapConnectionConfig.setLdapHost(this.connection.getHost());
        this.ldapConnectionConfig.setLdapPort(this.connection.getPort());
        long timeoutMillis = this.connection.getTimeoutMillis();
        if (timeoutMillis < 0L) {
            timeoutMillis = 30000L;
        }
        this.ldapConnectionConfig.setTimeout(timeoutMillis);
        this.binaryAttributeDetector = new DefaultConfigurableBinaryAttributeDetector();
        this.ldapConnectionConfig.setBinaryAttributeDetector((BinaryAttributeDetector)this.binaryAttributeDetector);
        if (this.connection.getEncryptionMethod() == ConnectionParameter.EncryptionMethod.LDAPS || this.connection.getEncryptionMethod() == ConnectionParameter.EncryptionMethod.START_TLS) {
            this.ldapConnectionConfig.setUseSsl(this.connection.getEncryptionMethod() == ConnectionParameter.EncryptionMethod.LDAPS);
            this.ldapConnectionConfig.setUseTls(this.connection.getEncryptionMethod() == ConnectionParameter.EncryptionMethod.START_TLS);
            try {
                TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                factory.init((KeyStore)null);
                TrustManager[] defaultTrustManagers = factory.getTrustManagers();
                TrustManager[] trustManagers = new StudioTrustManager[defaultTrustManagers.length];
                int i = 0;
                while (i < defaultTrustManagers.length) {
                    trustManagers[i] = new StudioTrustManager((X509TrustManager)defaultTrustManagers[i]);
                    ((StudioTrustManager)trustManagers[i]).setHost(this.connection.getHost());
                    ++i;
                }
                this.ldapConnectionConfig.setTrustManagers(trustManagers);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        InnerRunnable runnable = new InnerRunnable(this){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    long oldTimeout = ldapConnectionConfig.getTimeout();
                    ldapConnectionConfig.setTimeout(Math.min(oldTimeout, 5000L));
                    ldapConnection = new LdapNetworkConnection(ldapConnectionConfig);
                    boolean connected = ldapConnection.connect();
                    if (!connected) {
                        throw new Exception(Messages.DirectoryApiConnectionWrapper_UnableToConnect);
                    }
                    ldapConnectionConfig.setTimeout(oldTimeout);
                    return;
                }
                catch (Exception e) {
                    this.exception = this.toStudioLdapException(e);
                    try {
                        try {
                            if (ldapConnection != null) {
                                ldapConnection.close();
                            }
                        }
                        catch (Exception exception) {
                            ldapConnection = null;
                            binaryAttributeDetector = null;
                            return;
                        }
                    }
                    finally {
                        ldapConnection = null;
                        binaryAttributeDetector = null;
                    }
                }
            }
        };
        this.runAndMonitor(runnable, monitor);
        if (runnable.getException() != null) {
            throw runnable.getException();
        }
    }

    @Override
    public void disconnect() {
        if (this.jobThread != null) {
            Thread t = this.jobThread;
            this.jobThread = null;
            t.interrupt();
        }
        if (this.ldapConnection != null) {
            try {
                this.ldapConnection.close();
            }
            catch (Exception exception) {}
            this.ldapConnection = null;
            this.binaryAttributeDetector = null;
        }
        this.isConnected = false;
    }

    @Override
    public void bind(StudioProgressMonitor monitor) {
        try {
            this.doBind(monitor);
        }
        catch (Exception e) {
            this.disconnect();
            monitor.reportError(e);
        }
    }

    private BindResponse bindSimple(String bindPrincipal, String bindPassword) throws LdapException {
        BindRequestImpl bindRequest = new BindRequestImpl();
        bindRequest.setName(bindPrincipal);
        bindRequest.setCredentials(bindPassword);
        return this.ldapConnection.bind((BindRequest)bindRequest);
    }

    private BindResponse bindSaslPlain() throws LdapException {
        SaslPlainRequest saslPlainRequest = new SaslPlainRequest();
        saslPlainRequest.setUsername(this.bindPrincipal);
        saslPlainRequest.setCredentials(this.bindPassword);
        saslPlainRequest.setAuthorizationId(this.authzId);
        saslPlainRequest.setQualityOfProtection(this.connection.getConnectionParameter().getSaslQop());
        saslPlainRequest.setSecurityStrength(this.connection.getConnectionParameter().getSaslSecurityStrength());
        saslPlainRequest.setMutualAuthentication(this.connection.getConnectionParameter().isSaslMutualAuthentication());
        return this.ldapConnection.bindSaslPlain(this.bindPrincipal, this.bindPassword, this.authzId);
    }

    private void doBind(final StudioProgressMonitor monitor) throws Exception {
        if (this.ldapConnection != null && this.isConnected) {
            InnerRunnable runnable = new InnerRunnable(this){

                @Override
                public void run() {
                    try {
                        BindResponse bindResponse = null;
                        if (connection.getConnectionParameter().getAuthMethod() == ConnectionParameter.AuthenticationMethod.NONE) {
                            BindRequestImpl bindRequest = new BindRequestImpl();
                            bindResponse = ldapConnection.bind((BindRequest)bindRequest);
                        } else {
                            IAuthHandler authHandler = ConnectionCorePlugin.getDefault().getAuthHandler();
                            if (authHandler == null) {
                                Exception exception = new Exception(Messages.model__no_auth_handler);
                                monitor.setCanceled(true);
                                monitor.reportError(Messages.model__no_auth_handler, exception);
                                throw exception;
                            }
                            ICredentials credentials = authHandler.getCredentials(connection.getConnectionParameter());
                            if (credentials == null) {
                                Exception exception = new Exception();
                                monitor.setCanceled(true);
                                monitor.reportError(Messages.model__no_credentials, exception);
                                throw exception;
                            }
                            if (credentials.getBindPrincipal() == null || credentials.getBindPassword() == null) {
                                Exception exception = new Exception(Messages.model__no_credentials);
                                monitor.reportError(Messages.model__no_credentials, exception);
                                throw exception;
                            }
                            bindPrincipal = credentials.getBindPrincipal();
                            bindPassword = credentials.getBindPassword();
                            switch (connection.getConnectionParameter().getAuthMethod()) {
                                case SIMPLE: {
                                    bindResponse = this.bindSimple(bindPrincipal, bindPassword);
                                    break;
                                }
                                case SASL_PLAIN: {
                                    bindResponse = this.bindSaslPlain();
                                    break;
                                }
                                case SASL_CRAM_MD5: {
                                    SaslCramMd5Request cramMd5Request = new SaslCramMd5Request();
                                    cramMd5Request.setUsername(bindPrincipal);
                                    cramMd5Request.setCredentials(bindPassword);
                                    cramMd5Request.setQualityOfProtection(connection.getConnectionParameter().getSaslQop());
                                    cramMd5Request.setSecurityStrength(connection.getConnectionParameter().getSaslSecurityStrength());
                                    cramMd5Request.setMutualAuthentication(connection.getConnectionParameter().isSaslMutualAuthentication());
                                    bindResponse = ldapConnection.bind(cramMd5Request);
                                    break;
                                }
                                case SASL_DIGEST_MD5: {
                                    SaslDigestMd5Request digestMd5Request = new SaslDigestMd5Request();
                                    digestMd5Request.setUsername(bindPrincipal);
                                    digestMd5Request.setCredentials(bindPassword);
                                    digestMd5Request.setRealmName(connection.getConnectionParameter().getSaslRealm());
                                    digestMd5Request.setQualityOfProtection(connection.getConnectionParameter().getSaslQop());
                                    digestMd5Request.setSecurityStrength(connection.getConnectionParameter().getSaslSecurityStrength());
                                    digestMd5Request.setMutualAuthentication(connection.getConnectionParameter().isSaslMutualAuthentication());
                                    bindResponse = ldapConnection.bind(digestMd5Request);
                                    break;
                                }
                                case SASL_GSSAPI: {
                                    SaslGssApiRequest gssApiRequest = new SaslGssApiRequest();
                                    Preferences preferences = ConnectionCorePlugin.getDefault().getPluginPreferences();
                                    boolean useKrb5SystemProperties = preferences.getBoolean("useKrb5SystemProperties");
                                    String krb5LoginModule = preferences.getString("krb5LoginModule");
                                    if (!useKrb5SystemProperties) {
                                        gssApiRequest.setUsername(bindPrincipal);
                                        gssApiRequest.setCredentials(bindPassword);
                                        gssApiRequest.setQualityOfProtection(connection.getConnectionParameter().getSaslQop());
                                        gssApiRequest.setSecurityStrength(connection.getConnectionParameter().getSaslSecurityStrength());
                                        gssApiRequest.setMutualAuthentication(connection.getConnectionParameter().isSaslMutualAuthentication());
                                        gssApiRequest.setLoginModuleConfiguration((Configuration)new InnerConfiguration(krb5LoginModule));
                                        switch (connection.getConnectionParameter().getKrb5Configuration()) {
                                            case FILE: {
                                                gssApiRequest.setKrb5ConfFilePath(connection.getConnectionParameter().getKrb5ConfigurationFile());
                                                break;
                                            }
                                            case MANUAL: {
                                                gssApiRequest.setRealmName(connection.getConnectionParameter().getKrb5Realm());
                                                gssApiRequest.setKdcHost(connection.getConnectionParameter().getKrb5KdcHost());
                                                gssApiRequest.setKdcPort(connection.getConnectionParameter().getKrb5KdcPort());
                                                break;
                                            }
                                        }
                                    }
                                    bindResponse = ldapConnection.bind(gssApiRequest);
                                }
                            }
                        }
                        this.checkResponse((ResultResponse)bindResponse);
                    }
                    catch (Exception e) {
                        this.exception = this.toStudioLdapException(e);
                    }
                }
            };
            this.runAndMonitor(runnable, monitor);
            if (runnable.getException() != null) {
                throw runnable.getException();
            }
        } else {
            throw new Exception(Messages.DirectoryApiConnectionWrapper_NoConnection);
        }
    }

    @Override
    public void unbind() {
        this.disconnect();
    }

    @Override
    public boolean isConnected() {
        return this.ldapConnection != null && this.ldapConnection.isConnected();
    }

    @Override
    public void setBinaryAttributes(Collection<String> binaryAttributes) {
        if (this.binaryAttributeDetector != null) {
            this.binaryAttributeDetector.setBinaryAttributes(new String[0]);
            for (String binaryAttribute : binaryAttributes) {
                this.binaryAttributeDetector.addBinaryAttribute(new String[]{binaryAttribute});
            }
        }
    }

    @Override
    public StudioSearchResultEnumeration search(final String searchBase, final String filter, final SearchControls searchControls, final Connection.AliasDereferencingMethod aliasesDereferencingMethod, final Connection.ReferralHandlingMethod referralsHandlingMethod, final Control[] controls, final StudioProgressMonitor monitor, final ReferralsInfo referralsInfo) {
        final long requestNum = searchRequestNum++;
        InnerRunnable runnable = new InnerRunnable(this){

            @Override
            public void run() {
                try {
                    SearchRequestImpl request = new SearchRequestImpl();
                    request.setBase(new Dn(new String[]{searchBase}));
                    ExprNode node = FilterParser.parse((String)filter, (boolean)true);
                    request.setFilter(node);
                    request.setScope(this.convertSearchScope(searchControls));
                    if (searchControls.getReturningAttributes() != null) {
                        request.addAttributes(searchControls.getReturningAttributes());
                    }
                    if (controls != null) {
                        request.addAllControls(controls);
                    }
                    request.setSizeLimit(searchControls.getCountLimit());
                    request.setTimeLimit(searchControls.getTimeLimit());
                    request.setDerefAliases(this.convertAliasDerefMode(aliasesDereferencingMethod));
                    SearchCursor cursor = ldapConnection.search((SearchRequest)request);
                    this.searchResultEnumeration = new StudioSearchResultEnumeration(connection, cursor, searchBase, filter, searchControls, aliasesDereferencingMethod, referralsHandlingMethod, controls, requestNum, monitor, referralsInfo);
                }
                catch (Exception e) {
                    this.exception = this.toStudioLdapException(e);
                }
                for (ILdapLogger logger : this.getLdapLoggers()) {
                    if (this.searchResultEnumeration != null) {
                        logger.logSearchRequest(connection, searchBase, filter, searchControls, aliasesDereferencingMethod, controls, requestNum, this.exception);
                        continue;
                    }
                    logger.logSearchRequest(connection, searchBase, filter, searchControls, aliasesDereferencingMethod, controls, requestNum, this.exception);
                    logger.logSearchResultDone(connection, 0L, requestNum, this.exception);
                }
            }
        };
        try {
            this.checkConnectionAndRunAndMonitor(runnable, monitor);
        }
        catch (Exception e) {
            monitor.reportError(e);
            return null;
        }
        if (runnable.isCanceled()) {
            monitor.setCanceled(true);
        }
        if (runnable.getException() != null) {
            monitor.reportError(runnable.getException());
            return null;
        }
        return runnable.getResult();
    }

    private SearchScope convertSearchScope(SearchControls searchControls) {
        int scope = searchControls.getSearchScope();
        if (scope == 0) {
            return SearchScope.OBJECT;
        }
        if (scope == 1) {
            return SearchScope.ONELEVEL;
        }
        if (scope == 2) {
            return SearchScope.SUBTREE;
        }
        return SearchScope.SUBTREE;
    }

    private AliasDerefMode convertAliasDerefMode(Connection.AliasDereferencingMethod aliasesDereferencingMethod) {
        switch (aliasesDereferencingMethod) {
            case ALWAYS: {
                return AliasDerefMode.DEREF_ALWAYS;
            }
            case FINDING: {
                return AliasDerefMode.DEREF_FINDING_BASE_OBJ;
            }
            case NEVER: {
                return AliasDerefMode.NEVER_DEREF_ALIASES;
            }
            case SEARCH: {
                return AliasDerefMode.DEREF_IN_SEARCHING;
            }
        }
        return AliasDerefMode.DEREF_ALWAYS;
    }

    @Override
    public void modifyEntry(final Dn dn, final Collection<Modification> modifications, final Control[] controls, final StudioProgressMonitor monitor, final ReferralsInfo referralsInfo) {
        if (this.connection.isReadOnly()) {
            monitor.reportError(new Exception(NLS.bind((String)Messages.error__connection_is_readonly, (Object)this.connection.getName())));
            return;
        }
        InnerRunnable runnable = new InnerRunnable(this){

            @Override
            public void run() {
                try {
                    ReferralHandlingDataConsumer consumer;
                    ModifyResponse modifyResponse;
                    ModifyRequestImpl request = new ModifyRequestImpl();
                    request.setName(dn);
                    if (modifications != null) {
                        for (Modification modification : modifications) {
                            request.addModification(modification);
                        }
                    }
                    if (controls != null) {
                        request.addAllControls(controls);
                    }
                    if (this.checkAndHandleReferral((ResultResponse)(modifyResponse = ldapConnection.modify((ModifyRequest)request)), monitor, referralsInfo, consumer = referralHandlingData -> referralHandlingData.connectionWrapper.modifyEntry(new Dn(new String[]{referralHandlingData.referralDn}), modifications, controls, monitor, referralHandlingData.newReferralsInfo))) {
                        return;
                    }
                    this.checkResponse((ResultResponse)modifyResponse);
                }
                catch (Exception e) {
                    this.exception = this.toStudioLdapException(e);
                }
                for (ILdapLogger logger : this.getLdapLoggers()) {
                    logger.logChangetypeModify(connection, dn, modifications, controls, this.exception);
                }
            }
        };
        try {
            this.checkConnectionAndRunAndMonitor(runnable, monitor);
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
        if (runnable.isCanceled()) {
            monitor.setCanceled(true);
        }
        if (runnable.getException() != null) {
            monitor.reportError(runnable.getException());
        }
    }

    @Override
    public void renameEntry(final Dn oldDn, final Dn newDn, final boolean deleteOldRdn, final Control[] controls, final StudioProgressMonitor monitor, final ReferralsInfo referralsInfo) {
        if (this.connection.isReadOnly()) {
            monitor.reportError(new Exception(NLS.bind((String)Messages.error__connection_is_readonly, (Object)this.connection.getName())));
            return;
        }
        InnerRunnable runnable = new InnerRunnable(this){

            @Override
            public void run() {
                try {
                    ReferralHandlingDataConsumer consumer;
                    ModifyDnResponse modifyDnResponse;
                    ModifyDnRequestImpl request = new ModifyDnRequestImpl();
                    request.setName(oldDn);
                    request.setDeleteOldRdn(deleteOldRdn);
                    request.setNewRdn(newDn.getRdn());
                    request.setNewSuperior(newDn.getParent());
                    if (controls != null) {
                        request.addAllControls(controls);
                    }
                    if (this.checkAndHandleReferral((ResultResponse)(modifyDnResponse = ldapConnection.modifyDn((ModifyDnRequest)request)), monitor, referralsInfo, consumer = referralHandlingData -> referralHandlingData.connectionWrapper.renameEntry(oldDn, newDn, deleteOldRdn, controls, monitor, referralHandlingData.newReferralsInfo))) {
                        return;
                    }
                    this.checkResponse((ResultResponse)modifyDnResponse);
                }
                catch (Exception e) {
                    this.exception = this.toStudioLdapException(e);
                }
                for (ILdapLogger logger : this.getLdapLoggers()) {
                    logger.logChangetypeModDn(connection, oldDn, newDn, deleteOldRdn, controls, this.exception);
                }
            }
        };
        try {
            this.checkConnectionAndRunAndMonitor(runnable, monitor);
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
        if (runnable.isCanceled()) {
            monitor.setCanceled(true);
        }
        if (runnable.getException() != null) {
            monitor.reportError(runnable.getException());
        }
    }

    @Override
    public void createEntry(final Entry entry, final Control[] controls, final StudioProgressMonitor monitor, final ReferralsInfo referralsInfo) {
        if (this.connection.isReadOnly()) {
            monitor.reportError(new Exception(NLS.bind((String)Messages.error__connection_is_readonly, (Object)this.connection.getName())));
            return;
        }
        InnerRunnable runnable = new InnerRunnable(this){

            @Override
            public void run() {
                try {
                    ReferralHandlingDataConsumer consumer;
                    AddResponse addResponse;
                    AddRequestImpl request = new AddRequestImpl();
                    request.setEntry(entry);
                    if (controls != null) {
                        request.addAllControls(controls);
                    }
                    if (this.checkAndHandleReferral((ResultResponse)(addResponse = ldapConnection.add((AddRequest)request)), monitor, referralsInfo, consumer = referralHandlingData -> {
                        Entry entryWithReferralDn = entry.clone();
                        entryWithReferralDn.setDn(referralHandlingData.referralDn);
                        referralHandlingData.connectionWrapper.createEntry(entryWithReferralDn, controls, monitor, referralHandlingData.newReferralsInfo);
                    })) {
                        return;
                    }
                    this.checkResponse((ResultResponse)addResponse);
                }
                catch (Exception e) {
                    this.exception = this.toStudioLdapException(e);
                }
                for (ILdapLogger logger : this.getLdapLoggers()) {
                    logger.logChangetypeAdd(connection, entry, controls, this.exception);
                }
            }
        };
        try {
            this.checkConnectionAndRunAndMonitor(runnable, monitor);
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
        if (runnable.isCanceled()) {
            monitor.setCanceled(true);
        }
        if (runnable.getException() != null) {
            monitor.reportError(runnable.getException());
        }
    }

    @Override
    public void deleteEntry(final Dn dn, final Control[] controls, final StudioProgressMonitor monitor, final ReferralsInfo referralsInfo) {
        if (this.connection.isReadOnly()) {
            monitor.reportError(new Exception(NLS.bind((String)Messages.error__connection_is_readonly, (Object)this.connection.getName())));
            return;
        }
        InnerRunnable runnable = new InnerRunnable(this){

            @Override
            public void run() {
                try {
                    ReferralHandlingDataConsumer consumer;
                    DeleteResponse deleteResponse;
                    DeleteRequestImpl request = new DeleteRequestImpl();
                    request.setName(dn);
                    if (controls != null) {
                        request.addAllControls(controls);
                    }
                    if (this.checkAndHandleReferral((ResultResponse)(deleteResponse = ldapConnection.delete((DeleteRequest)request)), monitor, referralsInfo, consumer = referralHandlingData -> referralHandlingData.connectionWrapper.deleteEntry(new Dn(new String[]{referralHandlingData.referralDn}), controls, monitor, referralHandlingData.newReferralsInfo))) {
                        return;
                    }
                    this.checkResponse((ResultResponse)deleteResponse);
                }
                catch (Exception e) {
                    this.exception = this.toStudioLdapException(e);
                }
                for (ILdapLogger logger : this.getLdapLoggers()) {
                    logger.logChangetypeDelete(connection, dn, controls, this.exception);
                }
            }
        };
        try {
            this.checkConnectionAndRunAndMonitor(runnable, monitor);
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
        if (runnable.isCanceled()) {
            monitor.setCanceled(true);
        }
        if (runnable.getException() != null) {
            monitor.reportError(runnable.getException());
        }
    }

    @Override
    public ExtendedResponse extended(final ExtendedRequest request, StudioProgressMonitor monitor) {
        if (this.connection.isReadOnly()) {
            monitor.reportError(new Exception(NLS.bind((String)Messages.error__connection_is_readonly, (Object)this.connection.getName())));
            return null;
        }
        final ExtendedResponse[] outerResponse = new ExtendedResponse[1];
        InnerRunnable runnable = new InnerRunnable(this){

            @Override
            public void run() {
                try {
                    ExtendedResponse response;
                    outerResponse[0] = response = ldapConnection.extended(request);
                    this.checkResponse((ResultResponse)response);
                }
                catch (Exception e) {
                    this.exception = this.toStudioLdapException(e);
                }
                Iterator iterator = this.getLdapLoggers().iterator();
                while (iterator.hasNext()) {
                    ILdapLogger cfr_ignored_0 = (ILdapLogger)iterator.next();
                }
            }
        };
        try {
            this.checkConnectionAndRunAndMonitor(runnable, monitor);
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
        if (runnable.isCanceled()) {
            monitor.setCanceled(true);
        }
        if (runnable.getException() != null) {
            monitor.reportError(runnable.getException());
        }
        return outerResponse[0];
    }

    private boolean checkAndHandleReferral(ResultResponse response, StudioProgressMonitor monitor, ReferralsInfo referralsInfo, ReferralHandlingDataConsumer consumer) throws LdapException {
        if (response == null) {
            return false;
        }
        LdapResult ldapResult = response.getLdapResult();
        if (ldapResult == null || !ResultCodeEnum.REFERRAL.equals((Object)ldapResult.getResultCode())) {
            return false;
        }
        if (referralsInfo == null) {
            referralsInfo = new ReferralsInfo(true);
        }
        Referral referral = ldapResult.getReferral();
        referralsInfo.addReferral(referral);
        Referral nextReferral = referralsInfo.getNextReferral();
        Connection referralConnection = ConnectionWrapperUtils.getReferralConnection(nextReferral, monitor, this);
        if (referralConnection == null) {
            monitor.setCanceled(true);
            return true;
        }
        ArrayList urls = new ArrayList(referral.getLdapUrls());
        String referralDn = new LdapUrl((String)urls.get(0)).getDn().getName();
        ReferralHandlingData referralHandlingData = new ReferralHandlingData(referralConnection.getConnectionWrapper(), referralDn, referralsInfo);
        consumer.accept(referralHandlingData);
        return true;
    }

    private void checkConnectionAndRunAndMonitor(InnerRunnable runnable, StudioProgressMonitor monitor) throws Exception {
        if (!this.isConnected || this.ldapConnection == null) {
            this.doConnect(monitor);
            this.doBind(monitor);
        }
        if (this.ldapConnection == null) {
            throw new InvalidConnectionException(Messages.DirectoryApiConnectionWrapper_NoConnection);
        }
        int i = 0;
        while (i <= 1) {
            this.runAndMonitor(runnable, monitor);
            if (i != 0 || !(runnable.getException() instanceof InvalidConnectionException)) break;
            this.doConnect(monitor);
            this.doBind(monitor);
            runnable.reset();
            ++i;
        }
    }

    private void runAndMonitor(InnerRunnable runnable, StudioProgressMonitor monitor) throws CancelException {
        if (!monitor.isCanceled()) {
            StudioProgressMonitor.CancelListener listener = event -> {
                if (monitor.isCanceled()) {
                    if (this.jobThread != null && this.jobThread.isAlive()) {
                        this.jobThread.interrupt();
                    }
                    if (this.ldapConnection != null) {
                        try {
                            this.ldapConnection.close();
                        }
                        catch (Exception exception) {}
                        this.isConnected = false;
                        this.ldapConnection = null;
                    }
                    this.isConnected = false;
                }
            };
            monitor.addCancelListener(listener);
            this.jobThread = Thread.currentThread();
            try {
                runnable.run();
            }
            finally {
                monitor.removeCancelListener(listener);
                this.jobThread = null;
            }
            if (monitor.isCanceled()) {
                throw new CancelException();
            }
        }
    }

    private List<ILdapLogger> getLdapLoggers() {
        return ConnectionCorePlugin.getDefault().getLdapLoggers();
    }

    private void checkResponse(ResultResponse response) throws Exception {
        if (response != null) {
            ResultCodeEnum.processResponse((ResultResponse)response);
        }
    }

    private StudioLdapException toStudioLdapException(Exception exception) {
        if (exception == null) {
            return null;
        }
        if (exception instanceof LdapException) {
            return new StudioLdapException((Exception)((LdapException)exception));
        }
        return new StudioLdapException(exception);
    }

    private final class InnerConfiguration
    extends Configuration {
        private String krb5LoginModule;
        private AppConfigurationEntry[] configList = null;

        public InnerConfiguration(String krb5LoginModule) {
            this.krb5LoginModule = krb5LoginModule;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String applicationName) {
            if (this.configList == null) {
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("refreshKrb5Config", "true");
                switch (DirectoryApiConnectionWrapper.this.connection.getConnectionParameter().getKrb5CredentialConfiguration()) {
                    case USE_NATIVE: {
                        options.put("useTicketCache", "true");
                        options.put("doNotPrompt", "true");
                        break;
                    }
                    case OBTAIN_TGT: {
                        options.put("doNotPrompt", "false");
                    }
                }
                this.configList = new AppConfigurationEntry[1];
                this.configList[0] = new AppConfigurationEntry(this.krb5LoginModule, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
            }
            return this.configList;
        }

        @Override
        public void refresh() {
        }
    }

    abstract class InnerRunnable
    implements Runnable {
        protected StudioSearchResultEnumeration searchResultEnumeration = null;
        protected StudioLdapException exception = null;
        protected boolean canceled = false;

        InnerRunnable() {
        }

        public Exception getException() {
            return this.exception;
        }

        public StudioSearchResultEnumeration getResult() {
            return this.searchResultEnumeration;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void reset() {
            this.searchResultEnumeration = null;
            this.exception = null;
            this.canceled = false;
        }
    }

    static class ReferralHandlingData {
        ConnectionWrapper connectionWrapper;
        String referralDn;
        ReferralsInfo newReferralsInfo;

        ReferralHandlingData(ConnectionWrapper connectionWrapper, String referralDn, ReferralsInfo newReferralsInfo) {
            this.connectionWrapper = connectionWrapper;
            this.referralDn = referralDn;
            this.newReferralsInfo = newReferralsInfo;
        }
    }

    @FunctionalInterface
    private static interface ReferralHandlingDataConsumer {
        public void accept(ReferralHandlingData var1) throws LdapException;
    }
}

