<!--
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->

Apache Kerby 1.0.0-RC1 Release Note
===================================

In this release 236 JIRA issues were resolved and the following features are supported:

1. Kerberos libraries:
  - Client
  - KDC server
  - Kadmin
  - Credential cache and keytab utilities

2. Standalone KDC server .

3. Support for various identity backends:
  - In-memory
  - JSON
  - LDAP
  - Mavibot(MVCC BTree)
  - Zookeeper

4. Embedded KDC server allows easy integration into products for unit tests or production deployment.

5. FAST/Preauthentication framework to allow popular and useful authentication mechanisms.

6. Token Preauth mechanism to allow clients to request tickets using JWT tokens.

7. Client can request a TGT with:
  - User plain password credential
  - User keyTab
  - User token credential

8. Client can request a service ticket with:
  - user TGT credential for a server
  - user AccessToken credential for a server

9. Network support including UDP and TCP transport with two implementations:
  - Default implementation based on the JRE without depending on other libraries.
  - Netty based implementation for better throughput, lower latency.

10. Tools:
  - kdcinit: Initialize and prepare KDC, like choose storage type, setting up necessary principals (tgs, kadmin) etc.
  - kadmin: Command-line interfaces to administration system.
  - kinit: Obtains and caches an initial ticket-granting ticket for principal.
  - klist: Lists the Kerby principal and tickets held in a credentials cache, or the keys held in a keytab file.

11. Support for JAAS, GSSAPI and SASL frameworks that applications can leverage the authentication mechanisms provided by Kerby.

12. Building support: checking style and find bugs.
