/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.realm.tomcat;

import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.realm.J2eePolicyMgr;
import org.apache.directory.fortress.realm.J2eePolicyMgrFactory;
import org.apache.directory.fortress.realm.TcPrincipal;
import org.apache.directory.fortress.realm.tomcat.TcAccessMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcAccessMgrImpl
implements TcAccessMgr {
    private static final String CLS_NM = TcAccessMgrImpl.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);
    private static int count = 0;
    private J2eePolicyMgr j2eeMgr;
    private List<String> defaultRoles;
    private String contextId;

    public TcAccessMgrImpl() {
        try {
            this.j2eeMgr = J2eePolicyMgrFactory.createInstance();
            LOG.info("{} constructor <{}>", (Object)CLS_NM, (Object)TcAccessMgrImpl.incrementCtr());
        }
        catch (SecurityException se) {
            String error = CLS_NM + " constructor caught SecurityException=" + se;
            LOG.error(error);
            se.printStackTrace();
            throw new RuntimeException(error, se);
        }
    }

    private static int incrementCtr() {
        return count++;
    }

    public Principal authenticate(String userId, String password) {
        TcPrincipal principal = null;
        try {
            if (CollectionUtils.isNotEmpty(this.defaultRoles)) {
                principal = this.j2eeMgr.createSession(userId, password, this.defaultRoles);
                LOG.debug("{}.authenticate userId [{}], with default roles[{}], successful", new Object[]{CLS_NM, userId, this.defaultRoles});
            } else {
                principal = this.j2eeMgr.createSession(userId, password);
                LOG.debug("{}.authenticate userId [{}], successful", (Object)CLS_NM, (Object)userId);
            }
        }
        catch (SecurityException se) {
            LOG.warn("{}.authenticate userId <{}> caught SecurityException=", new Object[]{CLS_NM, userId, se});
        }
        return principal;
    }

    public boolean hasRole(Principal principal, String roleName) {
        boolean result = false;
        String userId = principal.getName();
        try {
            if (this.j2eeMgr.hasRole(principal, roleName)) {
                LOG.debug("{}.hasRole userId [{}], role[{}], successful", new Object[]{CLS_NM, principal.getName(), roleName});
                result = true;
            } else {
                LOG.debug("{}.hasRole userId [{}], role[{}], failed", new Object[]{CLS_NM, principal.getName(), roleName});
            }
        }
        catch (SecurityException se) {
            LOG.warn("{}.hasRole userId <{}> role <{}> caught SecurityException= {}", new Object[]{CLS_NM, userId, roleName, se});
        }
        return result;
    }

    public void setDefaultRoles(String szDefaultRoles) {
        if (StringUtils.isNotEmpty((String)szDefaultRoles)) {
            this.defaultRoles = Arrays.asList(szDefaultRoles.split("\\s*,\\s*"));
            LOG.info("DEFAULT ROLES: {}", this.defaultRoles);
        }
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
        this.j2eeMgr.setContextId(contextId);
        LOG.info("CONTEXT ID: {}", (Object)contextId);
    }
}

