/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.util;

import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.directory.fortress.core.util.Config;

public final class PropUtil {
    public static Properties getProperties(List<String> propList) {
        return PropUtil.getProperties(propList, ':');
    }

    public static Properties getProperties(List<String> propList, char separator) {
        Properties props = null;
        if (propList != null && propList.size() > 0) {
            props = new Properties();
            propList.size();
            for (String raw : propList) {
                int indx = raw.indexOf(separator);
                if (indx < 1) continue;
                props.setProperty(raw.substring(0, indx), raw.substring(indx + 1));
            }
        }
        return props;
    }

    public static Properties getProperties(String inputString) {
        return PropUtil.getProperties(inputString, ':');
    }

    public static Properties getProperties(String inputString, char separator) {
        return PropUtil.getProperties(inputString, separator, Config.getInstance().getDelimiter());
    }

    public static Properties getProperties(String inputString, char separator, String delimiter) {
        StringTokenizer maxTkn;
        Properties props = new Properties();
        if (inputString != null && inputString.length() > 0 && (maxTkn = new StringTokenizer(inputString, delimiter)).countTokens() > 0) {
            while (maxTkn.hasMoreTokens()) {
                String val = maxTkn.nextToken();
                int indx = val.indexOf(separator);
                if (indx < 1) continue;
                String name = val.substring(0, indx).trim();
                String value = val.substring(indx + 1).trim();
                props.setProperty(name, value);
            }
        }
        return props;
    }

    public static boolean isNotEmpty(Properties props) {
        return props != null && props.size() > 0;
    }
}

