/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.ValidationException;
import org.apache.directory.fortress.core.impl.PolicyDAO;
import org.apache.directory.fortress.core.model.PwPolicy;
import org.apache.directory.fortress.core.util.cache.Cache;
import org.apache.directory.fortress.core.util.cache.CacheMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PolicyP {
    private static final String CLS_NM = PolicyP.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);
    private static final int MAX_AGE = 157680000;
    private PolicyDAO olDao = new PolicyDAO();
    private static final ReadWriteLock policySetLock = new ReentrantReadWriteLock();
    private static Cache policyCache;
    private static final int MIN_PW_LEN = 20;
    private static final int MAX_FAILURE = 100;
    private static final int MAX_GRACE_COUNT = 10;
    private static final int MAX_HISTORY = 100;
    private static final String POLICIES = "policies";
    private static final String FORTRESS_POLICIES = "fortress.policies";

    private void init() {
        CacheMgr cacheMgr = CacheMgr.getInstance();
        policyCache = cacheMgr.getCache(FORTRESS_POLICIES);
    }

    PolicyP() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isValid(PwPolicy policy) {
        boolean result = false;
        try {
            policySetLock.readLock().lock();
            Set<String> policySet = this.getPolicySet(policy.getContextId());
            if (policySet != null) {
                result = policySet.contains(policy.getName());
            }
            boolean bl = result;
            return bl;
        }
        finally {
            policySetLock.readLock().unlock();
        }
    }

    PwPolicy read(PwPolicy policy) throws SecurityException {
        return this.olDao.getPolicy(policy);
    }

    void add(PwPolicy policy) throws SecurityException {
        this.validate(policy);
        this.olDao.create(policy);
        try {
            policySetLock.writeLock().lock();
            Set<String> policySet = this.getPolicySet(policy.getContextId());
            if (policySet != null) {
                policySet.add(policy.getName());
            }
        }
        finally {
            policySetLock.writeLock().unlock();
        }
    }

    void update(PwPolicy policy) throws SecurityException {
        this.validate(policy);
        this.olDao.update(policy);
    }

    void delete(PwPolicy policy) throws SecurityException {
        this.olDao.remove(policy);
        try {
            policySetLock.writeLock().lock();
            Set<String> policySet = this.getPolicySet(policy.getContextId());
            if (policySet != null) {
                policySet.remove(policy.getName());
            }
        }
        finally {
            policySetLock.writeLock().unlock();
        }
    }

    List<PwPolicy> search(PwPolicy policy) throws SecurityException {
        return this.olDao.findPolicy(policy);
    }

    private void validate(PwPolicy policy) throws ValidationException {
        int length = policy.getName().length();
        if (length < 1 || length > 40) {
            String error = "validate policy name [" + policy.getName() + "] INVALID LENGTH [" + length + "]";
            LOG.error(error);
            throw new ValidationException(4006, error);
        }
        if (policy.getCheckQuality() != null) {
            try {
                if (policy.getCheckQuality() < 0 || policy.getCheckQuality() > 2) {
                    String error = "validate policy name [" + policy.getName() + "] value checkQuality [" + policy.getCheckQuality() + "] INVALID INT VALUE";
                    LOG.error(error);
                    throw new ValidationException(4008, error);
                }
            }
            catch (NumberFormatException nfe) {
                String error = "validate policy name [" + policy.getName() + "] value checkQuality [" + policy.getCheckQuality() + "] INVALID INT VALUE";
                LOG.error(error);
                throw new ValidationException(4008, error);
            }
        }
        if (policy.getMaxAge() != null && policy.getMaxAge() > 157680000L) {
            String error = "validate policy name [" + policy.getName() + "] value maxAge [" + policy.getMaxAge() + "] INVALID INT VALUE";
            LOG.error(error);
            throw new ValidationException(4009, error);
        }
        if (policy.getMinAge() != null && policy.getMinAge() > 157680000) {
            String error = "validate policy name [" + policy.getName() + "] value minAge [" + policy.getMinAge() + "] INVALID INT VALUE";
            LOG.error(error);
            throw new ValidationException(4010, error);
        }
        if (policy.getMinLength() != null && policy.getMinLength() > 20) {
            String error = "validate policy name [" + policy.getName() + "] value minLength [" + policy.getMinLength() + "] INVALID INT VALUE";
            LOG.error(error);
            throw new ValidationException(4011, error);
        }
        if (policy.getFailureCountInterval() != null && policy.getFailureCountInterval() > 157680000) {
            String error = "validate policy name [" + policy.getName() + "] value failureCountInterval [" + policy.getFailureCountInterval() + "] INVALID INT VALUE";
            LOG.error(error);
            throw new ValidationException(4012, error);
        }
        if (policy.getMaxFailure() != null && policy.getMaxFailure() > 100) {
            String error = "validate policy name [" + policy.getName() + "] value maxFailure [" + policy.getMaxFailure() + "] INVALID INT VALUE";
            LOG.error(error);
            throw new ValidationException(4013, error);
        }
        if (policy.getInHistory() != null && policy.getInHistory() > 100) {
            String error = "validate policy name [" + policy.getName() + "] value inHistory [" + policy.getInHistory() + "] INVALID VALUE";
            LOG.error(error);
            throw new ValidationException(4017, error);
        }
        if (policy.getGraceLoginLimit() != null && policy.getGraceLoginLimit() > 10) {
            String error = "validate policy name [" + policy.getName() + "] value graceLoginLimit [" + policy.getGraceLoginLimit() + "] INVALID VALUE";
            LOG.error(error);
            throw new ValidationException(4018, error);
        }
        if (policy.getLockoutDuration() != null && policy.getLockoutDuration() > 157680000) {
            String error = "validate policy name [" + policy.getName() + "] value lockoutDuration [" + policy.getLockoutDuration() + "] INVALID VALUE";
            LOG.error(error);
            throw new ValidationException(4019, error);
        }
        if (policy.getExpireWarning() != null && policy.getExpireWarning() > 157680000L) {
            String error = "validate policy name [" + policy.getName() + "] value expireWarning [" + policy.getExpireWarning() + "] INVALID VALUE";
            LOG.error(error);
            throw new ValidationException(4020, error);
        }
    }

    private Set<String> loadPolicySet(String contextId) {
        Set<String> policySet = null;
        try {
            policySet = this.olDao.getPolicies(contextId);
        }
        catch (SecurityException se) {
            String warning = "loadPolicySet static initializer caught SecurityException=" + se;
            LOG.info(warning);
        }
        policyCache.put(PolicyP.getKey(contextId), policySet);
        return policySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getPolicySet(String contextId) {
        try {
            policySetLock.readLock().lock();
            Set<String> policySet = (Set<String>)policyCache.get(PolicyP.getKey(contextId));
            if (policySet == null) {
                policySet = this.loadPolicySet(contextId);
            }
            Set<String> set = policySet;
            return set;
        }
        finally {
            policySetLock.readLock().unlock();
        }
    }

    private static String getKey(String contextId) {
        Object key = POLICIES;
        if (StringUtils.isNotEmpty((String)contextId) && !contextId.equalsIgnoreCase("null")) {
            key = (String)key + ":" + contextId;
        }
        return key;
    }
}

