/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.Graphable;

@XmlRootElement(name="fortOrgUnit")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="orgUnit", propOrder={"children", "description", "id", "name", "parents", "type"})
public class OrgUnit
extends FortEntity
implements Graphable,
Serializable {
    private static final long serialVersionUID = 1L;
    public Type type;
    private String name;
    private String id;
    private String description;
    private Set<String> parents;
    private Set<String> children;

    public OrgUnit() {
    }

    public OrgUnit(String ou) {
        this.name = ou;
    }

    public OrgUnit(String ou, Type type) {
        this.name = ou;
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setId() {
        UUID uuid = UUID.randomUUID();
        this.id = uuid.toString();
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Set<String> getParents() {
        return this.parents;
    }

    @Override
    public void setParents(Set<String> parents) {
        this.parents = parents;
    }

    @Override
    public void setParent(String parent) {
        if (this.parents == null) {
            this.parents = new HashSet<String>();
        }
        this.parents.add(parent);
    }

    @Override
    public void delParent(String parent) {
        if (this.parents != null) {
            this.parents.remove(parent);
        }
    }

    public Set<String> getChildren() {
        return this.children;
    }

    public void setChildren(Set<String> children) {
        this.children = children;
    }

    public boolean equals(Object thatObj) {
        if (this == thatObj) {
            return true;
        }
        if (this.getName() == null) {
            return false;
        }
        if (!(thatObj instanceof OrgUnit)) {
            return false;
        }
        OrgUnit thatOrg = (OrgUnit)thatObj;
        if (thatOrg.getName() == null) {
            return false;
        }
        return thatOrg.getName().equalsIgnoreCase(this.getName());
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.parents != null ? this.parents.hashCode() : 0);
        result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
        return result;
    }

    public String toString() {
        boolean isFirst;
        StringBuilder sb = new StringBuilder();
        sb.append("OrgUnit object: \n");
        sb.append("    name : ").append(this.name).append('\n');
        sb.append("    id : ").append(this.id).append('\n');
        sb.append("    description : ").append(this.description).append('\n');
        sb.append("    type : ").append((Object)this.type).append('\n');
        if (this.parents != null) {
            sb.append("    parents : ");
            isFirst = true;
            for (String parent : this.parents) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(parent);
            }
            sb.append('\n');
        }
        if (this.children != null) {
            sb.append("    children : ");
            isFirst = true;
            for (String child : this.children) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(child);
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    @XmlType(name="type")
    @XmlEnum
    public static enum Type {
        USER,
        PERM;

    }
}

