/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.Props;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.core.util.PropUtil;

@XmlRootElement(name="fortGroup")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="group", propOrder={"name", "description", "protocol", "members", "props", "type", "roles"})
public class Group
extends FortEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    private String protocol;
    private List<String> members;
    private Props props = new Props();
    @XmlTransient
    private boolean memberDn;
    private Type type;
    @XmlElement(nillable=true)
    private List<UserRole> roles = new ArrayList<UserRole>();

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Group() {
        this.type = Type.USER;
    }

    public Group(Type type) {
        this.type = type;
    }

    public Group(String name) {
        this.name = name;
        this.type = Type.USER;
    }

    public Group(String name, Type type) {
        this.name = name;
        this.type = type;
    }

    public Group(String name, String description) {
        this.name = name;
        this.description = description;
        this.type = Type.USER;
    }

    public Group(String name, String description, Type type) {
        this.name = name;
        this.description = description;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setMember(String userId) {
        if (this.members == null) {
            this.members = new ArrayList<String>();
        }
        this.members.add(userId);
    }

    public List<String> getMembers() {
        return this.members;
    }

    public void setMembersWithCsv(String members) {
        StringTokenizer tkn;
        if (members != null && (tkn = new StringTokenizer(members, ",")).countTokens() > 0) {
            while (tkn.hasMoreTokens()) {
                String member = tkn.nextToken();
                this.setMember(member);
            }
        }
    }

    public void setMembers(List<String> members) {
        this.members = members;
    }

    public void addProperty(String key, String value) {
        Props.Entry entry = new Props.Entry();
        entry.setKey(key);
        entry.setValue(value);
        this.props.getEntry().add(entry);
    }

    public String getProperty(String key) {
        List<Props.Entry> props = this.props.getEntry();
        Props.Entry keyObj = new Props.Entry();
        keyObj.setKey(key);
        String value = null;
        int indx = props.indexOf(keyObj);
        if (indx != -1) {
            Props.Entry entry = props.get(props.indexOf(keyObj));
            value = entry.getValue();
        }
        return value;
    }

    public void setProperties(Properties properties) {
        if (properties != null) {
            this.props = new Props();
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = properties.getProperty(key);
                this.addProperty(key, val);
            }
        }
    }

    public void setPropertiesWithCsv(String properties) {
        this.setProperties(PropUtil.getProperties(properties, '=', ","));
    }

    public Properties getProperties() {
        Properties properties = null;
        List<Props.Entry> props = this.props.getEntry();
        if (props.size() > 0) {
            properties = new Properties();
            for (Props.Entry entry : props) {
                String key = entry.getKey();
                String val = entry.getValue();
                properties.setProperty(key, val);
            }
        }
        return properties;
    }

    public List<String> getPropList() {
        List<Props.Entry> props = this.props.getEntry();
        ArrayList<String> propList = null;
        if (props.size() > 0) {
            propList = new ArrayList<String>();
            for (Props.Entry entry : props) {
                String key = entry.getKey();
                String val = entry.getValue();
                String prop = key + "=" + val;
                propList.add(prop);
            }
        }
        return propList;
    }

    public Props getProps() {
        return this.props;
    }

    public void setProps(Props props) {
        this.props = props;
    }

    public boolean isMemberDn() {
        return this.memberDn;
    }

    public void setMemberDn(boolean memberDn) {
        this.memberDn = memberDn;
    }

    public List<UserRole> getRoles() {
        return this.roles;
    }

    public void setRoles(List<UserRole> roles) {
        this.roles = roles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Group group = (Group)o;
        if (this.name == null) {
            return false;
        }
        return this.name.equals(group.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
        result = 31 * result + (this.members != null ? this.members.hashCode() : 0);
        result = 31 * result + (this.props != null ? this.props.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Group{name='" + this.name + '\'' + ", description='" + this.description + '\'' + '}';
    }

    @XmlType(name="groupType")
    @XmlEnum
    public static enum Type {
        USER,
        ROLE;

    }
}

