/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.fortress.core.CreateException;
import org.apache.directory.fortress.core.FinderException;
import org.apache.directory.fortress.core.RemoveException;
import org.apache.directory.fortress.core.UpdateException;
import org.apache.directory.fortress.core.impl.RoleUtil;
import org.apache.directory.fortress.core.ldap.LdapDataProvider;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.ObjectFactory;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.SDSet;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.ldap.client.api.LdapConnection;

final class SdDAO
extends LdapDataProvider {
    private static final String SD_SET_NM = "ftSetName";
    private static final String ROLES = "ftRoles";
    private static final String SD_SET_CARDINALITY = "ftSetCardinality";
    private static final String SSD_OBJECT_CLASS_NM = "ftSSDSet";
    private static final String[] SSD_OBJ_CLASS = new String[]{"top", "ftSSDSet", "ftMods"};
    private static final String DSD_OBJECT_CLASS_NM = "ftDSDSet";
    private static final String[] DSD_OBJ_CLASS = new String[]{"top", "ftDSDSet", "ftMods"};
    private static final String[] SD_SET_ATRS = new String[]{"ftId", "ftSetName", "description", "ftRoles", "ftSetCardinality"};

    SdDAO() {
    }

    SDSet create(SDSet entity) throws CreateException {
        LdapConnection ld = null;
        String dn = this.getDn(entity.getName(), entity.getContextId());
        String[] objectClass = SSD_OBJ_CLASS;
        if (entity.getType() == SDSet.SDType.DYNAMIC) {
            objectClass = DSD_OBJ_CLASS;
        }
        try {
            DefaultEntry entry = new DefaultEntry(dn);
            entry.add(new Attribute[]{this.createAttributes("objectClass", objectClass)});
            entity.setId();
            entry.add("ftId", new String[]{entity.getId()});
            entry.add(SD_SET_NM, new String[]{entity.getName()});
            if (StringUtils.isNotEmpty((String)entity.getDescription())) {
                entry.add("description", new String[]{entity.getDescription()});
            }
            entry.add("cn", new String[]{entity.getName()});
            this.loadAttrs(entity.getMembers(), (Entry)entry, ROLES);
            entry.add(SD_SET_CARDINALITY, new String[]{"" + entity.getCardinality()});
            ld = this.getAdminConnection();
            this.add(ld, (Entry)entry, entity);
        }
        catch (LdapException e) {
            try {
                String error = "create SD set name [" + entity.getName() + "] type [" + (Object)((Object)entity.getType()) + "] caught LdapException=" + (Object)((Object)e);
                int errCode = entity.getType() == SDSet.SDType.DYNAMIC ? 5091 : 5082;
                throw new CreateException(errCode, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return entity;
    }

    SDSet update(SDSet entity) throws UpdateException {
        LdapConnection ld = null;
        String dn = this.getDn(entity.getName(), entity.getContextId());
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            if (StringUtils.isNotEmpty((String)entity.getDescription())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "description", new String[]{entity.getDescription()}));
            }
            if (entity.getCardinality() != null) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, SD_SET_CARDINALITY, new String[]{entity.getCardinality().toString()}));
            }
            this.loadAttrs(entity.getMembers(), mods, ROLES);
            if (mods.size() > 0) {
                ld = this.getAdminConnection();
                this.modify(ld, dn, mods, (FortEntity)entity);
            }
        }
        catch (LdapException e) {
            try {
                String error = "update name [" + entity.getName() + "] type [" + (Object)((Object)entity.getType()) + "] caught LdapException=" + (Object)((Object)e);
                int errCode = entity.getType() == SDSet.SDType.DYNAMIC ? 5092 : 5083;
                throw new UpdateException(errCode, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return entity;
    }

    SDSet remove(SDSet entity) throws RemoveException {
        LdapConnection ld = null;
        String dn = this.getDn(entity.getName(), entity.getContextId());
        try {
            ld = this.getAdminConnection();
            this.delete(ld, dn, (FortEntity)entity);
        }
        catch (LdapException e) {
            String error = "remove SD name=" + entity.getName() + " type [" + (Object)((Object)entity.getType()) + "] LdapException=" + (Object)((Object)e);
            int errCode = entity.getType() == SDSet.SDType.DYNAMIC ? 5093 : 5084;
            throw new RemoveException(errCode, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return entity;
    }

    SDSet getSD(SDSet sdSet) throws FinderException {
        SDSet entity = null;
        LdapConnection ld = null;
        String dn = this.getDn(sdSet.getName(), sdSet.getContextId());
        try {
            ld = this.getAdminConnection();
            Entry findEntry = this.read(ld, dn, SD_SET_ATRS);
            if (findEntry == null) {
                String warning = "getSD no entry found dn [" + dn + "]";
                throw new FinderException(5086, warning);
            }
            entity = this.unloadLdapEntry(findEntry, 0L);
        }
        catch (LdapNoSuchObjectException e) {
            String warning = "getSD Obj COULD NOT FIND ENTRY for dn [" + dn + "]";
            throw new FinderException(5086, warning);
        }
        catch (LdapException e) {
            String error = "getSSD dn [" + dn + "] LEXCD=" + (Object)((Object)e);
            int errCode = sdSet.getType() == SDSet.SDType.DYNAMIC ? 5090 : 5081;
            throw new FinderException(errCode, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return entity;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<SDSet> search(SDSet sdset) throws FinderException {
        ArrayList<SDSet> sdList = new ArrayList<SDSet>();
        LdapConnection ld = null;
        String ssdRoot = this.getSdRoot(sdset.getContextId());
        String objectClass = SSD_OBJECT_CLASS_NM;
        if (sdset.getType() == SDSet.SDType.DYNAMIC) {
            objectClass = DSD_OBJECT_CLASS_NM;
        }
        try {
            String searchVal = this.encodeSafeText(sdset.getName(), 40);
            String filter = "(&(objectClass=" + objectClass + ")(" + SD_SET_NM + "=" + searchVal + "*))";
            ld = this.getAdminConnection();
            SearchCursor searchResults = this.search(ld, ssdRoot, SearchScope.SUBTREE, filter, SD_SET_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));
            long sequence = 0L;
            while (searchResults.next()) {
                sdList.add(this.unloadLdapEntry(searchResults.getEntry(), sequence++));
            }
        }
        catch (LdapException e) {
            try {
                int errCode;
                String error = "search sdset name [" + sdset.getName() + "] type [" + (Object)((Object)sdset.getType()) + "] caught LdapException=" + (Object)((Object)e);
                if (sdset.getType() == SDSet.SDType.DYNAMIC) {
                    errCode = 5089;
                    throw new FinderException(errCode, error, (Exception)((Object)e));
                }
                errCode = 5080;
                throw new FinderException(errCode, error, (Exception)((Object)e));
                catch (CursorException e2) {
                    error = "search sdset name [" + sdset.getName() + "] type [" + (Object)((Object)sdset.getType()) + "] caught CursorException=" + e2.getMessage();
                    if (sdset.getType() == SDSet.SDType.DYNAMIC) {
                        errCode = 5089;
                        throw new FinderException(errCode, error, (Exception)((Object)e2));
                    }
                    errCode = 5080;
                    throw new FinderException(errCode, error, (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return sdList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<SDSet> search(Role role, SDSet.SDType type) throws FinderException {
        ArrayList<SDSet> sdList = new ArrayList<SDSet>();
        LdapConnection ld = null;
        String ssdRoot = this.getSdRoot(role.getContextId());
        String objectClass = SSD_OBJECT_CLASS_NM;
        if (type == SDSet.SDType.DYNAMIC) {
            objectClass = DSD_OBJECT_CLASS_NM;
        }
        try {
            String roleVal = this.encodeSafeText(role.getName(), 40);
            StringBuilder filterbuf = new StringBuilder();
            filterbuf.append("(&(objectClass=");
            filterbuf.append(objectClass);
            filterbuf.append(")(");
            Set<String> roles = RoleUtil.getInstance().getAscendants(role.getName(), role.getContextId());
            if (CollectionUtils.isNotEmpty(roles)) {
                filterbuf.append("|(");
                filterbuf.append(ROLES);
                filterbuf.append("=");
                filterbuf.append(roleVal);
                filterbuf.append(")");
                for (String uRole : roles) {
                    filterbuf.append("(");
                    filterbuf.append(ROLES);
                    filterbuf.append("=");
                    filterbuf.append(uRole);
                    filterbuf.append(")");
                }
                filterbuf.append(")");
            } else {
                filterbuf.append(ROLES);
                filterbuf.append("=");
                filterbuf.append(roleVal);
                filterbuf.append(")");
            }
            filterbuf.append(")");
            ld = this.getAdminConnection();
            SearchCursor searchResults = this.search(ld, ssdRoot, SearchScope.SUBTREE, filterbuf.toString(), SD_SET_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));
            long sequence = 0L;
            while (searchResults.next()) {
                sdList.add(this.unloadLdapEntry(searchResults.getEntry(), sequence++));
            }
        }
        catch (LdapException e) {
            try {
                int errCode;
                String error = "search role [" + role.getName() + "] type [" + (Object)((Object)type) + "] caught LdapException=" + (Object)((Object)e);
                if (type == SDSet.SDType.DYNAMIC) {
                    errCode = 5089;
                    throw new FinderException(errCode, error, (Exception)((Object)e));
                }
                errCode = 5080;
                throw new FinderException(errCode, error, (Exception)((Object)e));
                catch (CursorException e2) {
                    error = "search role [" + role.getName() + "] type [" + (Object)((Object)type) + "] caught CursorException=" + e2.getMessage();
                    if (type == SDSet.SDType.DYNAMIC) {
                        errCode = 5089;
                        throw new FinderException(errCode, error, (Exception)((Object)e2));
                    }
                    errCode = 5080;
                    throw new FinderException(errCode, error, (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return sdList;
    }

    Set<SDSet> search(Set<String> roles, SDSet sdSet) throws FinderException {
        HashSet<SDSet> sdList = new HashSet<SDSet>();
        LdapConnection ld = null;
        String ssdRoot = this.getSdRoot(sdSet.getContextId());
        String objectClass = SSD_OBJECT_CLASS_NM;
        if (sdSet.getType() == SDSet.SDType.DYNAMIC) {
            objectClass = DSD_OBJECT_CLASS_NM;
        }
        try {
            if (CollectionUtils.isNotEmpty(roles)) {
                StringBuilder filterbuf = new StringBuilder();
                filterbuf.append("(&(objectClass=");
                filterbuf.append(objectClass);
                filterbuf.append(")(|");
                for (String rle : roles) {
                    filterbuf.append("(");
                    filterbuf.append(ROLES);
                    filterbuf.append("=");
                    filterbuf.append(rle);
                    filterbuf.append(")");
                }
                filterbuf.append("))");
                ld = this.getAdminConnection();
                SearchCursor searchResults = this.search(ld, ssdRoot, SearchScope.SUBTREE, filterbuf.toString(), SD_SET_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));
                long sequence = 0L;
                while (searchResults.next()) {
                    sdList.add(this.unloadLdapEntry(searchResults.getEntry(), sequence++));
                }
            }
        }
        catch (LdapException e) {
            String error = "search type [" + (Object)((Object)sdSet.getType()) + "] caught LdapException=" + (Object)((Object)e);
            int errCode = sdSet.getType() == SDSet.SDType.DYNAMIC ? 5089 : 5080;
            throw new FinderException(errCode, error, (Exception)((Object)e));
        }
        catch (CursorException e) {
            String error = "search type [" + (Object)((Object)sdSet.getType()) + "] caught CursorException=" + e.getMessage();
            int errCode = sdSet.getType() == SDSet.SDType.DYNAMIC ? 5089 : 5080;
            throw new FinderException(errCode, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return sdList;
    }

    private SDSet unloadLdapEntry(Entry le, long sequence) throws LdapInvalidAttributeValueException {
        SDSet entity = new ObjectFactory().createSDset();
        entity.setSequenceId(sequence);
        entity.setId(this.getAttribute(le, "ftId"));
        entity.setName(this.getAttribute(le, SD_SET_NM));
        entity.setDescription(this.getAttribute(le, "description"));
        entity.setMembers(this.getAttributeSet(le, ROLES));
        String szCard = this.getAttribute(le, SD_SET_CARDINALITY);
        entity.setCardinality(Integer.valueOf(szCard));
        return entity;
    }

    private String getDn(String name, String contextId) {
        return "cn=" + name + "," + this.getSdRoot(contextId);
    }

    private String getSdRoot(String contextId) {
        return SdDAO.getRootDn(contextId, "sdconstraint.root");
    }
}

