/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.fortress.core.FinderException;
import org.apache.directory.fortress.core.UpdateException;
import org.apache.directory.fortress.core.impl.PropertyProvider;
import org.apache.directory.fortress.core.ldap.LdapDataProvider;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.util.PropUtil;
import org.apache.directory.ldap.client.api.LdapConnection;

final class PropertyDAO
extends LdapDataProvider {
    PropertyDAO() {
    }

    FortEntity addProperties(FortEntity entity, Properties properties, PropertyProvider propProvider) throws UpdateException, FinderException {
        LdapConnection ld = null;
        String entityDn = propProvider.getDn(entity);
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            this.loadProperties(properties, mods, "ftProps", false);
            ld = this.getAdminConnection();
            this.modify(ld, entityDn, mods, entity);
        }
        catch (LdapException e) {
            try {
                String error = "add entity properties[" + entity.getClass().getSimpleName() + "] caught LDAPException=" + (Object)((Object)e);
                throw new UpdateException(1003, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return propProvider.getEntity(entity);
    }

    FortEntity updateProperties(FortEntity entity, Properties properties, PropertyProvider propProvider) throws UpdateException, FinderException {
        Properties currentProps = this.getProperties(entity, propProvider);
        Properties toDeleteProps = new Properties();
        for (Object key : properties.keySet()) {
            String value = currentProps.getProperty((String)key);
            toDeleteProps.put((String)key, value);
        }
        this.deleteProperties(entity, toDeleteProps, propProvider);
        this.addProperties(entity, properties, propProvider);
        return propProvider.getEntity(entity);
    }

    void deleteProperties(FortEntity entity, Properties properties, PropertyProvider propProvider) throws UpdateException, FinderException {
        LdapConnection ld = null;
        String entityDn = propProvider.getDn(entity);
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            this.removeProperties(properties, mods, "ftProps");
            ld = this.getAdminConnection();
            this.modify(ld, entityDn, mods, entity);
        }
        catch (LdapException e) {
            try {
                String error = "delete entity properties[" + entity.getClass().getSimpleName() + "] caught LDAPException=" + (Object)((Object)e);
                throw new UpdateException(1003, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
    }

    Properties getProperties(FortEntity entity, PropertyProvider propProvider) throws FinderException {
        Properties props = null;
        LdapConnection ld = null;
        String entityDn = propProvider.getDn(entity);
        try {
            ld = this.getAdminConnection();
            Entry findEntry = this.read(ld, entityDn, new String[]{"ftProps"});
            props = PropUtil.getProperties(this.getAttributes(findEntry, "ftProps"));
            if (props == null) {
                props = new Properties();
            }
        }
        catch (LdapNoSuchObjectException e) {
            String warning = "get properties COULD NOT FIND ENTRY for entity [" + entityDn + "]";
            throw new FinderException(10502, warning);
        }
        catch (LdapException e) {
            String error = "get properties [" + entityDn + "]= caught LDAPException=" + (Object)((Object)e);
            throw new FinderException(10503, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return props;
    }
}

