/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.fortress.core.CreateException;
import org.apache.directory.fortress.core.FinderException;
import org.apache.directory.fortress.core.RemoveException;
import org.apache.directory.fortress.core.UpdateException;
import org.apache.directory.fortress.core.impl.PropertyProvider;
import org.apache.directory.fortress.core.ldap.LdapDataProvider;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.Group;
import org.apache.directory.fortress.core.model.ObjectFactory;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.PropUtil;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GroupDAO
extends LdapDataProvider
implements PropertyProvider<Group> {
    private static final String CLS_NM = GroupDAO.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);
    private static final String GROUP_OBJECT_CLASS = "group.objectclass";
    private String GROUP_OBJECT_CLASS_IMPL = Config.getInstance().getProperty("group.objectclass");
    private static final String GROUP_PROTOCOL_ATTR = "group.protocol";
    private String GROUP_PROTOCOL_ATTR_IMPL = Config.getInstance().getProperty("group.protocol");
    private static final String GROUP_PROPERTY_ATTR = "group.properties";
    private String GROUP_PROPERTY_ATTR_IMPL = Config.getInstance().getProperty("group.properties");
    private String[] GROUP_OBJ_CLASS = new String[]{"top", this.GROUP_OBJECT_CLASS_IMPL};
    private String[] GROUP_ATRS = new String[]{"cn", "description", "ftType", this.GROUP_PROTOCOL_ATTR_IMPL, this.GROUP_PROPERTY_ATTR_IMPL, "member"};

    GroupDAO() {
    }

    Group create(Group group) throws CreateException {
        LdapConnection ld = null;
        String nodeDn = this.getDn(group.getName(), group.getContextId());
        try {
            LOG.debug("create group dn [{}]", (Object)nodeDn);
            DefaultEntry myEntry = new DefaultEntry(nodeDn);
            myEntry.add("objectClass", this.GROUP_OBJ_CLASS);
            myEntry.add("cn", new String[]{group.getName()});
            myEntry.add(this.GROUP_PROTOCOL_ATTR_IMPL, new String[]{group.getProtocol()});
            myEntry.add("ftType", new String[]{group.getType().toString()});
            this.loadAttrs(group.getMembers(), (Entry)myEntry, "member");
            this.loadProperties(group.getProperties(), (Entry)myEntry, this.GROUP_PROPERTY_ATTR_IMPL, '=');
            if (StringUtils.isNotEmpty((String)group.getDescription())) {
                myEntry.add("description", new String[]{group.getDescription()});
            }
            ld = this.getAdminConnection();
            this.add(ld, (Entry)myEntry);
        }
        catch (LdapException e) {
            try {
                String error = "create group node dn [" + nodeDn + "] caught LDAPException=" + (Object)((Object)e);
                throw new CreateException(10302, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return group;
    }

    Group update(Group group) throws FinderException, UpdateException {
        LdapConnection ld = null;
        String nodeDn = this.getDn(group.getName(), group.getContextId());
        try {
            LOG.debug("update group dn [{}]", (Object)nodeDn);
            ArrayList<Modification> mods = new ArrayList<Modification>();
            if (StringUtils.isNotEmpty((String)group.getDescription())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "description", new String[]{group.getDescription()}));
            }
            if (StringUtils.isNotEmpty((String)group.getProtocol())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, this.GROUP_PROTOCOL_ATTR_IMPL, new String[]{group.getProtocol()}));
            }
            this.loadAttrs(group.getMembers(), mods, "member");
            this.loadProperties(group.getProperties(), mods, this.GROUP_PROPERTY_ATTR_IMPL, true, '=');
            if (mods.size() > 0) {
                ld = this.getAdminConnection();
                this.modify(ld, nodeDn, mods, (FortEntity)group);
            }
        }
        catch (LdapException e) {
            try {
                String error = "update group node dn [" + nodeDn + "] caught LDAPException=" + (Object)((Object)e);
                throw new UpdateException(10303, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return this.get(group);
    }

    Group add(Group group, String key, String value) throws FinderException, CreateException {
        LdapConnection ld = null;
        String nodeDn = this.getDn(group.getName(), group.getContextId());
        try {
            LOG.debug("add group property dn [{}], key [{}], value [{}]", new Object[]{nodeDn, key, value});
            ArrayList<Modification> mods = new ArrayList<Modification>();
            mods.add((Modification)new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, this.GROUP_PROPERTY_ATTR_IMPL, new String[]{key + "=" + value}));
            ld = this.getAdminConnection();
            this.modify(ld, nodeDn, mods, (FortEntity)group);
        }
        catch (LdapException e) {
            try {
                String error = "update group property node dn [" + nodeDn + "] caught LDAPException=" + (Object)((Object)e);
                throw new CreateException(10305, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return this.get(group);
    }

    Group delete(Group group, String key, String value) throws FinderException, RemoveException {
        LdapConnection ld = null;
        String nodeDn = this.getDn(group.getName(), group.getContextId());
        try {
            LOG.debug("delete group property dn [{}], key [{}], value [{}]", new Object[]{nodeDn, key, value});
            ArrayList<Modification> mods = new ArrayList<Modification>();
            mods.add((Modification)new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, this.GROUP_PROPERTY_ATTR_IMPL, new String[]{key + "=" + value}));
            ld = this.getAdminConnection();
            this.modify(ld, nodeDn, mods, (FortEntity)group);
        }
        catch (LdapException e) {
            try {
                String error = "delete group property node dn [" + nodeDn + "] caught LDAPException=" + (Object)((Object)e);
                throw new RemoveException(10306, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return this.get(group);
    }

    Group remove(Group group) throws RemoveException {
        LdapConnection ld = null;
        String nodeDn = this.getDn(group.getName(), group.getContextId());
        LOG.debug("remove group dn [{}]", (Object)nodeDn);
        try {
            ld = this.getAdminConnection();
            this.delete(ld, nodeDn, (FortEntity)group);
        }
        catch (LdapException e) {
            String error = "remove group node dn [" + nodeDn + "] caught LDAPException=" + (Object)((Object)e);
            throw new RemoveException(10304, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return group;
    }

    Group assign(Group entity, String userDn) throws FinderException, UpdateException {
        LdapConnection ld = null;
        String dn = this.getDn(entity.getName(), entity.getContextId());
        LOG.debug("assign group property dn [{}], member dn [{}]", (Object)dn, (Object)userDn);
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            mods.add((Modification)new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, "member", new String[]{userDn}));
            ld = this.getAdminConnection();
            this.modify(ld, dn, mods, (FortEntity)entity);
        }
        catch (LdapException e) {
            try {
                String error = "assign group name [" + entity.getName() + "] user dn [" + userDn + "] caught LDAPException=" + (Object)((Object)e);
                throw new UpdateException(10309, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return this.get(entity);
    }

    Group deassign(Group entity, String userDn) throws FinderException, UpdateException {
        LdapConnection ld = null;
        String dn = this.getDn(entity.getName(), entity.getContextId());
        LOG.debug("deassign group property dn [{}], member dn [{}]", (Object)dn, (Object)userDn);
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            mods.add((Modification)new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, "member", new String[]{userDn}));
            ld = this.getAdminConnection();
            this.modify(ld, dn, mods, (FortEntity)entity);
        }
        catch (LdapException e) {
            try {
                String error = "deassign group name [" + entity.getName() + "] user dn [" + userDn + "] caught LDAPException=" + (Object)((Object)e);
                throw new UpdateException(10310, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return this.get(entity);
    }

    Group get(Group group) throws FinderException {
        Group entity = null;
        LdapConnection ld = null;
        String dn = this.getDn(group.getName(), group.getContextId());
        try {
            ld = this.getAdminConnection();
            Entry findEntry = this.read(ld, dn, this.GROUP_ATRS);
            if (findEntry == null) {
                String warning = "No Group entry found dn [" + dn + "]";
                throw new FinderException(10307, warning);
            }
            entity = this.unloadLdapEntry(findEntry, 0L);
        }
        catch (LdapNoSuchObjectException e) {
            String warning = "read Obj COULD NOT FIND ENTRY for dn [" + dn + "]";
            throw new FinderException(10307, warning, (Exception)((Object)e));
        }
        catch (LdapException e) {
            String error = "read dn [" + dn + "] LdapException=" + (Object)((Object)e);
            throw new FinderException(10301, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return entity;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<Group> find(Group group) throws FinderException {
        ArrayList<Group> groupList = new ArrayList<Group>();
        LdapConnection ld = null;
        String groupRoot = GroupDAO.getRootDn(group.getContextId(), "group.root");
        String filter = null;
        try {
            String searchVal = this.encodeSafeText(group.getName(), 40);
            filter = "(&(objectClass=" + this.GROUP_OBJECT_CLASS_IMPL + ")(" + "cn" + "=" + searchVal + "*))";
            ld = this.getAdminConnection();
            SearchCursor searchResults = this.search(ld, groupRoot, SearchScope.ONELEVEL, filter, this.GROUP_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));
            long sequence = 0L;
            while (searchResults.next()) {
                groupList.add(this.unloadLdapEntry(searchResults.getEntry(), sequence++));
            }
        }
        catch (CursorException e) {
            try {
                String error = "find filter [" + filter + "] caught CursorException=" + e.getMessage();
                throw new FinderException(10300, error, (Exception)((Object)e));
                catch (LdapException e2) {
                    error = "find filter [" + filter + "] caught LDAPException=" + (Object)((Object)e2);
                    throw new FinderException(10300, error, (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return groupList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<Group> find(User user) throws FinderException {
        ArrayList<Group> groupList = new ArrayList<Group>();
        LdapConnection ld = null;
        String groupRoot = GroupDAO.getRootDn(user.getContextId(), "group.root");
        String filter = null;
        try {
            this.encodeSafeText(user.getUserId(), 40);
            filter = "(&(objectClass=" + this.GROUP_OBJECT_CLASS_IMPL + ")(" + "member" + "=" + user.getDn() + "))";
            ld = this.getAdminConnection();
            SearchCursor searchResults = this.search(ld, groupRoot, SearchScope.ONELEVEL, filter, this.GROUP_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));
            long sequence = 0L;
            while (searchResults.next()) {
                groupList.add(this.unloadLdapEntry(searchResults.getEntry(), sequence++));
            }
        }
        catch (CursorException e) {
            try {
                String error = "find filter [" + filter + "] caught CursorException=" + e.getMessage();
                throw new FinderException(10300, error, (Exception)((Object)e));
                catch (LdapException e2) {
                    error = "find filter [" + filter + "] caught LDAPException=" + (Object)((Object)e2);
                    throw new FinderException(10300, error, (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return groupList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<Group> roleGroups(Role role) throws FinderException {
        ArrayList<Group> groupList = new ArrayList<Group>();
        LdapConnection ld = null;
        String groupRoot = GroupDAO.getRootDn(role.getContextId(), "group.root");
        String filter = null;
        try {
            this.encodeSafeText(role.getName(), 40);
            filter = "(&(objectClass=" + this.GROUP_OBJECT_CLASS_IMPL + ")(" + "member" + "=" + role.getDn() + "))";
            ld = this.getAdminConnection();
            SearchCursor searchResults = this.search(ld, groupRoot, SearchScope.ONELEVEL, filter, this.GROUP_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));
            long sequence = 0L;
            while (searchResults.next()) {
                groupList.add(this.unloadLdapEntry(searchResults.getEntry(), sequence++));
            }
        }
        catch (CursorException e) {
            try {
                String error = "find filter [" + filter + "] caught CursorException=" + e.getMessage();
                throw new FinderException(10300, error, (Exception)((Object)e));
                catch (LdapException e2) {
                    error = "find filter [" + filter + "] caught LDAPException=" + (Object)((Object)e2);
                    throw new FinderException(10300, error, (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return groupList;
    }

    private Group unloadLdapEntry(Entry le, long sequence) throws LdapInvalidAttributeValueException {
        Group entity = new ObjectFactory().createGroup();
        entity.setName(this.getAttribute(le, "cn"));
        entity.setDescription(this.getAttribute(le, "description"));
        String typeAsString = this.getAttribute(le, "ftType");
        if (StringUtils.isNotEmpty((String)typeAsString)) {
            entity.setType(Group.Type.valueOf(typeAsString.toUpperCase()));
        }
        entity.setProtocol(this.getAttribute(le, this.GROUP_PROTOCOL_ATTR_IMPL));
        entity.setMembers(this.getAttributes(le, "member"));
        entity.setMemberDn(true);
        entity.setProperties(PropUtil.getProperties(this.getAttributes(le, this.GROUP_PROPERTY_ATTR_IMPL), '='));
        entity.setSequenceId(sequence);
        return entity;
    }

    private String getDn(String name, String contextId) {
        return "cn=" + name + "," + GroupDAO.getRootDn(contextId, "group.root");
    }

    @Override
    public String getDn(Group entity) {
        return this.getDn(entity.getName(), entity.getContextId());
    }

    @Override
    public FortEntity getEntity(Group entity) throws FinderException {
        return this.get(entity);
    }
}

