/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.rest;

import java.util.Properties;
import org.apache.directory.fortress.core.ConfigMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.Configuration;
import org.apache.directory.fortress.core.model.FortRequest;
import org.apache.directory.fortress.core.model.FortResponse;
import org.apache.directory.fortress.core.model.Props;
import org.apache.directory.fortress.core.rest.RestUtils;
import org.apache.directory.fortress.core.util.VUtil;

public class ConfigMgrRestImpl
implements ConfigMgr {
    private static final String CLS_NM = ConfigMgrRestImpl.class.getName();

    @Override
    public Configuration add(Configuration cfg) throws SecurityException {
        VUtil.assertNotNull(cfg, 111, CLS_NM + ".add");
        FortRequest request = RestUtils.getRequest("HOME");
        request.setEntity(cfg);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "cfgAdd");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Configuration retCfg = (Configuration)response.getEntity();
        return retCfg;
    }

    @Override
    public Configuration update(Configuration cfg) throws SecurityException {
        VUtil.assertNotNull(cfg, 111, CLS_NM + ".update");
        FortRequest request = RestUtils.getRequest("HOME");
        request.setEntity(cfg);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "cfgUpdate");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Configuration retCfg = (Configuration)response.getEntity();
        return retCfg;
    }

    @Override
    public void updateProperty(String name, String key, String value, String newValue) throws SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(String name) throws SecurityException {
        VUtil.assertNotNull(name, 108, CLS_NM + ".deleteProp");
        FortRequest request = new FortRequest();
        request.setValue(name);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "cfgDelete");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public void delete(String name, Properties inProperties) throws SecurityException {
        VUtil.assertNotNull(name, 108, CLS_NM + ".delete");
        VUtil.assertNotNull(inProperties, 110, CLS_NM + ".delete");
        FortRequest request = new FortRequest();
        Props inProps = RestUtils.getProps(inProperties);
        request.setEntity(inProps);
        request.setValue(name);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "cfgDelete");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    @Override
    public Configuration read(String name) throws SecurityException {
        VUtil.assertNotNull(name, 108, CLS_NM + ".readRole");
        FortRequest request = new FortRequest();
        request.setValue(name);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "cfgRead");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Configuration retCfg = (Configuration)response.getEntity();
        return retCfg;
    }

    @Override
    public Configuration getIds(String name) throws SecurityException {
        throw new UnsupportedOperationException("not implemented");
    }
}

