/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.fortress.core.model.Constraint;
import org.apache.directory.fortress.core.model.ConstraintUtil;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.ParentUtil;
import org.apache.directory.fortress.core.model.RoleConstraint;
import org.apache.directory.fortress.core.model.UserAdminRole;
import org.apache.directory.fortress.core.util.Config;

@XmlRootElement(name="fortUserRole")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="userRole", propOrder={"name", "userId", "isGroupRole", "parents", "beginDate", "beginLockDate", "beginTime", "dayMask", "endDate", "endLockDate", "endTime", "timeout", "roleConstraints"})
@XmlSeeAlso(value={UserAdminRole.class})
public class UserRole
extends FortEntity
implements Serializable,
Constraint {
    private static final long serialVersionUID = 1L;
    protected String userId;
    protected String name;
    protected boolean isGroupRole;
    private Integer timeout;
    private String beginTime;
    private String endTime;
    private String beginDate;
    private String endDate;
    private String beginLockDate;
    private String endLockDate;
    private String dayMask;
    private Set<String> parents;
    private List<RoleConstraint> roleConstraints;

    public UserRole() {
    }

    public UserRole(String userId, String role) {
        this.userId = userId;
        this.name = role;
        this.isGroupRole = false;
    }

    public UserRole(String userId, String name, boolean isGroupRole) {
        this.userId = userId;
        this.name = name;
        this.isGroupRole = isGroupRole;
    }

    public UserRole(String userId, Constraint con) {
        this.userId = userId;
        this.isGroupRole = false;
        ConstraintUtil.copy(con, this);
    }

    public UserRole(String role) {
        this.name = role;
    }

    public void load(String szRawData, String contextId, ParentUtil parentUtil) {
        if (szRawData != null && szRawData.length() > 0) {
            String[] tokens = StringUtils.splitPreserveAllTokens((String)szRawData, (String)Config.getInstance().getDelimiter());
            if (tokens[1].equals("type")) {
                RoleConstraint rc = new RoleConstraint(tokens[5], tokens[4], RoleConstraint.RCType.valueOf(tokens[2]), tokens[3]);
                this.getRoleConstraints().add(rc);
            } else {
                block11: for (int i = 0; i < tokens.length; ++i) {
                    if (!StringUtils.isNotEmpty((String)tokens[i])) continue;
                    switch (i) {
                        case 0: {
                            this.name = tokens[i];
                            this.parents = parentUtil.getParentsCB(this.name.toUpperCase(), contextId);
                            continue block11;
                        }
                        case 1: {
                            this.timeout = Integer.parseInt(tokens[i]);
                            continue block11;
                        }
                        case 2: {
                            this.beginTime = tokens[i];
                            continue block11;
                        }
                        case 3: {
                            this.endTime = tokens[i];
                            continue block11;
                        }
                        case 4: {
                            this.beginDate = tokens[i];
                            continue block11;
                        }
                        case 5: {
                            this.endDate = tokens[i];
                            continue block11;
                        }
                        case 6: {
                            this.beginLockDate = tokens[i];
                            continue block11;
                        }
                        case 7: {
                            this.endLockDate = tokens[i];
                            continue block11;
                        }
                        case 8: {
                            this.dayMask = tokens[i];
                        }
                    }
                }
            }
        }
    }

    @Override
    public String getRawData() {
        String delimeter = Config.getInstance().getDelimiter();
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append(delimeter);
        sb.append(this.timeout);
        sb.append(delimeter);
        if (this.beginTime != null) {
            sb.append(this.beginTime);
        }
        sb.append(delimeter);
        if (this.endTime != null) {
            sb.append(this.endTime);
        }
        sb.append(delimeter);
        if (this.beginDate != null) {
            sb.append(this.beginDate);
        }
        sb.append(delimeter);
        if (this.endDate != null) {
            sb.append(this.endDate);
        }
        sb.append(delimeter);
        if (this.beginLockDate != null) {
            sb.append(this.beginLockDate);
        }
        sb.append(delimeter);
        if (this.endLockDate != null) {
            sb.append(this.endLockDate);
        }
        sb.append(delimeter);
        if (this.dayMask != null) {
            sb.append(this.dayMask);
        }
        return sb.toString();
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isTemporalSet() {
        return this.beginTime != null || this.endTime != null || this.beginDate != null || this.endDate != null || this.beginLockDate != null || this.endLockDate != null || this.dayMask != null;
    }

    @Override
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    @Override
    public void setBeginTime(String beginTime) {
        this.beginTime = beginTime;
    }

    @Override
    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    @Override
    public void setBeginDate(String beginDate) {
        this.beginDate = beginDate;
    }

    @Override
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    @Override
    public void setDayMask(String dayMask) {
        this.dayMask = dayMask;
    }

    @Override
    public void setBeginLockDate(String beginLockDate) {
        this.beginLockDate = beginLockDate;
    }

    @Override
    public void setEndLockDate(String endLockDate) {
        this.endLockDate = endLockDate;
    }

    @Override
    public Integer getTimeout() {
        return this.timeout;
    }

    @Override
    public String getBeginTime() {
        return this.beginTime;
    }

    @Override
    public String getEndTime() {
        return this.endTime;
    }

    @Override
    public String getBeginDate() {
        return this.beginDate;
    }

    @Override
    public String getEndDate() {
        return this.endDate;
    }

    @Override
    public String getBeginLockDate() {
        return this.beginLockDate;
    }

    @Override
    public String getEndLockDate() {
        return this.endLockDate;
    }

    @Override
    public String getDayMask() {
        return this.dayMask;
    }

    @Override
    public List<RoleConstraint> getConstraints() {
        return this.getRoleConstraints();
    }

    public Set<String> getParents() {
        return this.parents;
    }

    public void setParents(Set<String> parents) {
        this.parents = parents;
    }

    public boolean isGroupRole() {
        return this.isGroupRole;
    }

    public void setGroupRole(boolean groupRole) {
        this.isGroupRole = groupRole;
    }

    public boolean equals(Object thatObj) {
        if (this == thatObj) {
            return true;
        }
        if (this.name == null) {
            return false;
        }
        if (!(thatObj instanceof UserRole)) {
            return false;
        }
        UserRole thatRole = (UserRole)thatObj;
        if (thatRole.getName() == null) {
            return false;
        }
        return thatRole.getName().equalsIgnoreCase(this.name);
    }

    public int hashCode() {
        int result = this.userId != null ? this.userId.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
        result = 31 * result + (this.beginTime != null ? this.beginTime.hashCode() : 0);
        result = 31 * result + (this.endTime != null ? this.endTime.hashCode() : 0);
        result = 31 * result + (this.beginDate != null ? this.beginDate.hashCode() : 0);
        result = 31 * result + (this.endDate != null ? this.endDate.hashCode() : 0);
        result = 31 * result + (this.beginLockDate != null ? this.beginLockDate.hashCode() : 0);
        result = 31 * result + (this.endLockDate != null ? this.endLockDate.hashCode() : 0);
        result = 31 * result + (this.dayMask != null ? this.dayMask.hashCode() : 0);
        result = 31 * result + (this.parents != null ? this.parents.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.name;
    }

    public List<RoleConstraint> getRoleConstraints() {
        if (this.roleConstraints == null) {
            this.roleConstraints = new ArrayList<RoleConstraint>();
        }
        return this.roleConstraints;
    }

    public void setRoleConstraints(List<RoleConstraint> roleConstraints) {
        this.roleConstraints = roleConstraints;
    }
}

