/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.directory.fortress.core.model.AdminRole;
import org.apache.directory.fortress.core.model.Constraint;
import org.apache.directory.fortress.core.model.ConstraintUtil;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.Graphable;
import org.apache.directory.fortress.core.model.Props;
import org.apache.directory.fortress.core.model.RoleConstraint;

@XmlRootElement(name="fortRole")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="role", propOrder={"name", "id", "description", "parents", "children", "beginDate", "beginLockDate", "beginTime", "dayMask", "endDate", "endLockDate", "endTime", "timeout", "dn", "gidNumber", "props"})
@XmlSeeAlso(value={AdminRole.class})
public class Role
extends FortEntity
implements Constraint,
Graphable,
Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String description;
    private String dn;
    @XmlTransient
    private List<String> occupants;
    private Set<String> parents;
    private Set<String> children;
    private String beginTime;
    private String endTime;
    private String beginDate;
    private String endDate;
    private String beginLockDate;
    private String endLockDate;
    private String dayMask;
    private String gidNumber;
    private int timeout;
    private Props props = new Props();
    private transient String rawData;

    public Role() {
    }

    public Role(String name) {
        this.name = name;
    }

    public Role(Constraint con) {
        ConstraintUtil.copy(con, this);
    }

    @Override
    public String getRawData() {
        return this.rawData;
    }

    public void setRawData(String rawData) {
        this.rawData = rawData;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setOccupant(String occupant) {
        if (this.occupants == null) {
            this.occupants = new ArrayList<String>();
        }
        this.occupants.add(occupant);
    }

    public List<String> getOccupants() {
        return this.occupants;
    }

    public void setOccupants(List<String> occupants) {
        this.occupants = occupants;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public void setId() {
        UUID uuid = UUID.randomUUID();
        this.id = uuid.toString();
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public boolean isTemporalSet() {
        return this.beginTime != null || this.endTime != null || this.beginDate != null || this.endDate != null || this.beginLockDate != null || this.endLockDate != null || this.dayMask != null;
    }

    @Override
    public String getBeginTime() {
        return this.beginTime;
    }

    @Override
    public void setBeginTime(String beginTime) {
        this.beginTime = beginTime;
    }

    @Override
    public String getEndTime() {
        return this.endTime;
    }

    @Override
    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    @Override
    public String getBeginDate() {
        return this.beginDate;
    }

    @Override
    public void setBeginDate(String beginDate) {
        this.beginDate = beginDate;
    }

    @Override
    public String getEndDate() {
        return this.endDate;
    }

    @Override
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    @Override
    public String getBeginLockDate() {
        return this.beginLockDate;
    }

    @Override
    public void setBeginLockDate(String beginLockDate) {
        this.beginLockDate = beginLockDate;
    }

    @Override
    public String getEndLockDate() {
        return this.endLockDate;
    }

    @Override
    public void setEndLockDate(String endLockDate) {
        this.endLockDate = endLockDate;
    }

    @Override
    public String getDayMask() {
        return this.dayMask;
    }

    @Override
    public void setDayMask(String dayMask) {
        this.dayMask = dayMask;
    }

    @Override
    public Integer getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    @Override
    public List<RoleConstraint> getConstraints() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getParents() {
        if (this.parents == null) {
            this.parents = new HashSet<String>();
        }
        return this.parents;
    }

    @Override
    public void setParents(Set<String> parents) {
        this.parents = parents;
    }

    @Override
    public void setParent(String parent) {
        if (this.parents == null) {
            this.parents = new HashSet<String>();
        }
        this.parents.add(parent);
    }

    @Override
    public void delParent(String parent) {
        if (this.parents != null) {
            this.parents.remove(parent);
        }
    }

    public Set<String> getChildren() {
        return this.children;
    }

    public void setChildren(Set<String> children) {
        this.children = children;
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getGidNumber() {
        return this.gidNumber;
    }

    public void setGidNumber(String gidNumber) {
        this.gidNumber = gidNumber;
    }

    public boolean equals(Object thatObj) {
        if (this == thatObj) {
            return true;
        }
        if (this.name == null) {
            return false;
        }
        if (!(thatObj instanceof Role)) {
            return false;
        }
        Role thatRole = (Role)thatObj;
        if (thatRole.getName() == null) {
            return false;
        }
        return thatRole.getName().equalsIgnoreCase(this.name);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.dn != null ? this.dn.hashCode() : 0);
        result = 31 * result + (this.occupants != null ? this.occupants.hashCode() : 0);
        result = 31 * result + (this.parents != null ? this.parents.hashCode() : 0);
        result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
        result = 31 * result + (this.beginTime != null ? this.beginTime.hashCode() : 0);
        result = 31 * result + (this.endTime != null ? this.endTime.hashCode() : 0);
        result = 31 * result + (this.beginDate != null ? this.beginDate.hashCode() : 0);
        result = 31 * result + (this.endDate != null ? this.endDate.hashCode() : 0);
        result = 31 * result + (this.beginLockDate != null ? this.beginLockDate.hashCode() : 0);
        result = 31 * result + (this.endLockDate != null ? this.endLockDate.hashCode() : 0);
        result = 31 * result + (this.dayMask != null ? this.dayMask.hashCode() : 0);
        result = 31 * result + this.timeout;
        result = 31 * result + (this.rawData != null ? this.rawData.hashCode() : 0);
        return result;
    }

    protected String toString(String tabs) {
        boolean isFirst;
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("Role[");
        sb.append(this.name).append(", ");
        if (this.description != null && this.description.length() > 0) {
            sb.append(this.description).append(", ");
        }
        sb.append("date : <").append(this.beginDate).append(", ").append(this.endDate).append(">, ");
        sb.append("time : <").append(this.beginTime).append(", ").append(this.endTime).append(">, ");
        sb.append("lock date : <").append(this.beginLockDate).append(", ").append(this.endLockDate).append(">, ");
        sb.append("timeout : ").append(this.timeout).append(", ");
        sb.append("daymask : ").append(this.dayMask);
        if (this.parents != null && this.parents.size() > 0) {
            sb.append(", parents : {");
            isFirst = true;
            for (String parent : this.parents) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append('|');
                }
                sb.append(parent);
            }
            sb.append('}');
        }
        if (this.children != null && this.children.size() > 0) {
            sb.append(", children : {");
            isFirst = true;
            for (String child : this.children) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append('|');
                }
                sb.append(child);
            }
            sb.append('}');
        }
        sb.append(']');
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }

    private void addProperty(String key, String value) {
        Props.Entry entry = new Props.Entry();
        entry.setKey(key);
        entry.setValue(value);
        this.props.getEntry().add(entry);
    }

    public void addProperties(Properties props) {
        if (props != null) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = props.getProperty(key);
                this.addProperty(key, val);
            }
        }
    }

    public Properties getProperties() {
        Properties properties = null;
        List<Props.Entry> props = this.props.getEntry();
        if (props.size() > 0) {
            properties = new Properties();
            for (Props.Entry entry : props) {
                String key = entry.getKey();
                String val = entry.getValue();
                properties.setProperty(key, val);
            }
        }
        return properties;
    }
}

