/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.ldap;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicyRequest;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicyRequestImpl;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicyResponse;
import org.apache.directory.api.ldap.extras.controls.relax.RelaxControlImpl;
import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.exception.LdapOperationErrorException;
import org.apache.directory.api.ldap.model.message.AddRequest;
import org.apache.directory.api.ldap.model.message.AddRequestImpl;
import org.apache.directory.api.ldap.model.message.AddResponse;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.ldap.model.message.BindRequestImpl;
import org.apache.directory.api.ldap.model.message.BindResponse;
import org.apache.directory.api.ldap.model.message.CompareRequest;
import org.apache.directory.api.ldap.model.message.CompareRequestImpl;
import org.apache.directory.api.ldap.model.message.CompareResponse;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.message.ModifyRequestImpl;
import org.apache.directory.api.ldap.model.message.ModifyResponse;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchRequestImpl;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.message.controls.ProxiedAuthzImpl;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.fortress.core.GlobalIds;
import org.apache.directory.fortress.core.ldap.LdapConnectionProvider;
import org.apache.directory.fortress.core.ldap.LdapCounters;
import org.apache.directory.fortress.core.model.Constraint;
import org.apache.directory.fortress.core.model.ConstraintUtil;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.Hier;
import org.apache.directory.fortress.core.model.Relationship;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.LdapUtil;
import org.apache.directory.ldap.client.api.LdapConnection;

public abstract class LdapDataProvider {
    private static final String CLS_NM = LdapDataProvider.class.getName();
    private static final int MAX_DEPTH = 100;
    private static final LdapCounters COUNTERS = new LdapCounters();
    private static final PasswordPolicyRequest PP_REQ_CTRL = new PasswordPolicyRequestImpl();

    protected static String getRootDn(String contextId, String root) {
        String szDn = Config.getInstance().getProperty(root);
        if (StringUtils.isNotEmpty((String)contextId) && !contextId.equalsIgnoreCase("null") && !contextId.equals("HOME")) {
            int idx = szDn.indexOf(Config.getInstance().getProperty("suffix"));
            if (idx > 0) {
                StringBuilder dn = new StringBuilder();
                dn.append(szDn.substring(0, idx - 1)).append(",").append("ou").append("=").append(contextId).append(",").append(szDn.substring(idx));
                return dn.toString();
            }
            return "";
        }
        return szDn;
    }

    protected String getRootDn(String contextId) {
        StringBuilder dn = new StringBuilder();
        if (StringUtils.isNotEmpty((String)contextId) && !contextId.equalsIgnoreCase("null") && !contextId.equals("HOME")) {
            dn.append("ou").append("=").append(contextId).append(",").append(Config.getInstance().getProperty("suffix"));
        } else {
            dn.append(Config.getInstance().getProperty("suffix"));
        }
        return dn.toString();
    }

    protected Entry read(LdapConnection connection, String dn, String[] attrs) throws LdapException {
        COUNTERS.incrementRead();
        return connection.lookup(dn, attrs);
    }

    protected Entry read(LdapConnection connection, Dn dn, String[] attrs) throws LdapException {
        COUNTERS.incrementRead();
        return connection.lookup(dn, attrs);
    }

    protected Entry read(LdapConnection connection, String dn, String[] attrs, String userDn) throws LdapException {
        COUNTERS.incrementRead();
        return connection.lookup(dn, attrs);
    }

    protected void add(LdapConnection connection, Entry entry) throws LdapException {
        COUNTERS.incrementAdd();
        connection.add(entry);
    }

    protected void add(LdapConnection connection, Entry entry, FortEntity entity) throws LdapException {
        this.add(connection, entry, entity, false);
    }

    protected void add(LdapConnection connection, Entry entry, FortEntity entity, boolean setRelaxControl) throws LdapException {
        COUNTERS.incrementAdd();
        if (!Config.getInstance().isAuditDisabled() && entity != null && entity.getAdminSession() != null) {
            if (StringUtils.isNotEmpty((String)entity.getAdminSession().getInternalUserId())) {
                entry.add("ftModifier", new String[]{entity.getAdminSession().getInternalUserId()});
            }
            if (StringUtils.isNotEmpty((String)entity.getModCode())) {
                entry.add("ftModCode", new String[]{entity.getModCode()});
            }
            if (StringUtils.isNotEmpty((String)entity.getModId())) {
                entry.add("ftModId", new String[]{entity.getModId()});
            }
        }
        AddRequestImpl addRequest = new AddRequestImpl();
        addRequest.setEntry(entry);
        if (setRelaxControl) {
            addRequest.addControl((Control)new RelaxControlImpl());
        }
        AddResponse response = connection.add((AddRequest)addRequest);
        ResultCodeEnum.processResponse((ResultResponse)response);
    }

    protected void modify(LdapConnection connection, String dn, List<Modification> mods) throws LdapException {
        COUNTERS.incrementMod();
        connection.modify(dn, mods.toArray(new Modification[0]));
    }

    protected void modify(LdapConnection connection, Dn dn, List<Modification> mods) throws LdapException {
        COUNTERS.incrementMod();
        connection.modify(dn, mods.toArray(new Modification[0]));
    }

    protected void modify(LdapConnection connection, String dn, List<Modification> mods, FortEntity entity) throws LdapException {
        this.modify(connection, dn, mods, entity, false);
    }

    protected void modify(LdapConnection connection, String dn, List<Modification> mods, FortEntity entity, boolean setRelaxControl) throws LdapException {
        COUNTERS.incrementMod();
        this.audit(mods, entity);
        ModifyRequestImpl modRequest = new ModifyRequestImpl();
        for (Modification mod : mods) {
            modRequest.addModification(mod);
        }
        if (setRelaxControl) {
            modRequest.addControl((Control)new RelaxControlImpl());
        }
        modRequest.setName(new Dn(new String[]{dn}));
        ModifyResponse response = connection.modify((ModifyRequest)modRequest);
        ResultCodeEnum.processResponse((ResultResponse)response);
    }

    protected void modify(LdapConnection connection, Dn dn, List<Modification> mods, FortEntity entity) throws LdapException {
        COUNTERS.incrementMod();
        this.audit(mods, entity);
        connection.modify(dn, mods.toArray(new Modification[0]));
    }

    protected void delete(LdapConnection connection, String dn) throws LdapException {
        COUNTERS.incrementDelete();
        connection.delete(dn);
    }

    protected void delete(LdapConnection connection, String dn, FortEntity entity) throws LdapException {
        COUNTERS.incrementDelete();
        ArrayList<Modification> mods = new ArrayList<Modification>();
        this.audit(mods, entity);
        if (mods.size() > 0) {
            this.modify(connection, dn, mods);
        }
        connection.delete(dn);
    }

    protected void delete(LdapConnection connection, Dn dn, FortEntity entity) throws LdapException {
        COUNTERS.incrementDelete();
        ArrayList<Modification> mods = new ArrayList<Modification>();
        this.audit(mods, entity);
        if (mods.size() > 0) {
            this.modify(connection, dn, mods);
        }
        connection.delete(dn);
    }

    protected void deleteRecursive(LdapConnection connection, String dn) throws LdapException, CursorException {
        int recursiveCount = 0;
        this.deleteRecursive(dn, connection, recursiveCount);
    }

    protected void deleteRecursive(LdapConnection connection, String dn, FortEntity entity) throws LdapException, CursorException {
        ArrayList<Modification> mods = new ArrayList<Modification>();
        this.audit(mods, entity);
        if (mods.size() > 0) {
            this.modify(connection, dn, mods);
        }
        this.deleteRecursive(connection, dn);
    }

    private void deleteRecursive(String dn, LdapConnection connection, int recursiveCount) throws LdapException, CursorException {
        String method = "deleteRecursive";
        if (recursiveCount++ > 100) {
            String error = "." + method + " dn [" + dn + "] depth error in recursive";
            throw new LdapOperationErrorException(error);
        }
        SearchCursor cursor = this.search(connection, dn, SearchScope.ONELEVEL, "(objectclass=*)", SchemaConstants.NO_ATTRIBUTE_ARRAY, false, 0);
        while (cursor.next()) {
            try {
                Entry entry = cursor.getEntry();
                String theDN = entry.getDn().getName();
                this.deleteRecursive(theDN, connection, recursiveCount);
                --recursiveCount;
            }
            catch (LdapException le) {
                String error = "." + method + " dn [" + dn + "] caught LdapException=" + le.getMessage();
                throw new LdapException(error);
            }
        }
        COUNTERS.incrementDelete();
        this.delete(connection, dn);
    }

    private void audit(List<Modification> mods, FortEntity entity) {
        if (!Config.getInstance().isAuditDisabled() && entity != null && entity.getAdminSession() != null) {
            DefaultModification modification;
            if (StringUtils.isNotEmpty((String)entity.getAdminSession().getInternalUserId())) {
                modification = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "ftModifier", new String[]{entity.getAdminSession().getInternalUserId()});
                mods.add((Modification)modification);
            }
            if (StringUtils.isNotEmpty((String)entity.getModCode())) {
                modification = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "ftModCode", new String[]{entity.getModCode()});
                mods.add((Modification)modification);
            }
            if (StringUtils.isNotEmpty((String)entity.getModId())) {
                modification = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "ftModId", new String[]{entity.getModId()});
                mods.add((Modification)modification);
            }
        }
    }

    protected SearchCursor search(LdapConnection connection, String baseDn, SearchScope scope, String filter, String[] attrs, boolean attrsOnly) throws LdapException {
        COUNTERS.incrementSearch();
        SearchRequestImpl searchRequest = new SearchRequestImpl();
        searchRequest.setBase(new Dn(new String[]{baseDn}));
        searchRequest.setScope(scope);
        searchRequest.setFilter(filter);
        searchRequest.setTypesOnly(attrsOnly);
        searchRequest.addAttributes(attrs);
        return connection.search((SearchRequest)searchRequest);
    }

    protected SearchCursor search(LdapConnection connection, String baseDn, SearchScope scope, String filter, String[] attrs, boolean attrsOnly, int maxEntries) throws LdapException {
        COUNTERS.incrementSearch();
        SearchRequestImpl searchRequest = new SearchRequestImpl();
        searchRequest.setBase(new Dn(new String[]{baseDn}));
        searchRequest.setFilter(filter);
        searchRequest.setScope(scope);
        searchRequest.setSizeLimit((long)maxEntries);
        searchRequest.setTypesOnly(attrsOnly);
        searchRequest.addAttributes(attrs);
        return connection.search((SearchRequest)searchRequest);
    }

    protected Entry searchNode(LdapConnection connection, String baseDn, SearchScope scope, String filter, String[] attrs, boolean attrsOnly) throws LdapException, CursorException {
        SearchRequestImpl searchRequest = new SearchRequestImpl();
        searchRequest.setBase(new Dn(new String[]{baseDn}));
        searchRequest.setFilter(filter);
        searchRequest.setScope(scope);
        searchRequest.setTypesOnly(attrsOnly);
        searchRequest.addAttributes(attrs);
        SearchCursor result = connection.search((SearchRequest)searchRequest);
        Entry entry = result.getEntry();
        if (result.next()) {
            throw new LdapException("searchNode failed to return unique record for LDAP search of base DN [" + baseDn + "] filter [" + filter + "]");
        }
        return entry;
    }

    protected Entry searchNode(LdapConnection connection, String baseDn, SearchScope scope, String filter, String[] attrs, boolean attrsOnly, String userDn) throws LdapException, CursorException {
        COUNTERS.incrementSearch();
        SearchRequestImpl searchRequest = new SearchRequestImpl();
        searchRequest.setBase(new Dn(new String[]{baseDn}));
        searchRequest.setFilter(filter);
        searchRequest.setScope(scope);
        searchRequest.setTypesOnly(attrsOnly);
        searchRequest.addAttributes(attrs);
        SearchCursor result = connection.search((SearchRequest)searchRequest);
        Entry entry = result.getEntry();
        if (result.next()) {
            throw new LdapException("searchNode failed to return unique record for LDAP search of base DN [" + baseDn + "] filter [" + filter + "]");
        }
        return entry;
    }

    protected boolean compareNode(LdapConnection connection, String dn, String userDn, Attribute attribute) throws LdapException, UnsupportedEncodingException {
        COUNTERS.incrementCompare();
        CompareRequestImpl compareRequest = new CompareRequestImpl();
        compareRequest.setName(new Dn(new String[]{dn}));
        compareRequest.setAttributeId(attribute.getId());
        compareRequest.setAssertionValue(attribute.getString());
        ProxiedAuthzImpl proxiedAuthzControl = new ProxiedAuthzImpl();
        proxiedAuthzControl.setAuthzId("dn: " + userDn);
        compareRequest.addControl((Control)proxiedAuthzControl);
        CompareResponse response = connection.compare((CompareRequest)compareRequest);
        return response.getLdapResult().getResultCode() == ResultCodeEnum.SUCCESS;
    }

    protected List<String> getAttributes(Entry entry, String attributeName) {
        ArrayList<String> attrValues = new ArrayList<String>();
        if (entry != null) {
            Attribute attr = entry.get(attributeName);
            if (attr != null) {
                for (Value value : attr) {
                    attrValues.add(value.getString());
                }
            } else {
                return null;
            }
        }
        return attrValues;
    }

    protected byte[] getPhoto(Entry entry, String attributeName) throws LdapInvalidAttributeValueException {
        byte[] photo = null;
        Attribute attr = entry.get(attributeName);
        if (attr != null) {
            photo = attr.getBytes();
        }
        return photo;
    }

    protected Set<String> getAttributeSet(Entry entry, String attributeName) {
        TreeSet<String> attrValues = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (entry != null && entry.containsAttribute(new String[]{attributeName})) {
            for (Value value : entry.get(attributeName)) {
                attrValues.add(value.getString());
            }
        }
        return attrValues;
    }

    protected String getAttribute(Entry entry, String attributeName) throws LdapInvalidAttributeValueException {
        if (entry != null) {
            Attribute attr = entry.get(attributeName);
            if (attr != null) {
                return attr.getString();
            }
            return null;
        }
        return null;
    }

    protected String getRdn(String dn) {
        try {
            return new Dn(new String[]{dn}).getRdn().getName();
        }
        catch (LdapInvalidDnException lide) {
            return null;
        }
    }

    protected Attribute createAttributes(String name, String[] values) throws LdapException {
        return new DefaultAttribute(name, values);
    }

    protected void unloadTemporal(Entry le, Constraint ftDateTime) throws LdapInvalidAttributeValueException {
        String szRawData = this.getAttribute(le, "ftCstr");
        if (szRawData != null && szRawData.length() > 0) {
            ConstraintUtil.setConstraint(szRawData, ftDateTime);
        }
    }

    protected void loadAttrs(List<String> list, Entry entry, String attrName) throws LdapException {
        if (list != null && list.size() > 0) {
            entry.add(attrName, list.toArray(new String[0]));
        }
    }

    protected void loadAttrs(List<String> list, List<Modification> mods, String attrName) {
        if (list != null && list.size() > 0) {
            mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, attrName, list.toArray(new String[0])));
        }
    }

    protected void loadRelationshipAttrs(List<Relationship> list, List<Modification> mods, String attrName, Hier.Op op) {
        if (list != null) {
            for (Relationship rel : list) {
                DefaultAttribute attr = new DefaultAttribute(attrName, new String[]{rel.getChild() + ':' + rel.getParent()});
                switch (op) {
                    case ADD: {
                        mods.add((Modification)new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, (Attribute)attr));
                        break;
                    }
                    case MOD: {
                        mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, (Attribute)attr));
                        break;
                    }
                    case REM: {
                        mods.add((Modification)new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, (Attribute)attr));
                    }
                }
            }
        }
    }

    protected void loadAttrs(Set<String> values, List<Modification> mods, String attrName) {
        if (values != null && values.size() > 0) {
            mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, attrName, values.toArray(new String[0])));
        }
    }

    protected void loadAttrs(Set<String> values, Entry entry, String attrName) throws LdapException {
        if (values != null && values.size() > 0) {
            entry.add(attrName, values.toArray(new String[0]));
        }
    }

    protected void loadProperties(Properties props, List<Modification> mods, String attrName, boolean replace) {
        this.loadProperties(props, mods, attrName, replace, ':');
    }

    protected void loadProperties(Properties props, List<Modification> mods, String attrName, boolean replace, char separator) {
        if (props != null && props.size() > 0) {
            if (replace) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, attrName));
            }
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = props.getProperty(key);
                mods.add((Modification)new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, attrName, new String[]{key + separator + val}));
            }
        }
    }

    protected void removeProperties(Properties props, List<Modification> mods, String attrName) {
        if (props != null && props.size() > 0) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = props.getProperty(key);
                mods.add((Modification)new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, attrName, new String[]{key + ':' + val}));
            }
        }
    }

    protected void loadProperties(Properties props, Entry entry, String attrName) throws LdapException {
        if (props != null && props.size() > 0) {
            DefaultAttribute attr = new DefaultAttribute(attrName);
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = props.getProperty(key);
                String prop = key + ':' + val;
                attr.add(new String[]{prop});
            }
            if (attr.size() != 0) {
                entry.add(new Attribute[]{attr});
            }
        }
    }

    protected void loadProperties(Properties props, Entry entry, String attrName, char separator) throws LdapException {
        if (props != null && props.size() > 0) {
            DefaultAttribute attr = null;
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = props.getProperty(key);
                String prop = key + separator + val;
                if (attr == null) {
                    attr = new DefaultAttribute(attrName);
                    continue;
                }
                attr.add(new String[]{prop});
            }
            if (attr != null) {
                entry.add(new Attribute[]{attr});
            }
        }
    }

    protected String encodeSafeText(String value, int validLen) throws LdapException {
        if (StringUtils.isNotEmpty((String)value)) {
            int length = value.length();
            if (length > validLen) {
                String error = "encodeSafeText value [" + value + "] invalid length [" + length + "]";
                throw new LdapException(error);
            }
            if (LdapUtil.getInstance().isLdapfilterSizeFound()) {
                value = this.escapeLDAPSearchFilter(value);
            }
        }
        return value;
    }

    protected PasswordPolicyResponse getPwdRespCtrl(BindResponse resp) {
        return (PasswordPolicyResponse)resp.getControls().get("1.3.6.1.4.1.42.2.27.8.5.1");
    }

    protected BindResponse bind(LdapConnection connection, String szUserDn, String password) throws LdapException {
        COUNTERS.incrementBind();
        Dn userDn = new Dn(new String[]{szUserDn});
        BindRequestImpl bindReq = new BindRequestImpl();
        bindReq.setDn(userDn);
        bindReq.setCredentials(password);
        bindReq.addControl((Control)PP_REQ_CTRL);
        return connection.bind((BindRequest)bindReq);
    }

    public void closeAdminConnection(LdapConnection connection) {
        LdapConnectionProvider.getInstance().closeAdminConnection(connection);
    }

    protected void closeLogConnection(LdapConnection connection) {
        LdapConnectionProvider.getInstance().closeLogConnection(connection);
    }

    protected void closeUserConnection(LdapConnection connection) {
        LdapConnectionProvider.getInstance().closeUserConnection(connection);
    }

    public LdapConnection getAdminConnection() throws LdapException {
        return LdapConnectionProvider.getInstance().getAdminConnection();
    }

    protected LdapConnection getLogConnection() throws LdapException {
        return LdapConnectionProvider.getInstance().getLogConnection();
    }

    protected LdapConnection getUserConnection() throws LdapException {
        return LdapConnectionProvider.getInstance().getUserConnection();
    }

    public static LdapCounters getLdapCounters() {
        return COUNTERS;
    }

    protected String escapeLDAPSearchFilter(String filter) {
        StringBuilder sb = new StringBuilder();
        int filterLen = filter.length();
        for (int i = 0; i < filterLen; ++i) {
            boolean found = false;
            char curChar = filter.charAt(i);
            for (int j = 0; j < GlobalIds.LDAP_FILTER_SIZE && LdapUtil.getInstance().getLdapMetaChars()[j] <= curChar; ++j) {
                if (curChar != LdapUtil.getInstance().getLdapMetaChars()[j]) continue;
                sb.append("\\");
                sb.append(LdapUtil.getInstance().getLdapReplVals()[j]);
                found = true;
                break;
            }
            if (found) continue;
            sb.append(curChar);
        }
        return sb.toString();
    }

    public static void closeAllConnectionPools() {
        LdapConnectionProvider.closeAllConnectionPools();
    }
}

