/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.fortress.core.FinderException;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.ValidationException;
import org.apache.directory.fortress.core.impl.RoleDAO;
import org.apache.directory.fortress.core.model.Graphable;
import org.apache.directory.fortress.core.model.Group;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.core.util.ConstraintValidator;
import org.apache.directory.fortress.core.util.VUtil;

final class RoleP {
    private RoleDAO rDao = new RoleDAO();
    private static final ConstraintValidator constraintValidator = VUtil.getConstraintValidator();

    RoleP() {
    }

    Role read(Role role) throws SecurityException {
        return this.rDao.getRole(role);
    }

    List<Role> search(Role role) throws SecurityException {
        return this.rDao.findRoles(role);
    }

    List<String> search(Role role, int limit) throws SecurityException {
        return this.rDao.findRoles(role, limit);
    }

    List<Role> search(Group group) throws SecurityException {
        if (group.getType() != Group.Type.ROLE) {
            String info = "search failed for Group [" + group.getName() + "], group must be of type ROLE.";
            throw new ValidationException(10314, info);
        }
        return this.rDao.groupRoles(group);
    }

    List<Graphable> getAllDescendants(String contextId) throws SecurityException {
        return this.rDao.getAllDescendants(contextId);
    }

    Role add(Role entity) throws SecurityException {
        this.validate(entity);
        return this.rDao.create(entity);
    }

    Role update(Role entity) throws SecurityException {
        this.validate(entity);
        return this.rDao.update(entity);
    }

    void deleteParent(Role entity) throws SecurityException {
        this.validate(entity);
        this.rDao.deleteParent(entity);
    }

    Role assign(Role entity, String userDn) throws SecurityException {
        return this.rDao.assign(entity, userDn);
    }

    Role deassign(Role entity, String userDn) throws SecurityException {
        entity = this.rDao.deassign(entity, userDn);
        return entity;
    }

    void addOccupant(List<UserRole> uRoles, String userDn, String contextId) throws SecurityException {
        if (CollectionUtils.isNotEmpty(uRoles)) {
            for (UserRole uRole : uRoles) {
                Role role = new Role(uRole.getName());
                role.setContextId(contextId);
                this.assign(role, userDn);
            }
        }
    }

    void removeOccupant(String userDn, String contextId) throws SecurityException {
        try {
            List<String> list = this.rDao.findAssignedRoles(userDn, contextId);
            for (String roleNm : list) {
                Role role = new Role(roleNm);
                role.setContextId(contextId);
                this.deassign(role, userDn);
            }
        }
        catch (FinderException fe) {
            String error = "removeOccupant userDn [" + userDn + "] caught FinderException=" + fe;
            throw new SecurityException(5012, error, fe);
        }
    }

    void delete(Role entity) throws SecurityException {
        this.rDao.remove(entity);
    }

    private void validate(Role entity) throws ValidationException {
        VUtil.safeText(entity.getName(), 40);
        if (StringUtils.isNotEmpty((String)entity.getDescription())) {
            VUtil.description(entity.getDescription());
        }
        if (entity.getTimeout() != null) {
            constraintValidator.timeout(entity.getTimeout());
        }
        if (StringUtils.isNotEmpty((String)entity.getBeginTime())) {
            constraintValidator.beginTime(entity.getBeginTime());
        }
        if (StringUtils.isNotEmpty((String)entity.getEndTime())) {
            constraintValidator.endTime(entity.getEndTime());
        }
        if (StringUtils.isNotEmpty((String)entity.getBeginDate())) {
            constraintValidator.beginDate(entity.getBeginDate());
        }
        if (StringUtils.isNotEmpty((String)entity.getEndDate())) {
            constraintValidator.endDate(entity.getEndDate());
        }
        if (StringUtils.isNotEmpty((String)entity.getDayMask())) {
            constraintValidator.dayMask(entity.getDayMask());
        }
        if (StringUtils.isNotEmpty((String)entity.getBeginLockDate())) {
            constraintValidator.beginDate(entity.getBeginDate());
        }
        if (StringUtils.isNotEmpty((String)entity.getEndLockDate())) {
            constraintValidator.endDate(entity.getEndLockDate());
        }
    }
}

