/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.ValidationException;
import org.apache.directory.fortress.core.impl.HierUtil;
import org.apache.directory.fortress.core.impl.OrgUnitP;
import org.apache.directory.fortress.core.model.Graphable;
import org.apache.directory.fortress.core.model.Hier;
import org.apache.directory.fortress.core.model.OrgUnit;
import org.apache.directory.fortress.core.model.Relationship;
import org.apache.directory.fortress.core.util.cache.Cache;
import org.apache.directory.fortress.core.util.cache.CacheMgr;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PsoUtil {
    private Cache psoCache;
    private OrgUnitP orgUnitP;
    private static final String CLS_NM = PsoUtil.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);
    private static volatile PsoUtil sINSTANCE = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static PsoUtil getInstance() {
        if (sINSTANCE != null) return sINSTANCE;
        Class<PsoUtil> clazz = PsoUtil.class;
        synchronized (PsoUtil.class) {
            if (sINSTANCE != null) return sINSTANCE;
            sINSTANCE = new PsoUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sINSTANCE;
        }
    }

    private PsoUtil() {
        this.init();
    }

    private void init() {
        this.orgUnitP = new OrgUnitP();
        CacheMgr cacheMgr = CacheMgr.getInstance();
        this.psoCache = cacheMgr.getCache("fortress.pso");
    }

    Set<String> getDescendants(String name, String contextId) {
        return HierUtil.getDescendants(name, this.getGraph(contextId));
    }

    Set<String> getAscendants(String name, String contextId) {
        return HierUtil.getAscendants(name, this.getGraph(contextId));
    }

    public Set<String> getChildren(String name, String contextId) {
        return HierUtil.getChildren(name, this.getGraph(contextId));
    }

    Set<String> getParents(String name, String contextId) {
        return HierUtil.getParents(name, this.getGraph(contextId));
    }

    int numChildren(String name, String contextId) {
        return HierUtil.numChildren(name, this.getGraph(contextId));
    }

    Set<String> getInherited(List<OrgUnit> ous, String contextId) {
        TreeSet<String> iOUs = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (CollectionUtils.isNotEmpty(ous)) {
            for (OrgUnit ou : ous) {
                String name = ou.getName();
                iOUs.add(name);
                Set<String> parents = HierUtil.getAscendants(name, this.getGraph(contextId));
                if (!CollectionUtils.isNotEmpty(parents)) continue;
                iOUs.addAll(parents);
            }
        }
        return iOUs;
    }

    void validateRelationship(OrgUnit child, OrgUnit parent, boolean mustExist) throws ValidationException {
        HierUtil.validateRelationship(this.getGraph(child.getContextId()), child.getName(), parent.getName(), mustExist);
    }

    void updateHier(String contextId, Relationship relationship, Hier.Op op) throws SecurityException {
        HierUtil.updateHier(this.getGraph(contextId), relationship, op);
    }

    private synchronized SimpleDirectedGraph<String, Relationship> loadGraph(String contextId) {
        Hier inHier = new Hier(Hier.Type.ROLE);
        inHier.setContextId(contextId);
        LOG.info("loadGraph initializing PSO context [{}]", (Object)inHier.getContextId());
        List<Graphable> descendants = null;
        try {
            OrgUnit orgUnit = new OrgUnit();
            orgUnit.setType(OrgUnit.Type.PERM);
            orgUnit.setContextId(contextId);
            descendants = this.orgUnitP.getAllDescendants(orgUnit);
        }
        catch (SecurityException se) {
            LOG.info("loadGraph caught SecurityException={}", (Throwable)se);
        }
        Hier hier = HierUtil.loadHier(contextId, descendants);
        SimpleDirectedGraph<String, Relationship> graph = HierUtil.buildGraph(hier);
        this.psoCache.put(PsoUtil.getKey(contextId), graph);
        return graph;
    }

    private SimpleDirectedGraph<String, Relationship> getGraph(String contextId) {
        String key = PsoUtil.getKey(contextId);
        LOG.debug("Getting graph for key " + contextId);
        SimpleDirectedGraph graph = (SimpleDirectedGraph)this.psoCache.get(key);
        if (graph == null) {
            LOG.debug("Graph was null, creating... " + contextId);
            return this.loadGraph(contextId);
        }
        LOG.debug("Graph found in cache, returning...");
        return graph;
    }

    private static String getKey(String contextId) {
        String key = HierUtil.Type.PSO.toString();
        if (StringUtils.isNotEmpty((String)contextId) && !contextId.equalsIgnoreCase("null")) {
            key = key + ":" + contextId;
        }
        return key;
    }
}

