/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapAttributeInUseException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchAttributeException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.fortress.core.CreateException;
import org.apache.directory.fortress.core.FinderException;
import org.apache.directory.fortress.core.RemoveException;
import org.apache.directory.fortress.core.UpdateException;
import org.apache.directory.fortress.core.impl.AdminRoleUtil;
import org.apache.directory.fortress.core.impl.RoleUtil;
import org.apache.directory.fortress.core.ldap.LdapDataProvider;
import org.apache.directory.fortress.core.model.AdminRole;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.ObjectFactory;
import org.apache.directory.fortress.core.model.OrgUnit;
import org.apache.directory.fortress.core.model.PermObj;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.PermissionAttribute;
import org.apache.directory.fortress.core.model.PermissionAttributeSet;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.PropUtil;
import org.apache.directory.ldap.client.api.LdapConnection;

class PermDAO
extends LdapDataProvider {
    private static final String PERM_OBJ_OBJECT_CLASS_NAME = "ftObject";
    private static final String PERM_OP_OBJECT_CLASS_NAME = "ftOperation";
    private static final String PERMISSION_ATTRIBUTE_SET_OBJECT_CLASS_NAME = "ftAttributeSet";
    private static final String PERMISSION_ATTRIBUTE_OBJECT_CLASS_NAME = "ftAttribute";
    private static final String[] PERM_OBJ_OBJ_CLASS = new String[]{"top", "organizationalUnit", "ftObject", "ftProperties", "ftMods"};
    private static final String[] PERM_OP_OBJ_CLASS = new String[]{"top", "organizationalRole", "ftOperation", "ftProperties", "ftMods"};
    private static final String[] PERM_ATTR_SET_OBJ_CLASS = new String[]{"top", "organizationalUnit", "ftAttributeSet", "ftProperties", "ftMods"};
    private static final String[] PERM_ATTR_OBJ_CLASS = new String[]{"top", "organizationalRole", "ftAttribute", "ftProperties", "ftMods"};
    private static final String PERM_NAME = "ftPermName";
    private static final String ROLES = "ftRoles";
    private static final String USERS = "ftUsers";
    private static final String PERMISSION_ATTRIBUTE_SET = "ftPASet";
    private static final String[] PERMISSION_OP_ATRS = new String[]{"ftId", "ftPermName", "ftObjNm", "ftOpNm", "description", "ou", "ftObjId", "ftType", "ftRoles", "ftUsers", "ftProps", "ftPASet"};
    private static final String[] PERMISION_OBJ_ATRS = new String[]{"ftId", "ftObjNm", "description", "ou", "ftType", "ftProps"};
    private static final String[] PERMISION_ATTRIBUTE_SET_ATRS = new String[]{"ftId", "description", "cn", "ftPASetType"};
    private static final String[] PERMISION_ATTRIBUTE_ATRS = new String[]{"ftId", "ftPA", "description", "cn", "ftPASet", "ftPADataType", "ftPADefaultOperator", "ftPADefaultStrategy", "ftPADefaultValue", "ftPAValidVals"};

    PermDAO() {
    }

    PermObj createObject(PermObj entity) throws CreateException {
        LdapConnection ld = null;
        String dn = this.getDn(entity, entity.getContextId());
        try {
            DefaultEntry entry = new DefaultEntry(dn);
            entry.add("objectClass", PERM_OBJ_OBJ_CLASS);
            entry.add("ftObjNm", new String[]{entity.getObjName()});
            entity.setInternalId();
            entry.add("ftId", new String[]{entity.getInternalId()});
            entry.add("ou", new String[]{entity.getOu()});
            if (StringUtils.isNotEmpty((String)entity.getDescription())) {
                entry.add("description", new String[]{entity.getDescription()});
            }
            if (StringUtils.isNotEmpty((String)entity.getType())) {
                entry.add("ftType", new String[]{entity.getType()});
            }
            if (PropUtil.isNotEmpty(entity.getProperties())) {
                this.loadProperties(entity.getProperties(), (Entry)entry, "ftProps");
            }
            ld = this.getAdminConnection();
            this.add(ld, (Entry)entry, entity);
            entity.setDn(dn);
        }
        catch (LdapException e) {
            try {
                String error = "createObject perm obj [" + entity.getObjName() + "] caught LdapException=" + (Object)((Object)e);
                throw new CreateException(3003, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return entity;
    }

    PermObj updateObj(PermObj entity) throws UpdateException {
        LdapConnection ld = null;
        String dn = this.getDn(entity, entity.getContextId());
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            if (StringUtils.isNotEmpty((String)entity.getOu())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "ou", new String[]{entity.getOu()}));
            }
            if (StringUtils.isNotEmpty((String)entity.getDescription())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "description", new String[]{entity.getDescription()}));
            }
            if (StringUtils.isNotEmpty((String)entity.getType())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "ftType", new String[]{entity.getType()}));
            }
            if (PropUtil.isNotEmpty(entity.getProperties())) {
                this.loadProperties(entity.getProperties(), mods, "ftProps", true);
            }
            if (mods.size() > 0) {
                ld = this.getAdminConnection();
                this.modify(ld, dn, mods, (FortEntity)entity);
                entity.setDn(dn);
            }
        }
        catch (LdapException e) {
            try {
                String error = "updateObj objName [" + entity.getObjName() + "] caught LdapException=" + (Object)((Object)e);
                throw new UpdateException(3004, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return entity;
    }

    void deleteObj(PermObj entity) throws RemoveException {
        LdapConnection ld = null;
        String dn = this.getDn(entity, entity.getContextId());
        try {
            ld = this.getAdminConnection();
            this.deleteRecursive(ld, dn, entity);
        }
        catch (LdapException e) {
            String error = "deleteObj objName [" + entity.getObjName() + "] caught LdapException=" + (Object)((Object)e);
            throw new RemoveException(3005, error, (Exception)((Object)e));
        }
        catch (CursorException e) {
            String error = "deleteObj objName [" + entity.getObjName() + "] caught LdapException=" + e.getMessage();
            throw new RemoveException(3005, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
    }

    Permission createOperation(Permission entity) throws CreateException {
        LdapConnection ld = null;
        String dn = this.getDn(entity, entity.getContextId());
        try {
            DefaultEntry entry = new DefaultEntry(dn);
            entry.add("objectClass", PERM_OP_OBJ_CLASS);
            entry.add("ftOpNm", new String[]{entity.getOpName()});
            entry.add("ftObjNm", new String[]{entity.getObjName()});
            entity.setAbstractName(entity.getObjName() + "." + entity.getOpName());
            entity.setInternalId();
            entry.add("ftId", new String[]{entity.getInternalId()});
            if (StringUtils.isNotEmpty((String)entity.getDescription())) {
                entry.add("description", new String[]{entity.getDescription()});
            }
            entry.add(PERM_NAME, new String[]{entity.getAbstractName()});
            entry.add("cn", new String[]{entity.getAbstractName()});
            if (StringUtils.isNotEmpty((String)entity.getObjId())) {
                entry.add("ftObjId", new String[]{entity.getObjId()});
            }
            if (StringUtils.isNotEmpty((String)entity.getType())) {
                entry.add("ftType", new String[]{entity.getType()});
            }
            this.loadAttrs(entity.getRoles(), (Entry)entry, ROLES);
            this.loadAttrs(entity.getUsers(), (Entry)entry, USERS);
            this.loadAttrs(entity.getPaSets(), (Entry)entry, PERMISSION_ATTRIBUTE_SET);
            if (PropUtil.isNotEmpty(entity.getProperties())) {
                this.loadProperties(entity.getProperties(), (Entry)entry, "ftProps");
            }
            ld = this.getAdminConnection();
            this.add(ld, (Entry)entry, entity);
            entity.setDn(dn);
        }
        catch (LdapException e) {
            try {
                String error = "createOperation objName [" + entity.getObjName() + "] opName [" + entity.getOpName() + "] caught LdapException=" + (Object)((Object)e);
                throw new CreateException(3003, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return entity;
    }

    PermissionAttributeSet createPermissionAttributeSet(PermissionAttributeSet entity) throws CreateException {
        LdapConnection ld = null;
        String dn = this.getDn(entity, entity.getContextId());
        try {
            DefaultEntry entry = new DefaultEntry(dn);
            entry.add("objectClass", PERM_ATTR_SET_OBJ_CLASS);
            entry.add(PERMISSION_ATTRIBUTE_SET, new String[]{entity.getName()});
            entity.setInternalId();
            entry.add("ftId", new String[]{entity.getInternalId()});
            if (StringUtils.isNotEmpty((String)entity.getDescription())) {
                entry.add("description", new String[]{entity.getDescription()});
            }
            if (StringUtils.isNotEmpty((String)entity.getType())) {
                entry.add("ftPASetType", new String[]{entity.getType()});
            }
            entry.add("cn", new String[]{entity.getName()});
            ld = this.getAdminConnection();
            this.add(ld, (Entry)entry, entity);
            entity.setDn(dn);
        }
        catch (LdapException e) {
            try {
                String error = "createPermissionAttributeSet name [" + entity.getName() + "] caught LdapException=" + (Object)((Object)e);
                throw new CreateException(3003, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        for (PermissionAttribute pa : entity.getAttributes()) {
            pa.setContextId(entity.getContextId());
            this.createPermissionAttribute(pa, entity.getName());
        }
        return entity;
    }

    PermissionAttribute createPermissionAttribute(PermissionAttribute entity, String attributeSetName) throws CreateException {
        LdapConnection ld = null;
        String dn = this.getDn(entity, attributeSetName, entity.getContextId());
        try {
            DefaultEntry entry = new DefaultEntry(dn);
            entry.add("objectClass", PERM_ATTR_OBJ_CLASS);
            entity.setInternalId();
            entry.add("ftId", new String[]{entity.getInternalId()});
            entry.add("ftPA", new String[]{entity.getAttributeName()});
            entry.add(PERMISSION_ATTRIBUTE_SET, new String[]{attributeSetName});
            if (StringUtils.isNotEmpty((String)entity.getDescription())) {
                entry.add("description", new String[]{entity.getDescription()});
            }
            if (StringUtils.isNotEmpty((String)entity.getDataType())) {
                entry.add("ftPADataType", new String[]{entity.getDataType()});
            }
            if (StringUtils.isNotEmpty((String)entity.getDefaultOperator())) {
                entry.add("ftPADefaultOperator", new String[]{entity.getDefaultOperator()});
            }
            if (StringUtils.isNotEmpty((String)entity.getDefaultStrategy())) {
                entry.add("ftPADefaultStrategy", new String[]{entity.getDefaultStrategy()});
            }
            if (StringUtils.isNotEmpty((String)entity.getDefaultValue())) {
                entry.add("ftPADefaultValue", new String[]{entity.getDefaultValue()});
            }
            for (String validValue : entity.getValidValues()) {
                entry.add("ftPAValidVals", new String[]{validValue});
            }
            entry.add("cn", new String[]{entity.getAttributeName()});
            ld = this.getAdminConnection();
            this.add(ld, (Entry)entry, entity);
            entity.setDn(dn);
        }
        catch (LdapException e) {
            try {
                String error = "createPermissionAttribute name [" + entity.getAttributeName() + "] caught LdapException=" + (Object)((Object)e);
                throw new CreateException(3034, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return entity;
    }

    PermissionAttribute updatePermissionAttribute(PermissionAttribute entity, String paSetName, boolean replaceValidValues) throws UpdateException {
        LdapConnection ld = null;
        String dn = this.getDn(entity, paSetName, entity.getContextId());
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            if (StringUtils.isNotEmpty((String)entity.getDataType())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "ftPADataType", new String[]{entity.getDataType()}));
            }
            if (StringUtils.isNotEmpty((String)entity.getDescription())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "description", new String[]{entity.getDescription()}));
            }
            if (StringUtils.isNotEmpty((String)entity.getDefaultOperator())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "ftPADefaultOperator", new String[]{entity.getDefaultOperator()}));
            }
            if (StringUtils.isNotEmpty((String)entity.getDefaultStrategy())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "ftPADefaultStrategy", new String[]{entity.getDefaultStrategy()}));
            }
            if (StringUtils.isNotEmpty((String)entity.getDefaultValue())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "ftPADefaultValue", new String[]{entity.getDefaultValue()}));
            }
            if (replaceValidValues) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, "ftPAValidVals"));
            }
            for (String validValue : entity.getValidValues()) {
                mods.add((Modification)new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, "ftPAValidVals", new String[]{validValue}));
            }
            if (mods.size() > 0) {
                ld = this.getAdminConnection();
                this.modify(ld, dn, mods, (FortEntity)entity);
                entity.setDn(dn);
            }
        }
        catch (LdapException e) {
            try {
                String error = "updatePermissionAttribute name [" + entity.getAttributeName() + "] caught LdapException=" + (Object)((Object)e);
                throw new UpdateException(3038, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return entity;
    }

    Permission updateOperation(Permission entity) throws UpdateException {
        LdapConnection ld = null;
        String dn = this.getDn(entity, entity.getContextId());
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            if (StringUtils.isNotEmpty((String)entity.getAbstractName())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, PERM_NAME, new String[]{entity.getAbstractName()}));
            }
            if (StringUtils.isNotEmpty((String)entity.getDescription())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "description", new String[]{entity.getDescription()}));
            }
            if (StringUtils.isNotEmpty((String)entity.getType())) {
                mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "ftType", new String[]{entity.getType()}));
            }
            if (CollectionUtils.isNotEmpty(entity.getPaSets())) {
                for (String paSetName : entity.getPaSets()) {
                    mods.add((Modification)new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, PERMISSION_ATTRIBUTE_SET, new String[]{paSetName}));
                }
            }
            this.loadAttrs(entity.getRoles(), mods, ROLES);
            this.loadAttrs(entity.getUsers(), mods, USERS);
            this.loadProperties(entity.getProperties(), mods, "ftProps", true);
            if (mods.size() > 0) {
                ld = this.getAdminConnection();
                this.modify(ld, dn, mods, (FortEntity)entity);
                entity.setDn(dn);
            }
        }
        catch (LdapException e) {
            try {
                String error = "updateOperation objName [" + entity.getObjName() + "] opName [" + entity.getOpName() + "] caught LdapException=" + (Object)((Object)e);
                throw new UpdateException(3004, error, (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return entity;
    }

    void deleteOperation(Permission entity) throws RemoveException {
        LdapConnection ld = null;
        String dn = PermDAO.getOpRdn(entity.getOpName(), entity.getObjId()) + "," + "ftObjNm" + "=" + entity.getObjName() + "," + this.getRootDn(entity.isAdmin(), entity.getContextId());
        try {
            ld = this.getAdminConnection();
            this.deleteRecursive(ld, dn, entity);
        }
        catch (LdapException e) {
            String error = "deleteOperation objName [" + entity.getObjName() + "] opName [" + entity.getOpName() + "] caught LdapException=" + (Object)((Object)e);
            throw new RemoveException(3005, error, (Exception)((Object)e));
        }
        catch (CursorException e) {
            String error = "deleteOperation objName [" + entity.getObjName() + "] opName [" + entity.getOpName() + "] caught LdapException=" + e.getMessage();
            throw new RemoveException(3005, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
    }

    void deleteAttributeSet(PermissionAttributeSet entity) throws RemoveException {
        LdapConnection ld = null;
        String dn = this.getDn(entity, entity.getContextId());
        try {
            ld = this.getAdminConnection();
            this.deleteRecursive(ld, dn, entity);
        }
        catch (LdapException e) {
            String error = "deleteAttributeSet name [" + entity.getName() + "] caught LdapException=" + (Object)((Object)e);
            throw new RemoveException(3031, error, (Exception)((Object)e));
        }
        catch (CursorException e) {
            String error = "deleteAttributeSet name [" + entity.getName() + "]  caught LdapException=" + e.getMessage();
            throw new RemoveException(3031, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
    }

    void deletePermissionAttribute(PermissionAttribute entity, String attributeSetName) throws RemoveException {
        LdapConnection ld = null;
        String dn = this.getDn(entity, attributeSetName, entity.getContextId());
        try {
            ld = this.getAdminConnection();
            this.delete(ld, dn);
        }
        catch (LdapException e) {
            String error = "deletePermission name [" + entity.getAttributeName() + "] set [" + attributeSetName + "] caught LdapException=" + (Object)((Object)e);
            throw new RemoveException(3033, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void grant(Permission pOp, Role role) throws UpdateException {
        LdapConnection ld = null;
        String dn = this.getDn(pOp, pOp.getContextId());
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            mods.add((Modification)new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, ROLES, new String[]{role.getName()}));
            ld = this.getAdminConnection();
            this.modify(ld, dn, mods, (FortEntity)pOp);
        }
        catch (LdapAttributeInUseException e) {
            try {
                String warning = "grant perm object [" + pOp.getObjName() + "] operation [" + pOp.getOpName() + "] role [" + role.getName() + "] assignment already exists, Fortress rc=" + 3015;
                throw new UpdateException(3015, warning);
                catch (LdapNoSuchObjectException e2) {
                    warning = "grant perm object [" + pOp.getObjName() + "] operation [" + pOp.getOpName() + "] role [" + role.getName() + "] perm not found, Fortress rc=" + 3006;
                    throw new UpdateException(3006, warning);
                }
                catch (LdapException e3) {
                    String error = "grant perm object [" + pOp.getObjName() + "] operation [" + pOp.getOpName() + "] name [" + role.getName() + "]  caught LdapException=" + (Object)((Object)e3);
                    throw new UpdateException(3012, error, (Exception)((Object)e3));
                }
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void revoke(Permission pOp, Role role) throws UpdateException, FinderException {
        LdapConnection ld = null;
        String dn = this.getDn(pOp, pOp.getContextId());
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            mods.add((Modification)new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, ROLES, new String[]{role.getName()}));
            ld = this.getAdminConnection();
            this.modify(ld, dn, mods, (FortEntity)pOp);
        }
        catch (LdapNoSuchAttributeException e) {
            try {
                String warning = "revoke perm object [" + pOp.getObjName() + "] operation [" + pOp.getOpName() + "] name [" + role.getName() + "] assignment does not exist.";
                throw new FinderException(3016, warning);
                catch (LdapException e2) {
                    String error = "revoke perm object [" + pOp.getObjName() + "] operation [" + pOp.getOpName() + "] name [" + role.getName() + "] caught LdapException=" + (Object)((Object)e2);
                    throw new UpdateException(3024, error, (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void grant(Permission pOp, User user) throws UpdateException {
        LdapConnection ld = null;
        String dn = this.getDn(pOp, pOp.getContextId());
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            mods.add((Modification)new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, USERS, new String[]{user.getUserId()}));
            ld = this.getAdminConnection();
            this.modify(ld, dn, mods, (FortEntity)pOp);
        }
        catch (LdapAttributeInUseException e) {
            try {
                String warning = "grant perm object [" + pOp.getObjName() + "] operation [" + pOp.getOpName() + "] userId [" + user.getUserId() + "] assignment already exists, Fortress rc=" + 3017;
                throw new UpdateException(3017, warning);
                catch (LdapNoSuchObjectException e2) {
                    warning = "grant perm object [" + pOp.getObjName() + "] operation [" + pOp.getOpName() + "] userId [" + user.getUserId() + "] perm not found, Fortress rc=" + 3006;
                    throw new UpdateException(3006, warning);
                }
                catch (LdapException e3) {
                    String error = "grant perm object [" + pOp.getObjName() + "] operation [" + pOp.getOpName() + "] userId [" + user.getUserId() + "] caught LdapException=" + (Object)((Object)e3);
                    throw new UpdateException(3013, error, (Exception)((Object)e3));
                }
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void revoke(Permission pOp, User user) throws UpdateException, FinderException {
        LdapConnection ld = null;
        String dn = this.getDn(pOp, pOp.getContextId());
        try {
            ArrayList<Modification> mods = new ArrayList<Modification>();
            mods.add((Modification)new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, USERS, new String[]{user.getUserId()}));
            ld = this.getAdminConnection();
            this.modify(ld, dn, mods, (FortEntity)pOp);
        }
        catch (LdapNoSuchAttributeException e) {
            try {
                String warning = "revoke perm object [" + pOp.getObjName() + "] operation [" + pOp.getOpName() + "] userId [" + user.getUserId() + "] assignment does not exist.";
                throw new FinderException(3018, warning);
                catch (LdapException e2) {
                    String error = "revoke perm object [" + pOp.getObjName() + "] operation [" + pOp.getOpName() + "] userId [" + user.getUserId() + "] caught LdapException=" + (Object)((Object)e2);
                    throw new UpdateException(3024, error, (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
    }

    Permission getPerm(Permission permission) throws FinderException {
        Permission entity = null;
        LdapConnection ld = null;
        String dn = PermDAO.getOpRdn(permission.getOpName(), permission.getObjId()) + "," + "ftObjNm" + "=" + permission.getObjName() + "," + this.getRootDn(permission.isAdmin(), permission.getContextId());
        try {
            ld = this.getAdminConnection();
            Entry findEntry = this.read(ld, dn, PERMISSION_OP_ATRS);
            if (findEntry == null) {
                String warning = "getPerm no entry found dn [" + dn + "]";
                throw new FinderException(3006, warning);
            }
            entity = this.unloadPopLdapEntry(findEntry, 0L, permission.isAdmin());
        }
        catch (LdapNoSuchObjectException e) {
            String warning = "getPerm Op COULD NOT FIND ENTRY for dn [" + dn + "]";
            throw new FinderException(3006, warning);
        }
        catch (LdapException e) {
            String error = "getUser [" + dn + "] caught LdapException=" + (Object)((Object)e);
            throw new FinderException(3001, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return entity;
    }

    PermObj getPerm(PermObj permObj) throws FinderException {
        PermObj entity = null;
        LdapConnection ld = null;
        String dn = "ftObjNm=" + permObj.getObjName() + "," + this.getRootDn(permObj.isAdmin(), permObj.getContextId());
        try {
            ld = this.getAdminConnection();
            Entry findEntry = this.read(ld, dn, PERMISION_OBJ_ATRS);
            if (findEntry == null) {
                String warning = "getPerm Obj no entry found dn [" + dn + "]";
                throw new FinderException(3007, warning);
            }
            entity = this.unloadPobjLdapEntry(findEntry, 0L, permObj.isAdmin());
        }
        catch (LdapNoSuchObjectException e) {
            String warning = "getPerm Obj COULD NOT FIND ENTRY for dn [" + dn + "]";
            throw new FinderException(3007, warning);
        }
        catch (LdapException e) {
            String error = "getPerm Obj dn [" + dn + "] caught LdapException=" + (Object)((Object)e);
            throw new FinderException(3002, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return entity;
    }

    PermissionAttributeSet getPermAttributeSet(PermissionAttributeSet permAttributeSet) throws FinderException {
        PermissionAttributeSet entity = null;
        LdapConnection ld = null;
        String dn = this.getDn(permAttributeSet, permAttributeSet.getContextId());
        try {
            ld = this.getAdminConnection();
            Entry findEntry = this.read(ld, dn, PERMISION_ATTRIBUTE_SET_ATRS);
            if (findEntry == null) {
                String warning = "getPermAttributeSet no entry found dn [" + dn + "]";
                throw new FinderException(3035, warning);
            }
            entity = this.unloadPASetLdapEntry(findEntry, 0L);
            entity.setAttributes(this.findPermissionAttributes(entity));
        }
        catch (LdapNoSuchObjectException e) {
            String warning = "getPermAttributeSet COULD NOT FIND ENTRY for dn [" + dn + "]";
            throw new FinderException(3035, warning);
        }
        catch (LdapException e) {
            String error = "getPermAttributeSet dn [" + dn + "] caught LdapException=" + (Object)((Object)e);
            throw new FinderException(3035, error, (Exception)((Object)e));
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return entity;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Set<PermissionAttribute> findPermissionAttributes(PermissionAttributeSet paSet) throws FinderException {
        HashSet<PermissionAttribute> paList = new HashSet<PermissionAttribute>();
        LdapConnection ld = null;
        String permRoot = this.getRootDn(paSet.getContextId());
        try {
            String paSetVal = this.encodeSafeText(paSet.getName(), 100);
            StringBuilder filterbuf = new StringBuilder();
            filterbuf.append("(&(objectClass=");
            filterbuf.append(PERMISSION_ATTRIBUTE_OBJECT_CLASS_NAME);
            filterbuf.append(")(");
            filterbuf.append(PERMISSION_ATTRIBUTE_SET);
            filterbuf.append("=");
            filterbuf.append(paSetVal);
            filterbuf.append("))");
            ld = this.getAdminConnection();
            SearchCursor searchResults = this.search(ld, permRoot, SearchScope.SUBTREE, filterbuf.toString(), PERMISION_ATTRIBUTE_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));
            long sequence = 0L;
            while (searchResults.next()) {
                paList.add(this.unloadPALdapEntry(searchResults.getEntry(), sequence++));
            }
        }
        catch (LdapException e) {
            try {
                String error = "findPermissionAttributes caught LdapException=" + (Object)((Object)e);
                throw new FinderException(3000, error, (Exception)((Object)e));
                catch (CursorException e2) {
                    error = "findPermissionAttributes caught CursorException=" + e2.getMessage();
                    throw new FinderException(3000, error, (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return paList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkPermission(Session session, Permission inPerm) throws FinderException {
        boolean isAuthZd = false;
        LdapConnection ld = null;
        String dn = PermDAO.getOpRdn(inPerm.getOpName(), inPerm.getObjId()) + "," + "ftObjNm" + "=" + inPerm.getObjName() + "," + this.getRootDn(inPerm.isAdmin(), inPerm.getContextId());
        try {
            ld = this.getAdminConnection();
            Entry entry = this.read(ld, dn, PERMISSION_OP_ATRS);
            if (entry == null) {
                String error = "checkPermission DOES NOT EXIST : obj name [" + inPerm.getObjName() + "], obj id [" + inPerm.getObjId() + "], op name [" + inPerm.getOpName() + "], idAdmin [" + inPerm.isAdmin() + "]";
                throw new FinderException(3029, error);
            }
            Permission outPerm = this.unloadPopLdapEntry(entry, 0L, inPerm.isAdmin());
            outPerm.setAdmin(inPerm.isAdmin());
            outPerm.setContextId(inPerm.getContextId());
            isAuthZd = this.isAuthorized(session, outPerm);
            String attributeValue = isAuthZd ? outPerm.getOpName() : outPerm.getOpName() + "%failed%";
            if (!session.isGroupSession()) {
                this.addAuthZAudit(ld, dn, session.getUser().getDn(), attributeValue);
            }
        }
        catch (LdapException e) {
            if (!(e instanceof LdapNoSuchObjectException)) {
                String error = "checkPermission caught LdapException=" + (Object)((Object)e);
                throw new FinderException(3001, error, (Exception)((Object)e));
            }
            if (!session.isGroupSession()) {
                this.addAuthZAudit(ld, dn, session.getUser().getDn(), "AuthZ Invalid");
            }
        }
        finally {
            this.closeAdminConnection(ld);
        }
        return isAuthZd;
    }

    private void addAuthZAudit(LdapConnection ld, String permDn, String userDn, String attributeValue) throws FinderException {
        block4: {
            if (Config.getInstance().isOpenldap() && !Config.getInstance().isAuditDisabled()) {
                try {
                    this.compareNode(ld, permDn, userDn, (Attribute)new DefaultAttribute("ftOpNm", new String[]{attributeValue}));
                }
                catch (UnsupportedEncodingException ee) {
                    String error = "addAuthZAudit caught UnsupportedEncodingException=" + ee.getMessage();
                    throw new FinderException(3028, error, ee);
                }
                catch (LdapException e) {
                    if (e instanceof LdapNoSuchObjectException) break block4;
                    String error = "addAuthZAudit caught LdapException=" + (Object)((Object)e);
                    throw new FinderException(3028, error, (Exception)((Object)e));
                }
            }
        }
    }

    private boolean isAuthorized(Session session, Permission permission) {
        boolean result;
        block5: {
            result = false;
            Set<String> userIds = permission.getUsers();
            if (!session.isGroupSession() && CollectionUtils.isNotEmpty(userIds) && userIds.contains(session.getUserId())) {
                return true;
            }
            Set<String> roles = permission.getRoles();
            if (!CollectionUtils.isNotEmpty(roles)) break block5;
            if (permission.isAdmin()) {
                Set<String> activatedRoles = AdminRoleUtil.getInheritedRoles(session.getAdminRoles(), permission.getContextId());
                for (String role : roles) {
                    if (!activatedRoles.contains(role)) continue;
                    result = true;
                    break;
                }
            } else {
                Set<String> activatedRoles = RoleUtil.getInstance().getInheritedRoles(session.getRoles(), permission.getContextId());
                for (String role : roles) {
                    if (!activatedRoles.contains(role)) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    private Permission unloadPopLdapEntry(Entry le, long sequence, boolean isAdmin) throws LdapInvalidAttributeValueException {
        Permission entity = new ObjectFactory().createPermission();
        entity.setSequenceId(sequence);
        entity.setAbstractName(this.getAttribute(le, PERM_NAME));
        entity.setObjName(this.getAttribute(le, "ftObjNm"));
        entity.setObjId(this.getAttribute(le, "ftObjId"));
        entity.setOpName(this.getAttribute(le, "ftOpNm"));
        entity.setInternalId(this.getAttribute(le, "ftId"));
        entity.setRoles(this.getAttributeSet(le, ROLES));
        entity.setUsers(this.getAttributeSet(le, USERS));
        entity.setType(this.getAttribute(le, "ftType"));
        entity.setDescription(this.getAttribute(le, "description"));
        entity.addProperties(PropUtil.getProperties(this.getAttributes(le, "ftProps")));
        entity.setAdmin(isAdmin);
        entity.setPaSets(this.getAttributeSet(le, PERMISSION_ATTRIBUTE_SET));
        if (le != null) {
            entity.setDn(le.getDn().getNormName());
        }
        return entity;
    }

    private PermObj unloadPobjLdapEntry(Entry le, long sequence, boolean isAdmin) throws LdapInvalidAttributeValueException {
        PermObj entity = new ObjectFactory().createPermObj();
        entity.setSequenceId(sequence);
        entity.setObjName(this.getAttribute(le, "ftObjNm"));
        entity.setOu(this.getAttribute(le, "ou"));
        entity.setDn(le.getDn().getName());
        entity.setInternalId(this.getAttribute(le, "ftId"));
        entity.setType(this.getAttribute(le, "ftType"));
        entity.setDescription(this.getAttribute(le, "description"));
        entity.addProperties(PropUtil.getProperties(this.getAttributes(le, "ftProps")));
        entity.setAdmin(isAdmin);
        return entity;
    }

    private PermissionAttributeSet unloadPASetLdapEntry(Entry le, long sequence) throws LdapInvalidAttributeValueException {
        PermissionAttributeSet entity = new ObjectFactory().createPermissionAttributeSet();
        entity.setSequenceId(sequence);
        entity.setName(this.getAttribute(le, "cn"));
        entity.setDn(le.getDn().getName());
        entity.setInternalId(this.getAttribute(le, "ftId"));
        entity.setDescription(this.getAttribute(le, "description"));
        entity.setType(this.getAttribute(le, "ftPASetType"));
        return entity;
    }

    private PermissionAttribute unloadPALdapEntry(Entry le, long sequence) throws LdapInvalidAttributeValueException {
        PermissionAttribute entity = new ObjectFactory().createPermissionAttribute();
        entity.setSequenceId(sequence);
        entity.setAttributeName(this.getAttribute(le, "cn"));
        entity.setDn(le.getDn().getName());
        entity.setInternalId(this.getAttribute(le, "ftId"));
        entity.setDescription(this.getAttribute(le, "description"));
        entity.setDataType(this.getAttribute(le, "ftPADataType"));
        entity.setDefaultOperator(this.getAttribute(le, "ftPADefaultOperator"));
        entity.setDefaultStrategy(this.getAttribute(le, "ftPADefaultStrategy"));
        entity.setDefaultValue(this.getAttribute(le, "ftPADefaultValue"));
        List<String> validValues = this.getAttributes(le, "ftPAValidVals");
        if (validValues != null) {
            for (String value : validValues) {
                entity.getValidValues().add(value);
            }
        }
        return entity;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<Permission> findPermissions(Permission permission) throws FinderException {
        ArrayList<Permission> permList = new ArrayList<Permission>();
        LdapConnection ld = null;
        String permRoot = this.getRootDn(permission.isAdmin(), permission.getContextId());
        try {
            String permObjVal = this.encodeSafeText(permission.getObjName(), 100);
            String permOpVal = this.encodeSafeText(permission.getOpName(), 100);
            StringBuilder filterbuf = new StringBuilder();
            filterbuf.append("(&(objectClass=");
            filterbuf.append(PERM_OP_OBJECT_CLASS_NAME);
            filterbuf.append(")(");
            filterbuf.append("ftObjNm");
            filterbuf.append("=");
            filterbuf.append(permObjVal);
            filterbuf.append("*)(");
            filterbuf.append("ftOpNm");
            filterbuf.append("=");
            filterbuf.append(permOpVal);
            filterbuf.append("*))");
            ld = this.getAdminConnection();
            SearchCursor searchResults = this.search(ld, permRoot, SearchScope.SUBTREE, filterbuf.toString(), PERMISSION_OP_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));
            long sequence = 0L;
            while (searchResults.next()) {
                permList.add(this.unloadPopLdapEntry(searchResults.getEntry(), sequence++, permission.isAdmin()));
            }
        }
        catch (LdapException e) {
            try {
                String error = "findPermissions caught LdapException=" + (Object)((Object)e);
                throw new FinderException(3000, error, (Exception)((Object)e));
                catch (CursorException e2) {
                    error = "findPermissions caught CursorException=" + e2.getMessage();
                    throw new FinderException(3000, error, (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return permList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<Permission> findPermissionOperations(PermObj permObj) throws FinderException {
        ArrayList<Permission> permList = new ArrayList<Permission>();
        LdapConnection ld = null;
        String permRoot = this.getRootDn(permObj.isAdmin(), permObj.getContextId());
        try {
            String permObjVal = this.encodeSafeText(permObj.getObjName(), 100);
            StringBuilder filterbuf = new StringBuilder();
            filterbuf.append("(&(objectClass=");
            filterbuf.append(PERM_OP_OBJECT_CLASS_NAME);
            filterbuf.append(")(");
            filterbuf.append("ftObjNm");
            filterbuf.append("=");
            filterbuf.append(permObjVal);
            filterbuf.append("))");
            ld = this.getAdminConnection();
            SearchCursor searchResults = this.search(ld, permRoot, SearchScope.SUBTREE, filterbuf.toString(), PERMISSION_OP_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));
            long sequence = 0L;
            while (searchResults.next()) {
                permList.add(this.unloadPopLdapEntry(searchResults.getEntry(), sequence++, permObj.isAdmin()));
            }
        }
        catch (LdapException e) {
            try {
                String error = "findPermissions caught LdapException=" + (Object)((Object)e);
                throw new FinderException(3000, error, (Exception)((Object)e));
                catch (CursorException e2) {
                    error = "findPermissions caught CursorException=" + e2.getMessage();
                    throw new FinderException(3000, error, (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return permList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<Permission> findAnyPermissions(Permission permission) throws FinderException {
        ArrayList<Permission> permList = new ArrayList<Permission>();
        LdapConnection ld = null;
        String permRoot = this.getRootDn(permission.isAdmin(), permission.getContextId());
        try {
            String permObjVal = this.encodeSafeText(permission.getObjName(), 100);
            String permOpVal = this.encodeSafeText(permission.getOpName(), 100);
            StringBuilder filterbuf = new StringBuilder();
            filterbuf.append("(&(objectClass=");
            filterbuf.append(PERM_OP_OBJECT_CLASS_NAME);
            filterbuf.append(")(|");
            if (permObjVal != null && permObjVal != "") {
                filterbuf.append("(");
                filterbuf.append("ftObjNm");
                filterbuf.append("=*");
                filterbuf.append(permObjVal);
                filterbuf.append("*)");
            }
            if (permOpVal != null && permOpVal != "") {
                filterbuf.append("(");
                filterbuf.append("ftOpNm");
                filterbuf.append("=*");
                filterbuf.append(permOpVal);
                filterbuf.append("*)");
            }
            filterbuf.append("))");
            ld = this.getAdminConnection();
            SearchCursor searchResults = this.search(ld, permRoot, SearchScope.SUBTREE, filterbuf.toString(), PERMISSION_OP_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));
            long sequence = 0L;
            while (searchResults.next()) {
                permList.add(this.unloadPopLdapEntry(searchResults.getEntry(), sequence++, permission.isAdmin()));
            }
        }
        catch (LdapException e) {
            try {
                String error = "findAnyPermissions caught LdapException=" + (Object)((Object)e);
                throw new FinderException(3000, error, (Exception)((Object)e));
                catch (CursorException e2) {
                    error = "findAnyPermissions caught CursorException=" + e2.getMessage();
                    throw new FinderException(3000, error, (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return permList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<PermObj> findPermissions(PermObj permObj) throws FinderException {
        ArrayList<PermObj> permList = new ArrayList<PermObj>();
        LdapConnection ld = null;
        String permRoot = this.getRootDn(permObj.isAdmin(), permObj.getContextId());
        try {
            String permObjVal = this.encodeSafeText(permObj.getObjName(), 100);
            StringBuilder filterbuf = new StringBuilder();
            filterbuf.append("(&(objectClass=");
            filterbuf.append(PERM_OBJ_OBJECT_CLASS_NAME);
            filterbuf.append(")(");
            filterbuf.append("ftObjNm");
            filterbuf.append("=");
            filterbuf.append(permObjVal);
            filterbuf.append("*))");
            ld = this.getAdminConnection();
            SearchCursor searchResults = this.search(ld, permRoot, SearchScope.SUBTREE, filterbuf.toString(), PERMISION_OBJ_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));
            long sequence = 0L;
            while (searchResults.next()) {
                permList.add(this.unloadPobjLdapEntry(searchResults.getEntry(), sequence++, permObj.isAdmin()));
            }
        }
        catch (LdapException e) {
            try {
                String error = "findPermissions caught LdapException=" + (Object)((Object)e);
                throw new FinderException(3000, error, (Exception)((Object)e));
                catch (CursorException e2) {
                    error = "findPermissions caught CursorException=" + e2.getMessage();
                    throw new FinderException(3000, error, (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return permList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<PermObj> findPermissions(OrgUnit ou, boolean limitSize) throws FinderException {
        ArrayList<PermObj> permList = new ArrayList<PermObj>();
        LdapConnection ld = null;
        String permRoot = PermDAO.getRootDn(ou.getContextId(), "perm.root");
        try {
            String ouVal = this.encodeSafeText(ou.getName(), 40);
            StringBuilder filterbuf = new StringBuilder();
            filterbuf.append("(&(objectClass=");
            filterbuf.append(PERM_OBJ_OBJECT_CLASS_NAME);
            filterbuf.append(")(");
            filterbuf.append("ou");
            filterbuf.append("=");
            filterbuf.append(ouVal);
            filterbuf.append("*))");
            int maxLimit = limitSize ? 10 : 0;
            ld = this.getAdminConnection();
            SearchCursor searchResults = this.search(ld, permRoot, SearchScope.SUBTREE, filterbuf.toString(), PERMISION_OBJ_ATRS, false, maxLimit);
            long sequence = 0L;
            while (searchResults.next()) {
                permList.add(this.unloadPobjLdapEntry(searchResults.getEntry(), sequence++, false));
            }
        }
        catch (LdapException e) {
            try {
                String error = "findPermissions caught LdapException=" + (Object)((Object)e);
                throw new FinderException(3000, error, (Exception)((Object)e));
                catch (CursorException e2) {
                    error = "findPermissions caught CursorException=" + e2.getMessage();
                    throw new FinderException(3000, error, (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return permList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<Permission> findPermissions(Role role, boolean noInheritance) throws FinderException {
        String permRoot;
        ArrayList<Permission> permList = new ArrayList<Permission>();
        LdapConnection ld = null;
        boolean isAdmin = false;
        if (role.getClass().equals(AdminRole.class)) {
            permRoot = PermDAO.getRootDn(role.getContextId(), "adminperm.root");
            isAdmin = true;
        } else {
            permRoot = PermDAO.getRootDn(role.getContextId(), "perm.root");
        }
        try {
            String roleVal = this.encodeSafeText(role.getName(), 40);
            StringBuilder filterbuf = new StringBuilder();
            filterbuf.append("(&(objectClass=");
            filterbuf.append(PERM_OP_OBJECT_CLASS_NAME);
            filterbuf.append(")(");
            Set<String> roles = null;
            if (!noInheritance) {
                roles = role.getClass().equals(AdminRole.class) ? AdminRoleUtil.getAscendants(role.getName(), role.getContextId()) : RoleUtil.getInstance().getAscendants(role.getName(), role.getContextId());
            }
            if (CollectionUtils.isNotEmpty(roles)) {
                filterbuf.append("|(");
                filterbuf.append(ROLES);
                filterbuf.append("=");
                filterbuf.append(roleVal);
                filterbuf.append(")");
                for (String uRole : roles) {
                    filterbuf.append("(");
                    filterbuf.append(ROLES);
                    filterbuf.append("=");
                    filterbuf.append(uRole);
                    filterbuf.append(")");
                }
                filterbuf.append(")");
            } else {
                filterbuf.append(ROLES);
                filterbuf.append("=");
                filterbuf.append(roleVal);
                filterbuf.append(")");
            }
            filterbuf.append(")");
            ld = this.getAdminConnection();
            SearchCursor searchResults = this.search(ld, permRoot, SearchScope.SUBTREE, filterbuf.toString(), PERMISSION_OP_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));
            long sequence = 0L;
            while (searchResults.next()) {
                permList.add(this.unloadPopLdapEntry(searchResults.getEntry(), sequence++, isAdmin));
            }
        }
        catch (LdapException e) {
            try {
                String error = "findPermissions caught LdapException=" + (Object)((Object)e);
                throw new FinderException(3019, error, (Exception)((Object)e));
                catch (CursorException e2) {
                    error = "findPermissions caught CursorException=" + e2.getMessage();
                    throw new FinderException(3019, error, (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return permList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<Permission> findPermissions(User user) throws FinderException {
        ArrayList<Permission> permList = new ArrayList<Permission>();
        LdapConnection ld = null;
        String permRoot = PermDAO.getRootDn(user.getContextId(), "perm.root");
        try {
            StringBuilder filterbuf = new StringBuilder();
            filterbuf.append("(&(objectClass=");
            filterbuf.append(PERM_OP_OBJECT_CLASS_NAME);
            filterbuf.append(")(|");
            Set<String> roles = RoleUtil.getInstance().getInheritedRoles(user.getRoles(), user.getContextId());
            if (CollectionUtils.isNotEmpty(roles)) {
                for (String uRole : roles) {
                    filterbuf.append("(");
                    filterbuf.append(ROLES);
                    filterbuf.append("=");
                    filterbuf.append(this.encodeSafeText(uRole, 40));
                    filterbuf.append(")");
                }
            }
            filterbuf.append("(");
            filterbuf.append(USERS);
            filterbuf.append("=");
            filterbuf.append(user.getUserId());
            filterbuf.append(")))");
            ld = this.getAdminConnection();
            SearchCursor searchResults = this.search(ld, permRoot, SearchScope.SUBTREE, filterbuf.toString(), PERMISSION_OP_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));
            long sequence = 0L;
            while (searchResults.next()) {
                permList.add(this.unloadPopLdapEntry(searchResults.getEntry(), sequence++, false));
            }
        }
        catch (LdapException e) {
            try {
                String error = "findPermissions user [" + user.getUserId() + "] caught LdapException in PermDAO.findPermissions=" + (Object)((Object)e);
                throw new FinderException(3020, error, (Exception)((Object)e));
                catch (CursorException e2) {
                    error = "findPermissions user [" + user.getUserId() + "] caught CursorException in PermDAO.findPermissions=" + e2.getMessage();
                    throw new FinderException(3020, error, (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return permList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<Permission> findUserPermissions(User user) throws FinderException {
        ArrayList<Permission> permList = new ArrayList<Permission>();
        LdapConnection ld = null;
        String permRoot = PermDAO.getRootDn(user.getContextId(), "perm.root");
        try {
            StringBuilder filterbuf = new StringBuilder();
            filterbuf.append("(&(objectClass=");
            filterbuf.append(PERM_OP_OBJECT_CLASS_NAME);
            filterbuf.append(")(");
            filterbuf.append(USERS);
            filterbuf.append("=");
            filterbuf.append(user.getUserId());
            filterbuf.append("))");
            ld = this.getAdminConnection();
            SearchCursor searchResults = this.search(ld, permRoot, SearchScope.SUBTREE, filterbuf.toString(), PERMISSION_OP_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));
            long sequence = 0L;
            while (searchResults.next()) {
                permList.add(this.unloadPopLdapEntry(searchResults.getEntry(), sequence++, false));
            }
        }
        catch (LdapException e) {
            try {
                String error = "findUserPermissions user [" + user.getUserId() + "] caught LdapException in PermDAO.findPermissions=" + (Object)((Object)e);
                throw new FinderException(3020, error, (Exception)((Object)e));
                catch (CursorException e2) {
                    error = "findUserPermissions user [" + user.getUserId() + "] caught CursorException in PermDAO.findPermissions=" + e2.getMessage();
                    throw new FinderException(3020, error, (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return permList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<Permission> findPermissions(Session session, boolean isAdmin) throws FinderException {
        ArrayList<Permission> permList = new ArrayList<Permission>();
        LdapConnection ld = null;
        String permRoot = this.getRootDn(isAdmin, session.getContextId());
        try {
            Set<String> roles;
            StringBuilder filterbuf = new StringBuilder();
            filterbuf.append("(&(objectClass=");
            filterbuf.append(PERM_OP_OBJECT_CLASS_NAME);
            filterbuf.append(")(|");
            if (!session.isGroupSession()) {
                filterbuf.append("(");
                filterbuf.append(USERS);
                filterbuf.append("=");
                filterbuf.append(session.getUserId());
                filterbuf.append(")");
            }
            if (CollectionUtils.isNotEmpty(roles = isAdmin ? AdminRoleUtil.getInheritedRoles(session.getAdminRoles(), session.getContextId()) : RoleUtil.getInstance().getInheritedRoles(session.getRoles(), session.getContextId()))) {
                for (String uRole : roles) {
                    filterbuf.append("(");
                    filterbuf.append(ROLES);
                    filterbuf.append("=");
                    filterbuf.append(uRole);
                    filterbuf.append(")");
                }
            }
            filterbuf.append("))");
            ld = this.getAdminConnection();
            SearchCursor searchResults = this.search(ld, permRoot, SearchScope.SUBTREE, filterbuf.toString(), PERMISSION_OP_ATRS, false, Config.getInstance().getInt("ldap.search.max.batch.size", 1000));
            long sequence = 0L;
            while (searchResults.next()) {
                permList.add(this.unloadPopLdapEntry(searchResults.getEntry(), sequence++, isAdmin));
            }
        }
        catch (LdapException e) {
            try {
                String error = "findPermissions user [" + session.getUserId() + "] caught LdapException in PermDAO.findPermissions=" + (Object)((Object)e);
                throw new FinderException(3021, error, (Exception)((Object)e));
                catch (CursorException e2) {
                    error = "findPermissions user [" + session.getUserId() + "] caught CursorException in PermDAO.findPermissions=" + e2.getMessage();
                    throw new FinderException(3021, error, (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                this.closeAdminConnection(ld);
                throw throwable;
            }
        }
        this.closeAdminConnection(ld);
        return permList;
    }

    static String getOpRdn(String opName, String objId) {
        String rDn = objId != null && objId.length() > 0 ? "ftOpNm=" + opName + "+" + "ftObjId" + "=" + objId : "ftOpNm=" + opName;
        return rDn;
    }

    protected String getDn(Permission pOp, String contextId) {
        return PermDAO.getOpRdn(pOp.getOpName(), pOp.getObjId()) + "," + "ftObjNm" + "=" + pOp.getObjName() + "," + this.getRootDn(pOp.isAdmin(), contextId);
    }

    protected String getDn(PermObj pObj, String contextId) {
        return "ftObjNm=" + pObj.getObjName() + "," + this.getRootDn(pObj.isAdmin(), contextId);
    }

    private String getDn(PermissionAttributeSet paSet, String contextId) {
        return "ou=" + paSet.getName() + "," + PermDAO.getRootDn(contextId, "sdconstraint.root");
    }

    private String getDn(PermissionAttribute pa, String paSetName, String contextId) {
        return "ftPA=" + pa.getAttributeName() + "," + "ou" + "=" + paSetName + "," + PermDAO.getRootDn(contextId, "sdconstraint.root");
    }

    private String getRootDn(boolean isAdmin, String contextId) {
        String dn = isAdmin ? PermDAO.getRootDn(contextId, "adminperm.root") : PermDAO.getRootDn(contextId, "perm.root");
        return dn;
    }
}

